/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemMarkerEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@NeedsEvaluatorArgument
public class PathSystem
extends Function {
    @Description(params={"internal", "startVertex", "fa"}, description="Returns a path system with the given root vertex, which is structured according to the given path description.", categories={Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public PathSystem() {
        super(1000L, 1L, 1.0);
    }

    public de.uni_koblenz.jgralab.greql.types.PathSystem evaluate(InternalGreqlEvaluator evaluator, Vertex startVertex, DFA dfa) {
        GraphMarker[] marker = new GraphMarker[dfa.stateList.size()];
        for (int i = 0; i < dfa.stateList.size(); ++i) {
            marker[i] = new GraphMarker(startVertex.getGraph());
        }
        Set<PathSystemMarkerEntry> leaves = this.markVerticesOfPathSystem(evaluator, marker, startVertex, dfa);
        de.uni_koblenz.jgralab.greql.types.PathSystem resultPathSystem = this.createPathSystemFromMarkings(marker, startVertex, leaves);
        return resultPathSystem;
    }

    protected PathSystemMarkerEntry markVertex(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, State s, Vertex parentVertex, Edge e, State ps, int d) {
        PathSystemMarkerEntry m = new PathSystemMarkerEntry(v, parentVertex, e, s, ps, d);
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[s.number];
        currentMarker.mark(v, m);
        return m;
    }

    protected boolean isMarked(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, State s) {
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[s.number];
        return currentMarker.isMarked(v);
    }

    private Set<PathSystemMarkerEntry> markVerticesOfPathSystem(InternalGreqlEvaluator evaluator, GraphMarker<PathSystemMarkerEntry>[] marker, Vertex startVertex, DFA dfa) {
        HashSet<PathSystemMarkerEntry> finalEntries = new HashSet<PathSystemMarkerEntry>();
        LinkedList<PathSystemMarkerEntry> queue = new LinkedList<PathSystemMarkerEntry>();
        PathSystemMarkerEntry currentEntry = this.markVertex(marker, startVertex, dfa.initialState, null, null, null, 0);
        if (dfa.initialState.isFinal) {
            finalEntries.add(currentEntry);
        }
        queue.add(currentEntry);
        while (!queue.isEmpty()) {
            currentEntry = (PathSystemMarkerEntry)queue.poll();
            Vertex currentVertex = currentEntry.vertex;
            for (Edge inc : currentVertex.incidences()) {
                for (Transition currentTransition : currentEntry.state.outTransitions) {
                    Vertex nextVertex = currentTransition.getNextVertex(currentVertex, inc);
                    if (this.isMarked(marker, nextVertex, currentTransition.endState) || !currentTransition.accepts(currentVertex, inc, evaluator)) continue;
                    Edge traversedEdge = currentTransition.consumesEdge() ? inc : null;
                    PathSystemMarkerEntry newEntry = this.markVertex(marker, nextVertex, currentTransition.endState, currentVertex, traversedEdge, currentEntry.state, currentEntry.distanceToRoot + 1);
                    if (currentTransition.endState.isFinal) {
                        finalEntries.add(newEntry);
                    }
                    queue.add(newEntry);
                }
            }
        }
        return finalEntries;
    }

    private de.uni_koblenz.jgralab.greql.types.PathSystem createPathSystemFromMarkings(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex rootVertex, Set<PathSystemMarkerEntry> leafEntries) {
        de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem = new de.uni_koblenz.jgralab.greql.types.PathSystem();
        HashMap<Vertex, PathSystem.PathSystemNode[]> vertex2state2node = new HashMap<Vertex, PathSystem.PathSystemNode[]>();
        HashMap<Vertex, PathSystemMarkerEntry[]> vertex2state2marker = new HashMap<Vertex, PathSystemMarkerEntry[]>();
        LinkedList<PathSystem.PathSystemNode> nodesWithoutParentEdge = new LinkedList<PathSystem.PathSystemNode>();
        PathSystemMarkerEntry rootMarker = (PathSystemMarkerEntry)marker[0].getMark(rootVertex);
        PathSystem.PathSystemNode root = pathSystem.setRootVertex(rootVertex, rootMarker.state.number, rootMarker.state.isFinal);
        PathSystem.PathSystemNode[] currentState2node = new PathSystem.PathSystemNode[marker.length];
        currentState2node[rootMarker.state.number] = root;
        vertex2state2node.put(rootVertex, currentState2node);
        for (PathSystemMarkerEntry currentMarker : leafEntries) {
            Vertex currentVertex = currentMarker.vertex;
            while (currentVertex != null) {
                PathSystem.PathSystemNode childNode = this.addVertexToPathSystem(pathSystem, vertex2state2node, marker.length, currentVertex, currentMarker.state.number, currentMarker.state.isFinal);
                if (currentMarker.edgeToParentVertex != null) {
                    PathSystem.PathSystemNode parentNode = this.addVertexToPathSystem(pathSystem, vertex2state2node, marker.length, currentMarker.parentVertex, currentMarker.parentState != null ? currentMarker.parentState.number : 0, currentMarker.parentState != null ? currentMarker.parentState.isFinal : false);
                    pathSystem.addEdge(childNode, parentNode, currentMarker.edgeToParentVertex);
                } else if (!(currentVertex == pathSystem.getRootVertex() && currentMarker.distanceToRoot == 0 || nodesWithoutParentEdge.contains(childNode))) {
                    nodesWithoutParentEdge.add(childNode);
                    PathSystemMarkerEntry[] currentMarkerEntry = (PathSystemMarkerEntry[])vertex2state2marker.get(currentVertex);
                    if (currentMarkerEntry == null) {
                        currentMarkerEntry = new PathSystemMarkerEntry[marker.length];
                        vertex2state2marker.put(currentVertex, currentMarkerEntry);
                    }
                    assert (currentMarkerEntry[currentMarker.state.number] == null) : "already exiting:" + currentMarkerEntry[currentMarker.state.number] + " new: " + currentMarker;
                    currentMarkerEntry[currentMarker.state.number] = currentMarker;
                }
                currentVertex = currentMarker.parentVertex;
                currentMarker = this.getMarkerWithState(marker, currentVertex, currentMarker.parentState);
            }
        }
        this.completePathSystem(pathSystem, nodesWithoutParentEdge, vertex2state2marker, vertex2state2node);
        pathSystem.finish();
        return pathSystem;
    }

    private PathSystem.PathSystemNode addVertexToPathSystem(de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem, Map<Vertex, PathSystem.PathSystemNode[]> vertex2state2node, int numberOfStates, Vertex currentVertex, int state, boolean isFinal) {
        PathSystem.PathSystemNode currentNode;
        assert (currentVertex != null);
        PathSystem.PathSystemNode[] currentState2node = vertex2state2node.get(currentVertex);
        if (currentState2node == null) {
            currentState2node = new PathSystem.PathSystemNode[numberOfStates];
            vertex2state2node.put(currentVertex, currentState2node);
        } else {
            currentNode = currentState2node[state];
            if (currentNode != null) {
                if (isFinal) {
                    pathSystem.addLeaf(currentNode);
                }
                return currentNode;
            }
        }
        currentState2node[state] = currentNode = pathSystem.addVertex(currentVertex, state, isFinal);
        return currentNode;
    }

    private void completePathSystem(de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem, Queue<PathSystem.PathSystemNode> nodesWithoutParentEdge, Map<Vertex, PathSystemMarkerEntry[]> vertex2state2marker, Map<Vertex, PathSystem.PathSystemNode[]> vertex2state2node) {
        while (!nodesWithoutParentEdge.isEmpty()) {
            PathSystem.PathSystemNode te = nodesWithoutParentEdge.poll();
            PathSystem.PathSystemNode pe = null;
            PathSystemMarkerEntry[] teMarker = vertex2state2marker.get(te.currentVertex);
            assert (teMarker != null);
            pe = teMarker[te.state] != null ? vertex2state2node.get(teMarker[te.state].parentVertex)[teMarker[te.state].parentState.number] : pathSystem.getRoot();
            if (pe == null) continue;
            Set<PathSystem.PathSystemNode> parents = pathSystem.getParents(pe);
            assert (parents.size() <= 1);
            for (PathSystem.PathSystemNode parent : parents) {
                pathSystem.addEdge(te, parent, pe.edge2parent);
            }
        }
    }

    private PathSystemMarkerEntry getMarkerWithState(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, State s) {
        if (v == null) {
            return null;
        }
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[s.number];
        PathSystemMarkerEntry entry = (PathSystemMarkerEntry)currentMarker.getMark(v);
        return entry;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return 1000L;
    }

    @Override
    public double getSelectivity() {
        return 0.001f;
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return 1L;
    }
}

