/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import org.pcollections.PCollection;

@NeedsGraphArgument
public class EdgeSetSubgraph
extends Function {
    @Description(params={"graph", "edgeSet"}, description="Returns the subgraph induced by the edge set, i.e. the egdes in edgeSet together with their alpha and omega vertices.", categories={Function.Category.GRAPH})
    public EdgeSetSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, PCollection<Edge> edgeSet) {
        SubGraphMarker subgraphMarker = new SubGraphMarker(graph);
        for (Edge currentEdge = graph.getFirstEdge(); currentEdge != null; currentEdge = currentEdge.getNextEdge()) {
            if (!edgeSet.contains(currentEdge)) continue;
            subgraphMarker.mark(currentEdge);
            subgraphMarker.mark(currentEdge.getAlpha());
            subgraphMarker.mark(currentEdge.getOmega());
        }
        return subgraphMarker;
    }
}

