/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Vertex;

public class VertexStateNumberQueue {
    protected static int initialSize = 100;
    public Vertex currentVertex = null;
    public int currentState = 0;
    int size = initialSize;
    Vertex[] vertices = new Vertex[initialSize];
    int[] states = new int[initialSize];
    int last = 0;
    int first = 0;

    public VertexStateNumberQueue() {
        this.size = initialSize;
    }

    public void put(Vertex v, int s) {
        if (this.last == this.first + this.size - 1) {
            this.resize();
        }
        this.vertices[this.last % this.size] = v;
        this.states[this.last % this.size] = s;
        ++this.last;
    }

    public boolean hasNext() {
        if (this.first == this.last) {
            return false;
        }
        this.currentVertex = this.vertices[this.first % this.size];
        this.currentState = this.states[this.first % this.size];
        ++this.first;
        return true;
    }

    private final void resize() {
        Vertex[] newVertices = new Vertex[this.size * 2];
        int[] newStates = new int[this.size * 2];
        for (int i = 0; i < this.size; ++i) {
            newVertices[i] = this.vertices[(this.first + i) % this.size];
            newStates[i] = this.states[(this.first + i) % this.size];
        }
        this.states = newStates;
        this.vertices = newVertices;
        this.last = this.size - 1;
        this.first = 0;
        this.size *= 2;
    }
}

