/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.exception;

import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.serialising.GreqlSerializer;
import java.util.ArrayList;
import java.util.List;

public class QuerySourceException
extends GreqlException {
    private static final long serialVersionUID = 8525494291742693931L;
    private List<SourcePosition> positions;
    private final GreqlVertex element;

    public QuerySourceException(String errorMessage, GreqlVertex element, List<SourcePosition> sourcePositions, Throwable cause) {
        super(errorMessage, cause);
        this.element = element;
        this.positions = sourcePositions != null ? sourcePositions : new ArrayList<SourcePosition>();
    }

    public QuerySourceException(String errorMessage, GreqlVertex element, SourcePosition sourcePosition, Exception cause) {
        super(errorMessage, cause);
        this.element = element;
        this.positions = new ArrayList<SourcePosition>();
        this.positions.add(sourcePosition);
    }

    public QuerySourceException(String errorMessage, GreqlVertex element, List<SourcePosition> sourcePositions) {
        this(errorMessage, element, sourcePositions, null);
    }

    public QuerySourceException(String errorMessage, GreqlVertex element, SourcePosition sourcePosition) {
        this(errorMessage, element, sourcePosition, null);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.positions.size() > 0) {
            sb.append(super.getMessage());
            sb.append(": query part '");
            sb.append(this.element != null ? GreqlSerializer.serializeVertex(this.element) : "<unknown element>");
            sb.append("' at position (");
            sb.append(this.positions.get(0).get_offset());
            sb.append(", ");
            sb.append(this.positions.get(0).get_length());
            sb.append(")");
        } else {
            sb.append(super.getMessage());
            sb.append(": query part '");
            sb.append(this.element != null ? GreqlSerializer.serializeVertex(this.element) : "<unknown element>");
            sb.append("' at unknown position in query");
        }
        if (this.element != null) {
            try {
                String serializedGraph = GreqlSerializer.serializeGraph((GreqlGraph)this.element.getGraph());
                sb.append("\nComplete (optimized) Query: ");
                sb.append(serializedGraph);
            }
            catch (GreqlException greqlException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public List<SourcePosition> getSourcePositions() {
        return this.positions;
    }

    public int getOffset() {
        if (this.positions.size() < 0) {
            return 0;
        }
        return this.positions.get(0).get_offset();
    }

    public int getLength() {
        if (this.positions.size() < 0) {
            return 0;
        }
        return this.positions.get(0).get_length();
    }

    public GreqlVertex getElement() {
        return this.element;
    }
}

