/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.exception.QuerySourceException;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PVector;

public abstract class VertexEvaluator<V extends GreqlVertex> {
    protected static Logger logger = Logger.getLogger(VertexEvaluator.class.getName());
    private static ArrayList<String> unevaluatedVertices = new ArrayList();
    protected V vertex;
    protected GreqlQueryImpl query;
    protected Set<Variable> neededVariables = null;
    protected Set<Variable> definedVariables = null;
    protected long currentSubtreeEvaluationCosts = Long.MIN_VALUE;
    protected long initialSubtreeEvaluationCosts = Long.MIN_VALUE;
    protected long ownEvaluationCosts = Long.MIN_VALUE;
    protected long iteratedEvaluationCosts = Long.MIN_VALUE;
    protected static final int transitionCosts = 10;
    protected static final int addToListCosts = 5;
    protected static final int addToSetCosts = 10;
    protected long estimatedCardinality = Long.MIN_VALUE;
    protected double estimatedSelectivity = Double.NaN;

    protected VertexEvaluator(V vertex, GreqlQueryImpl query) {
        this.vertex = vertex;
        this.query = query;
    }

    public V getVertex() {
        return this.vertex;
    }

    public String getLoggingName() {
        return this.getVertex().getAttributedElementClass().getSimpleName();
    }

    public Object getResult(InternalGreqlEvaluator evaluator) {
        Object result = evaluator.getLocalEvaluationResult((GreqlVertex)this.vertex);
        if (result != null) {
            return result;
        }
        try {
            result = this.evaluate(evaluator);
            evaluator.setLocalEvaluationResult((GreqlVertex)this.vertex, result);
        }
        catch (QuerySourceException ex) {
            this.removeInvalidSourcePosition(ex);
            throw ex;
        }
        return result;
    }

    public boolean isEvaluated(InternalGreqlEvaluator evaluator) {
        return evaluator.getLocalEvaluationResult((GreqlVertex)this.vertex) != null;
    }

    public abstract Object evaluate(InternalGreqlEvaluator var1);

    public final void clear(InternalGreqlEvaluator evaluator) {
        evaluator.removeLocalEvaluationResult((GreqlVertex)this.vertex);
    }

    public void resetToInitialState(InternalGreqlEvaluator evaluator) {
        if (evaluator != null) {
            evaluator.removeLocalEvaluationResult((GreqlVertex)this.vertex);
        }
        this.currentSubtreeEvaluationCosts = Long.MIN_VALUE;
        this.initialSubtreeEvaluationCosts = Long.MIN_VALUE;
        this.ownEvaluationCosts = Long.MIN_VALUE;
        this.iteratedEvaluationCosts = Long.MIN_VALUE;
        this.estimatedCardinality = Long.MIN_VALUE;
        this.estimatedSelectivity = Double.NaN;
    }

    public void resetSubtreeToInitialState(InternalGreqlEvaluator evaluator) {
        this.resetToInitialState(evaluator);
        for (Edge e : this.getVertex().incidences(EdgeDirection.IN)) {
            GreqlVertex vertex = (GreqlVertex)e.getThat();
            VertexEvaluator<GreqlVertex> eval = this.query.getVertexEvaluator(vertex);
            if (eval == null) continue;
            eval.resetSubtreeToInitialState(evaluator);
        }
    }

    protected abstract VertexCosts calculateSubtreeEvaluationCosts();

    public long getCurrentSubtreeEvaluationCosts() {
        if (this.currentSubtreeEvaluationCosts == Long.MIN_VALUE) {
            return this.getInitialSubtreeEvaluationCosts();
        }
        return 1L;
    }

    public long getInitialSubtreeEvaluationCosts() {
        if (this.initialSubtreeEvaluationCosts > 0L) {
            return this.initialSubtreeEvaluationCosts;
        }
        VertexCosts costs = this.calculateSubtreeEvaluationCosts();
        this.ownEvaluationCosts = costs.ownEvaluationCosts;
        this.iteratedEvaluationCosts = costs.iteratedEvaluationCosts;
        this.currentSubtreeEvaluationCosts = costs.subtreeEvaluationCosts;
        this.initialSubtreeEvaluationCosts = costs.subtreeEvaluationCosts;
        return this.initialSubtreeEvaluationCosts;
    }

    public long getOwnEvaluationCosts() {
        if (this.ownEvaluationCosts == Long.MIN_VALUE) {
            this.getInitialSubtreeEvaluationCosts();
        }
        return this.ownEvaluationCosts;
    }

    public void calculateNeededAndDefinedVariables() {
        this.neededVariables = new HashSet<Variable>();
        this.definedVariables = new HashSet<Variable>();
        for (Edge inc = this.getVertex().getFirstIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIncidence(EdgeDirection.IN)) {
            VertexEvaluator<GreqlVertex> veval = this.query.getVertexEvaluator((GreqlVertex)inc.getAlpha());
            if (veval == null) continue;
            this.neededVariables.addAll(veval.getNeededVariables());
            this.definedVariables.addAll(veval.getDefinedVariables());
        }
        HashSet<Variable> bothVariables = new HashSet<Variable>();
        bothVariables.addAll(this.neededVariables);
        this.neededVariables.removeAll(this.definedVariables);
        this.definedVariables.removeAll(bothVariables);
    }

    public Set<Variable> getNeededVariables() {
        if (this.neededVariables == null) {
            this.calculateNeededAndDefinedVariables();
        }
        return this.neededVariables;
    }

    public Set<Variable> getDefinedVariables() {
        if (this.definedVariables == null) {
            this.calculateNeededAndDefinedVariables();
        }
        return this.definedVariables;
    }

    public long getVariableCombinations() {
        int combinations = 1;
        Iterator<Variable> iter = this.getNeededVariables().iterator();
        while (iter.hasNext()) {
            VariableEvaluator veval = (VariableEvaluator)this.query.getVertexEvaluator((GreqlVertex)iter.next());
            combinations = (int)((long)combinations * veval.getVariableCombinations());
        }
        return combinations;
    }

    public long getEstimatedCardinality() {
        if (this.estimatedCardinality == Long.MIN_VALUE) {
            this.estimatedCardinality = this.calculateEstimatedCardinality();
        }
        return this.estimatedCardinality;
    }

    public long calculateEstimatedCardinality() {
        return 1L;
    }

    public double getEstimatedSelectivity() {
        if (Double.isNaN(this.estimatedSelectivity)) {
            this.estimatedSelectivity = this.calculateEstimatedSelectivity();
        }
        return this.estimatedSelectivity;
    }

    public double calculateEstimatedSelectivity() {
        return 1.0;
    }

    public List<SourcePosition> createPossibleSourcePositions() {
        ArrayList<SourcePosition> possibleSourcePositions = new ArrayList<SourcePosition>();
        for (GreqlAggregation inc = (GreqlAggregation)this.getVertex().getFirstIncidence(EdgeDirection.OUT); inc != null; inc = inc.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
            PVector<SourcePosition> sourcePositions = inc.get_sourcePositions();
            possibleSourcePositions.addAll(sourcePositions);
        }
        return possibleSourcePositions;
    }

    protected List<SourcePosition> createSourcePositions(GreqlAggregation edge) {
        ArrayList<SourcePosition> possibleSourcePositions = new ArrayList<SourcePosition>();
        PVector<SourcePosition> sourcePositions = edge.get_sourcePositions();
        possibleSourcePositions.addAll(sourcePositions);
        return possibleSourcePositions;
    }

    private void removeInvalidSourcePosition(QuerySourceException ex) {
        ArrayList<SourcePosition> possibleSourcePositions = new ArrayList<SourcePosition>();
        for (GreqlAggregation inc = (GreqlAggregation)this.getVertex().getFirstIncidence(EdgeDirection.OUT); inc != null; inc = inc.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
            PVector<SourcePosition> sourcePositions = inc.get_sourcePositions();
            possibleSourcePositions.addAll(sourcePositions);
        }
        if (possibleSourcePositions.size() == 0) {
            return;
        }
        Iterator<SourcePosition> iter = ex.getSourcePositions().iterator();
        while (iter.hasNext()) {
            boolean accepted = false;
            SourcePosition currentPosition = iter.next();
            for (SourcePosition availablePosition : possibleSourcePositions) {
                if (availablePosition.get_offset() > currentPosition.get_offset() || availablePosition.get_offset() + availablePosition.get_length() < currentPosition.get_offset() + currentPosition.get_length()) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            iter.remove();
        }
    }

    public static <V extends GreqlVertex> VertexEvaluator<V> createVertexEvaluator(V vertex, GreqlQueryImpl query) {
        Class<?> vertexClass = vertex.getClass();
        String fullClassName = vertexClass.getName();
        fullClassName = fullClassName.substring(0, fullClassName.length() - 4);
        String className = (fullClassName = fullClassName.replaceFirst(".impl.std.", ".")).substring(fullClassName.lastIndexOf(".") + 1);
        if (unevaluatedVertices.contains(className)) {
            return null;
        }
        String evalName = className + "Evaluator";
        evalName = evalName.substring(className.lastIndexOf(".") + 1);
        evalName = VertexEvaluator.class.getPackage().getName() + "." + evalName;
        try {
            Class[] argsClass = new Class[]{Class.forName(fullClassName), GreqlQueryImpl.class};
            Class<?> evalClass = Class.forName(evalName);
            Constructor<?> constructor = evalClass.getConstructor(argsClass);
            VertexEvaluator vertexEval = (VertexEvaluator)constructor.newInstance(vertex, query);
            return vertexEval;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(className, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(className, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(className, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(className, ex);
        }
    }

    static {
        unevaluatedVertices.add("Quantifier");
        unevaluatedVertices.add("RoleId");
        unevaluatedVertices.add("FunctionId");
        unevaluatedVertices.add("RecordId");
        unevaluatedVertices.add("Direction");
    }
}

