/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ValueConstructionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import org.pcollections.PCollection;

public class TupleConstructionEvaluator
extends ValueConstructionEvaluator<TupleConstruction> {
    protected static final int addToTupleCosts = 5;

    public TupleConstructionEvaluator(TupleConstruction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public PCollection<Object> evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        return this.createValue(Tuple.empty(), evaluator);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        TupleConstruction tupCons = (TupleConstruction)this.getVertex();
        long parts = 0L;
        long partCosts = 0L;
        for (IsPartOf inc = tupCons.getFirstIsPartOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsPartOfIncidence(EdgeDirection.IN)) {
            VertexEvaluator<Expression> veval = this.query.getVertexEvaluator(inc.getAlpha());
            partCosts += veval.getCurrentSubtreeEvaluationCosts();
            ++parts;
        }
        long ownCosts = parts * 5L + 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + partCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        TupleConstruction tupleCons = (TupleConstruction)this.getVertex();
        long parts = 0L;
        for (IsPartOf inc = tupleCons.getFirstIsPartOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsPartOfIncidence(EdgeDirection.IN)) {
            ++parts;
        }
        return parts;
    }
}

