/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ValueConstructionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.ListConstruction;
import org.pcollections.PCollection;

public class ListConstructionEvaluator
extends ValueConstructionEvaluator<ListConstruction> {
    public ListConstructionEvaluator(ListConstruction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public PCollection<Object> evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        return this.createValue(JGraLab.vector(), evaluator);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ListConstruction listCons = (ListConstruction)this.getVertex();
        long parts = 0L;
        long partCosts = 0L;
        for (IsPartOf inc = listCons.getFirstIsPartOfIncidence(); inc != null; inc = inc.getNextIsPartOfIncidence()) {
            VertexEvaluator<Expression> veval = this.query.getVertexEvaluator(inc.getAlpha());
            partCosts += veval.getCurrentSubtreeEvaluationCosts();
            ++parts;
        }
        long ownCosts = parts * 5L + 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + partCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        ListConstruction listCons = (ListConstruction)this.getVertex();
        long parts = 0L;
        for (IsPartOf inc = listCons.getFirstIsPartOfIncidence(); inc != null; inc = inc.getNextIsPartOfIncidence()) {
            ++parts;
        }
        return parts;
    }
}

