/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsBooleanPredicateOfEdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.IsRoleIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeIdOf;
import de.uni_koblenz.jgralab.greql.schema.RoleId;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import java.util.HashSet;
import java.util.Set;

public class EdgeRestrictionEvaluator
extends VertexEvaluator<EdgeRestriction> {
    private VertexEvaluator<? extends Expression> predicateEvaluator = null;
    private TypeCollection typeCollection = null;
    private Set<String> validRoles;

    public VertexEvaluator<? extends Expression> getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public TypeCollection getTypeCollection(InternalGreqlEvaluator evaluator) {
        if (this.typeCollection == null) {
            this.evaluate(evaluator);
        }
        return this.typeCollection;
    }

    public Set<String> getEdgeRoles() {
        return this.validRoles;
    }

    public EdgeRestrictionEvaluator(EdgeRestriction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        IsBooleanPredicateOfEdgeRestriction predInc;
        evaluator.progress(this.getOwnEvaluationCosts());
        if (this.typeCollection == null) {
            this.typeCollection = TypeCollection.empty();
            for (IsTypeIdOf typeInc = ((EdgeRestriction)this.vertex).getFirstIsTypeIdOfIncidence(EdgeDirection.IN); typeInc != null; typeInc = typeInc.getNextIsTypeIdOfIncidence(EdgeDirection.IN)) {
                TypeIdEvaluator typeEval = (TypeIdEvaluator)this.query.getVertexEvaluator(typeInc.getAlpha());
                this.typeCollection = this.typeCollection.combine((TypeCollection)typeEval.getResult(evaluator));
            }
        }
        try {
            this.typeCollection = this.typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        if (((EdgeRestriction)this.vertex).getFirstIsRoleIdOfIncidence() != null) {
            this.validRoles = new HashSet<String>();
            for (IsRoleIdOf e : ((EdgeRestriction)this.vertex).getIsRoleIdOfIncidences()) {
                RoleId role = e.getAlpha();
                this.validRoles.add(role.get_name());
            }
        }
        if ((predInc = ((EdgeRestriction)this.vertex).getFirstIsBooleanPredicateOfEdgeRestrictionIncidence(EdgeDirection.IN)) != null) {
            this.predicateEvaluator = this.query.getVertexEvaluator(predInc.getAlpha());
        }
        return null;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        EdgeRestriction er = (EdgeRestriction)this.getVertex();
        long subtreeCosts = 0L;
        if (er.getFirstIsTypeIdOfIncidence(EdgeDirection.IN) != null) {
            TypeIdEvaluator tEval = (TypeIdEvaluator)this.query.getVertexEvaluator(er.getFirstIsTypeIdOfIncidence(EdgeDirection.IN).getAlpha());
            subtreeCosts += tEval.getCurrentSubtreeEvaluationCosts();
        }
        if (er.getFirstIsRoleIdOfIncidence(EdgeDirection.IN) != null) {
            ++subtreeCosts;
        }
        return new VertexCosts(10L, 10L, subtreeCosts + 10L);
    }
}

