/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.EdgeRestrictionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PrimaryPathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.AggregationPathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeRestrOf;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class AggregationPathDescriptionEvaluator
extends PrimaryPathDescriptionEvaluator<AggregationPathDescription> {
    public AggregationPathDescriptionEvaluator(AggregationPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        TypeCollection typeCollection = TypeCollection.empty();
        IsEdgeRestrOf inc = ((AggregationPathDescription)this.vertex).getFirstIsEdgeRestrOfIncidence(EdgeDirection.IN);
        EdgeRestrictionEvaluator edgeRestEval = null;
        VertexEvaluator<? extends Expression> predicateEvaluator = null;
        if (inc != null) {
            edgeRestEval = (EdgeRestrictionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            typeCollection = typeCollection.combine(edgeRestEval.getTypeCollection(evaluator));
            predicateEvaluator = edgeRestEval.getPredicateEvaluator();
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA createdNFA = NFA.createAggregationPathDescriptionNFA(((AggregationPathDescription)this.vertex).is_outAggregation(), typeCollection, this.getEdgeRoles(edgeRestEval), predicateEvaluator, this.query);
        evaluator.setLocalEvaluationResult(this.vertex, createdNFA);
        return createdNFA;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        return new VertexCosts(10L, 10L, 10L);
    }
}

