/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.fa.AggregationTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.BoolExpressionTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.EdgeTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.EpsilonTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.fa.IntermediateVertexTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.SimpleTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.VertexTypeRestrictionTransition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NFA
extends FiniteAutomaton {
    private DFA dfa = null;

    @Override
    public DFA getDFA() {
        if (this.dfa == null) {
            this.dfa = new DFA(this);
        }
        return this.dfa;
    }

    protected NFA(NFA nfaToCopy) {
        HashMap<Integer, State> oldStateToNewStateMap = new HashMap<Integer, State>();
        nfaToCopy.updateStateAttributes();
        this.finalStates = new ArrayList();
        this.stateList = new ArrayList();
        this.transitionList = new ArrayList();
        for (State currentState : nfaToCopy.stateList) {
            State newState = new State();
            newState.number = currentState.number;
            if (nfaToCopy.finalStates.contains(currentState)) {
                this.finalStates.add(newState);
            }
            if (nfaToCopy.initialState == currentState) {
                this.initialState = newState;
            }
            oldStateToNewStateMap.put(currentState.number, newState);
            this.stateList.add(newState);
        }
        this.updateStateAttributes();
        for (Transition currentTransition : nfaToCopy.transitionList) {
            Transition newTransition = currentTransition.copy(false);
            this.transitionList.add(newTransition);
            State startState = (State)oldStateToNewStateMap.get(currentTransition.getStartState().number);
            State endState = (State)oldStateToNewStateMap.get(currentTransition.endState.number);
            newTransition.setStartState(startState);
            newTransition.setEndState(endState);
        }
        this.updateStateAttributes();
    }

    public static NFA createIteratedPathDescriptionNFA(NFA iteratedNFA, boolean optional) {
        State newFinalState = new State();
        iteratedNFA.constructFinalStatesEpsilonTransitions(newFinalState, true);
        iteratedNFA.stateList.add(newFinalState);
        iteratedNFA.finalStates.add(newFinalState);
        EpsilonTransition t = new EpsilonTransition(newFinalState, iteratedNFA.initialState);
        iteratedNFA.transitionList.add(t);
        if (optional) {
            iteratedNFA.initialState.isFinal = true;
            iteratedNFA.finalStates.add(iteratedNFA.initialState);
        }
        iteratedNFA.updateStateAttributes();
        return iteratedNFA;
    }

    public static NFA createSequentialPathDescriptionNFA(List<NFA> nfaList) {
        NFA resultNFA = nfaList.get(0);
        for (int i = 1; i < nfaList.size(); ++i) {
            NFA nextNFA = nfaList.get(i);
            resultNFA.constructFinalStatesEpsilonTransitions(nextNFA.initialState, true);
            resultNFA.stateList.addAll(nextNFA.stateList);
            resultNFA.finalStates.addAll(nextNFA.finalStates);
            resultNFA.transitionList.addAll(nextNFA.transitionList);
        }
        resultNFA.updateStateAttributes();
        return resultNFA;
    }

    public static NFA createAlternativePathDescriptionNFA(List<NFA> nfaList) {
        NFA resultNFA = new NFA();
        State finalState = new State();
        State initialState = new State();
        resultNFA.stateList.add(initialState);
        resultNFA.stateList.add(finalState);
        resultNFA.initialState = initialState;
        resultNFA.finalStates.add(finalState);
        for (int i = 0; i < nfaList.size(); ++i) {
            NFA nextNFA = nfaList.get(i);
            EpsilonTransition t = new EpsilonTransition(resultNFA.initialState, nextNFA.initialState);
            resultNFA.transitionList.add(t);
            nextNFA.constructFinalStatesEpsilonTransitions(finalState, true);
            resultNFA.stateList.addAll(nextNFA.stateList);
            resultNFA.transitionList.addAll(nextNFA.transitionList);
        }
        resultNFA.updateStateAttributes();
        return resultNFA;
    }

    public static NFA createOptionalPathDescriptionNFA(NFA optionalNFA) {
        EpsilonTransition t = new EpsilonTransition(optionalNFA.initialState, (State)optionalNFA.finalStates.get(0));
        optionalNFA.transitionList.add(t);
        optionalNFA.updateStateAttributes();
        return optionalNFA;
    }

    public static NFA revertNFA(NFA nfa) {
        for (Transition t : nfa.transitionList) {
            t.reverse();
        }
        State newInitialState = null;
        if (nfa.finalStates.size() > 1) {
            newInitialState = new State();
            nfa.stateList.add(newInitialState);
            for (State s : nfa.finalStates) {
                EpsilonTransition t = new EpsilonTransition(newInitialState, s);
                nfa.transitionList.add(t);
            }
        } else {
            newInitialState = (State)nfa.finalStates.get(0);
        }
        nfa.finalStates = new ArrayList();
        nfa.finalStates.add(nfa.initialState);
        nfa.initialState = newInitialState;
        nfa.updateStateAttributes();
        return nfa;
    }

    public static NFA createTransposedPathDescriptionNFA(NFA transposedNFA) {
        return NFA.revertNFA(transposedNFA);
    }

    public static NFA createExponentiatedPathDescriptionNFA(NFA exponentiatedNFA, int exponent) {
        NFA nfaToCopy = new NFA(exponentiatedNFA);
        for (int i = 1; i < exponent; ++i) {
            NFA nextIterationNFA = new NFA(nfaToCopy);
            exponentiatedNFA.constructFinalStatesEpsilonTransitions(nextIterationNFA.initialState, true);
            exponentiatedNFA.finalStates.addAll(nextIterationNFA.finalStates);
            exponentiatedNFA.stateList.addAll(nextIterationNFA.stateList);
            exponentiatedNFA.transitionList.addAll(nextIterationNFA.transitionList);
        }
        exponentiatedNFA.updateStateAttributes();
        return exponentiatedNFA;
    }

    public static NFA createIntermediateVertexPathDescriptionNFA(NFA firstNFA, VertexEvaluator<?> intermediateVertices, NFA secondNFA) {
        State newFinalState = new State();
        firstNFA.stateList.add(newFinalState);
        firstNFA.constructFinalStatesEpsilonTransitions(newFinalState, true);
        IntermediateVertexTransition t = new IntermediateVertexTransition(newFinalState, secondNFA.initialState, intermediateVertices);
        firstNFA.transitionList.add(t);
        firstNFA.stateList.addAll(secondNFA.stateList);
        firstNFA.finalStates.addAll(secondNFA.finalStates);
        firstNFA.transitionList.addAll(secondNFA.transitionList);
        firstNFA.updateStateAttributes();
        return firstNFA;
    }

    public static NFA createEdgePathDescriptionNFA(GReQLDirection dir, TypeCollection typeCollection, Set<String> roles, VertexEvaluator<?> edgeEval, VertexEvaluator<? extends Expression> predicateEvaluator, GreqlQueryImpl query) {
        NFA nfa = new NFA();
        nfa.transitionList.clear();
        nfa.initialState.outTransitions.clear();
        ((State)nfa.finalStates.get((int)0)).inTransitions.clear();
        EdgeTransition t = new EdgeTransition(nfa.initialState, (State)nfa.finalStates.get(0), dir, typeCollection, roles, edgeEval, predicateEvaluator, query);
        nfa.transitionList.add(t);
        nfa.updateStateAttributes();
        return nfa;
    }

    public static NFA createSimplePathDescriptionNFA(GReQLDirection dir, TypeCollection typeCollection, Set<String> roles, VertexEvaluator<? extends Expression> predicateEvaluator, GreqlQueryImpl query) {
        NFA nfa = new NFA();
        nfa.transitionList.clear();
        nfa.initialState.outTransitions.clear();
        ((State)nfa.finalStates.get((int)0)).inTransitions.clear();
        SimpleTransition t = new SimpleTransition(nfa.initialState, (State)nfa.finalStates.get(0), dir, typeCollection, roles, predicateEvaluator, query);
        nfa.transitionList.add(t);
        nfa.updateStateAttributes();
        return nfa;
    }

    public static NFA createAggregationPathDescriptionNFA(boolean aggregateFrom, TypeCollection typeCollection, Set<String> roles, VertexEvaluator<? extends Expression> predicateEvaluator, GreqlQueryImpl query) {
        NFA nfa = new NFA();
        nfa.transitionList.clear();
        nfa.initialState.outTransitions.clear();
        ((State)nfa.finalStates.get((int)0)).inTransitions.clear();
        AggregationTransition t = new AggregationTransition(nfa.initialState, (State)nfa.finalStates.get(0), aggregateFrom, typeCollection, roles, predicateEvaluator, query);
        nfa.transitionList.add(t);
        nfa.updateStateAttributes();
        return nfa;
    }

    protected NFA() {
        this.finalStates = new ArrayList();
        this.transitionList = new ArrayList();
        this.stateList = new ArrayList();
        this.initialState = new State();
        State finalState = new State();
        this.finalStates.add(finalState);
        this.stateList.add(this.initialState);
        this.stateList.add(finalState);
        EpsilonTransition t = new EpsilonTransition(this.initialState, finalState);
        this.transitionList.add(t);
    }

    public static void addGoalTypeRestriction(NFA nfa, TypeCollection typeCollection) {
        State newEndState;
        if (nfa.finalStates.size() == 1) {
            newEndState = (State)nfa.finalStates.get(0);
            newEndState.isFinal = false;
            nfa.finalStates.clear();
        } else {
            newEndState = new State();
            nfa.constructFinalStatesEpsilonTransitions(newEndState, false);
            nfa.stateList.add(newEndState);
            for (State s : nfa.finalStates) {
                s.isFinal = false;
            }
            nfa.finalStates.clear();
        }
        State restrictedFinalState = new State();
        nfa.stateList.add(restrictedFinalState);
        nfa.finalStates.add(restrictedFinalState);
        VertexTypeRestrictionTransition trans = new VertexTypeRestrictionTransition(newEndState, restrictedFinalState, typeCollection);
        nfa.transitionList.add(trans);
    }

    public static void addGoalBooleanRestriction(NFA nfa, VertexEvaluator<? extends Expression> boolEval, GreqlQueryImpl query) {
        State newEndState;
        if (nfa.finalStates.size() == 1) {
            newEndState = (State)nfa.finalStates.get(0);
            newEndState.isFinal = false;
            nfa.finalStates.clear();
        } else {
            newEndState = new State();
            nfa.constructFinalStatesEpsilonTransitions(newEndState, false);
            nfa.stateList.add(newEndState);
            for (State s : nfa.finalStates) {
                s.isFinal = false;
            }
            nfa.finalStates.clear();
        }
        State restrictedFinalState = new State();
        nfa.stateList.add(restrictedFinalState);
        nfa.finalStates.add(restrictedFinalState);
        BoolExpressionTransition trans = new BoolExpressionTransition(newEndState, restrictedFinalState, boolEval, query);
        nfa.transitionList.add(trans);
    }

    public static void addStartBooleanRestriction(NFA nfa, VertexEvaluator<? extends Expression> boolEval, GreqlQueryImpl query) {
        State newInitialState = new State();
        nfa.stateList.add(newInitialState);
        BoolExpressionTransition trans = new BoolExpressionTransition(newInitialState, nfa.initialState, boolEval, query);
        nfa.transitionList.add(trans);
        nfa.initialState = newInitialState;
    }

    public static void addStartTypeRestriction(NFA nfa, TypeCollection typeCollection) {
        State newInitialState = new State();
        nfa.stateList.add(newInitialState);
        VertexTypeRestrictionTransition trans = new VertexTypeRestrictionTransition(newInitialState, nfa.initialState, typeCollection);
        nfa.transitionList.add(trans);
        nfa.initialState = newInitialState;
    }

    protected void constructFinalStatesEpsilonTransitions(State target, boolean removeFinalStates) {
        Iterator iter = this.finalStates.iterator();
        while (iter.hasNext()) {
            EpsilonTransition t = new EpsilonTransition((State)iter.next(), target);
            this.transitionList.add(t);
            if (!removeFinalStates) continue;
            iter.remove();
        }
    }
}

