/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphStructureChangedListener;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.NullOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.parser.GreqlParser;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PSet;

public class GreqlQueryImpl
extends GreqlQuery
implements GraphStructureChangedListener {
    private final String queryText;
    private GreqlGraph queryGraph;
    private PSet<String> usedVariables;
    private PSet<String> storedVariables;
    private final Optimizer optimizer;
    private GreqlExpression rootExpression;
    private static Logger logger = JGraLab.getLogger(GreqlQueryImpl.class);
    public static boolean DEBUG_OPTIMIZATION = Boolean.parseBoolean(System.getProperty("greqlDebugOptimization", "false"));
    private GraphMarker<VertexEvaluator<? extends GreqlVertex>> vertexEvaluators;
    private static SoftReference<Object> tg2DotReference;
    private static Class<?> tg2DotClass;

    public GreqlQueryImpl(String queryText) {
        this(queryText, new DefaultOptimizer(new DefaultOptimizerInfo()));
    }

    public GreqlQueryImpl(String queryText, Optimizer optimizer) {
        this.queryText = queryText;
        this.optimizer = optimizer == null ? NullOptimizer.instance() : optimizer;
        this.initializeQueryGraph();
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public GreqlGraph getQueryGraph() {
        return this.queryGraph;
    }

    public <V extends GreqlVertex> VertexEvaluator<V> getVertexEvaluator(V vertex) {
        return (VertexEvaluator)this.vertexEvaluators.get(vertex);
    }

    private void initializeQueryGraph() {
        if (this.queryGraph != null) {
            return;
        }
        long t0 = System.currentTimeMillis();
        this.queryGraph = GreqlParserWithVertexEvaluatorUpdates.parse(this.queryText, this, new HashSet<String>());
        if (this.queryGraph.getVCount() == 0) {
            GreqlExpression gexpr = this.queryGraph.createGreqlExpression();
            UndefinedLiteral undefined = this.queryGraph.createUndefinedLiteral();
            gexpr.add_queryExpr(undefined);
        }
        long t1 = System.currentTimeMillis();
        logger.fine("GReQL parser: " + (t1 - t0) + " ms, v/eCount=" + this.queryGraph.getVCount() + "/" + this.queryGraph.getECount() + ", v/eMax=" + ((GraphImpl)((Object)this.queryGraph)).getMaxVCount() + "/" + ((GraphImpl)((Object)this.queryGraph)).getMaxECount());
        if (this.optimizer != null && !(this.optimizer instanceof NullOptimizer)) {
            if (DEBUG_OPTIMIZATION) {
                String dirName = System.getProperty("java.io.tmpdir");
                if (!dirName.endsWith(File.separator)) {
                    dirName = dirName + File.separator;
                }
                try {
                    this.queryGraph.save(dirName + "greql-query-unoptimized.tg");
                }
                catch (GraphIOException e) {
                    e.printStackTrace();
                }
                this.printGraphAsDot(this.queryGraph, dirName + "greql-query-unoptimized.dot");
            }
            long t2 = System.currentTimeMillis();
            this.optimizer.optimize(this);
            if (!DEBUG_OPTIMIZATION) {
                BooleanGraphMarker reachables = new BooleanGraphMarker(this.queryGraph);
                LinkedList<Vertex> q = new LinkedList<Vertex>();
                q.offer(this.queryGraph.getFirstGreqlExpression());
                while (!q.isEmpty()) {
                    Vertex v = (Vertex)q.poll();
                    reachables.mark(v);
                    for (Edge e : v.incidences()) {
                        Vertex u = e.getThat();
                        if (reachables.isMarked(u)) continue;
                        q.offer(u);
                    }
                }
                ArrayList<Vertex> orphans = new ArrayList<Vertex>();
                for (Vertex v : this.queryGraph.vertices()) {
                    if (reachables.isMarked(v)) continue;
                    orphans.add(v);
                }
                for (Vertex v : orphans) {
                    v.delete();
                }
            }
            long t3 = System.currentTimeMillis();
            if (DEBUG_OPTIMIZATION) {
                String dirName = System.getProperty("java.io.tmpdir");
                if (!dirName.endsWith(File.separator)) {
                    dirName = dirName + File.separator;
                }
                try {
                    this.queryGraph.save(dirName + "greql-query-optimized.tg");
                }
                catch (GraphIOException e) {
                    e.printStackTrace();
                }
                this.printGraphAsDot(this.queryGraph, dirName + "greql-query-optimized.dot");
                logger.info("Stored query graphs to " + dirName + "greql-query*");
            }
            logger.fine("GReQL optimizer: " + (t3 - t2) + " ms");
        }
        this.initializeVertexEvaluatorsMarker(this.queryGraph);
        long t4 = System.currentTimeMillis();
        logger.fine("GReQL total: " + (t4 - t0) + " ms");
        this.rootExpression = this.queryGraph.getFirstGreqlExpression();
    }

    private void printGraphAsDot(Graph graph, String outputFilename) {
        Object t2d = null;
        if (tg2DotReference != null) {
            t2d = tg2DotReference.get();
        }
        try {
            if (t2d == null) {
                if (tg2DotClass == null) {
                    tg2DotClass = Class.forName("de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot");
                }
                t2d = tg2DotClass.newInstance();
                tg2DotReference = new SoftReference<Object>(t2d);
            }
            tg2DotClass.getMethod("setGraph", Graph.class).invoke(t2d, graph);
            tg2DotClass.getMethod("setOutputFile", String.class).invoke(t2d, outputFilename);
            tg2DotClass.getMethod("setReversedEdges", Boolean.TYPE).invoke(t2d, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeVertexEvaluatorsMarker(GreqlGraph graph) {
        if (this.vertexEvaluators == null) {
            this.vertexEvaluators = new GraphMarker(graph);
        }
    }

    void resetVertexEvaluators(InternalGreqlEvaluator evaluator) {
        GreqlGraph queryGraph = this.getQueryGraph();
        for (GreqlVertex currentVertex = (GreqlVertex)queryGraph.getFirstVertex(); currentVertex != null; currentVertex = (GreqlVertex)currentVertex.getNextVertex()) {
            VertexEvaluator vertexEval = (VertexEvaluator)this.vertexEvaluators.getMark(currentVertex);
            if (vertexEval == null) continue;
            vertexEval.resetToInitialState(evaluator);
        }
    }

    @Override
    public Set<String> getUsedVariables() {
        if (this.usedVariables == null) {
            this.usedVariables = JGraLab.set();
            GreqlExpression expr = this.getRootExpression();
            if (expr != null) {
                for (Variable v : expr.get_boundVar()) {
                    this.usedVariables = this.usedVariables.plus(v.get_name());
                }
            }
        }
        return this.usedVariables;
    }

    @Override
    public Set<String> getStoredVariables() {
        if (this.storedVariables == null) {
            Identifier id;
            this.storedVariables = JGraLab.set();
            GreqlExpression expr = this.getRootExpression();
            if (expr != null && (id = expr.get_identifier()) != null) {
                this.storedVariables = this.storedVariables.plus(id.get_name());
            }
        }
        return this.storedVariables;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Override
    public GreqlExpression getRootExpression() {
        return this.rootExpression;
    }

    @Override
    public void vertexAdded(Vertex v) {
        block2: {
            try {
                this.vertexEvaluators.mark(v, VertexEvaluator.createVertexEvaluator((GreqlVertex)v, this));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ClassNotFoundException) break block2;
                throw e;
            }
        }
    }

    @Override
    public void vertexDeleted(Vertex v) {
        this.vertexEvaluators.removeMark(v);
    }

    @Override
    public void edgeAdded(Edge e) {
    }

    @Override
    public void edgeDeleted(Edge e) {
    }

    @Override
    public void maxEdgeCountIncreased(int newValue) {
    }

    @Override
    public void maxVertexCountIncreased(int newValue) {
    }

    @Override
    public Object evaluate(Graph datagraph, GreqlEnvironment environment, ProgressFunction progressFunction) {
        return new GreqlEvaluatorImpl(this, datagraph, environment, progressFunction).getResult();
    }

    public String toString() {
        return this.queryText;
    }

    private static class GreqlParserWithVertexEvaluatorUpdates
    extends GreqlParser {
        public GreqlParserWithVertexEvaluatorUpdates(String source, Set<String> subQueryNames, GreqlQueryImpl gscl) {
            super(source, subQueryNames);
            if (gscl != null) {
                this.graph.addGraphStructureChangedListener(gscl);
                gscl.initializeVertexEvaluatorsMarker(this.graph);
            }
        }

        public static GreqlGraph parse(String query, GreqlQueryImpl gscl, Set<String> subQueryNames) {
            return GreqlParserWithVertexEvaluatorUpdates.parse(query, subQueryNames, gscl);
        }

        public static GreqlGraph parse(String query, Set<String> subQueryNames, GreqlQueryImpl gscl) {
            GreqlParserWithVertexEvaluatorUpdates parser = new GreqlParserWithVertexEvaluatorUpdates(query, subQueryNames, gscl);
            parser.parse();
            return parser.getGraph();
        }
    }
}

