/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.parallel.EvaluationEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluatorCallable;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public abstract class GreqlQuery
implements ParallelGreqlEvaluatorCallable {
    private String name;

    protected GreqlQuery() {
    }

    public static GreqlQuery readQuery(File f) throws IOException {
        return GreqlQuery.readQuery(f, new DefaultOptimizer(new DefaultOptimizerInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GreqlQuery readQuery(File f, Optimizer optimizer) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        try {
            StringBuilder queryText = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                queryText.append(line).append('\n');
                line = reader.readLine();
            }
            GreqlQuery greqlQuery = GreqlQuery.createQuery(queryText.toString(), optimizer);
            return greqlQuery;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("An exception occurred while closing the stream.", ex);
            }
        }
    }

    public static GreqlQuery createQuery(String queryText) {
        return new GreqlQueryImpl(queryText);
    }

    public static GreqlQuery createQuery(String queryText, Optimizer optimizer) {
        return new GreqlQueryImpl(queryText, optimizer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract GreqlGraph getQueryGraph();

    @Override
    public abstract Set<String> getUsedVariables();

    @Override
    public abstract Set<String> getStoredVariables();

    public abstract String getQueryText();

    public abstract GreqlExpression getRootExpression();

    public Object evaluate() {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), null);
    }

    public Object evaluate(Graph datagraph) {
        return this.evaluate(datagraph, new GreqlEnvironmentAdapter(), null);
    }

    public Object evaluate(Graph datagraph, GreqlEnvironment environment) {
        return this.evaluate(datagraph, environment, null);
    }

    public Object evaluate(Graph datagraph, ProgressFunction progressFunction) {
        return this.evaluate(datagraph, new GreqlEnvironmentAdapter(), progressFunction);
    }

    public abstract Object evaluate(Graph var1, GreqlEnvironment var2, ProgressFunction var3);

    public <T> T getSingleResult(Graph datagraph) {
        return (T)this.evaluate(datagraph);
    }

    public <T> PVector<T> getResultList(Graph datagraph) {
        return (PVector)this.evaluate(datagraph);
    }

    public <K, V> PMap<K, V> getResultMap(Graph datagraph) {
        return (PMap)this.evaluate(datagraph);
    }

    public <T> POrderedSet<T> getResultSet(Graph datagraph) {
        return (POrderedSet)this.evaluate(datagraph);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, GraphIOException {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: java GreqlQuery <query> [<graphfile>]");
            System.exit(1);
        }
        JGraLab.setLogLevel(Level.OFF);
        String query = args[0];
        Graph datagraph = null;
        if (args.length == 2) {
            datagraph = GraphIO.loadGraphFromFile(args[1], ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction("Loading"));
        }
        Object result = GreqlQuery.createQuery(query).evaluate(datagraph);
        System.out.println("Evaluation Result:");
        System.out.println("==================");
        if (result instanceof Map) {
            for (Map.Entry e : ((Map)result).entrySet()) {
                System.out.println(e.getKey() + " --> " + e.getValue());
            }
        } else if (result instanceof PCollection) {
            PCollection coll = (PCollection)result;
            for (Object jv : coll) {
                System.out.println(jv);
            }
        } else {
            System.out.println(result);
        }
    }

    @Override
    public Object call(EvaluationEnvironment environment) throws Exception {
        return this.evaluate(environment.getDatagraph(), environment.getGreqlEnvironment());
    }
}

