/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.DoubleFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class DoubleGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements DoubleFunction<T> {
    protected double[] temporaryAttributes;
    protected int marked;
    protected long version;

    protected DoubleGraphMarker(Graph graph, int size) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(size);
        this.marked = 0;
    }

    private double[] createNewArray(int size) {
        double[] newArray = new double[size];
        for (int i = 0; i < size; ++i) {
            newArray[i] = Double.NaN;
        }
        return newArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = Double.NaN;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return !Double.isNaN(this.temporaryAttributes[graphElement.getId()]);
    }

    public double mark(T graphElement, double value) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        double out = this.temporaryAttributes[graphElement.getId()];
        this.temporaryAttributes[graphElement.getId()] = value;
        ++this.marked;
        ++this.version;
        return out;
    }

    public double getMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        double out = this.temporaryAttributes[graphElement.getId()];
        return out;
    }

    @Override
    public boolean removeMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (Double.isNaN(this.temporaryAttributes[graphElement.getId()])) {
            return false;
        }
        this.temporaryAttributes[graphElement.getId()] = Double.NaN;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int newSize) {
        assert (newSize > this.temporaryAttributes.length);
        double[] newTemporaryAttributes = this.createNewArray(newSize);
        System.arraycopy(this.temporaryAttributes, 0, newTemporaryAttributes, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = newTemporaryAttributes;
    }

    @Override
    public double get(T parameter) {
        return this.getMark(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public void set(T parameter, double value) {
        this.mark(parameter, value);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<DoubleFunctionEntry<T>> iterator() {
        final Iterator markedElements = this.getMarkedElements().iterator();
        return new Iterator<DoubleFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public DoubleFunctionEntry<T> next() {
                GraphElement currentElement = (GraphElement)markedElements.next();
                return new DoubleFunctionEntry<GraphElement>(currentElement, DoubleGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                markedElements.remove();
            }
        };
    }
}

