/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.BooleanFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.BitSet;
import java.util.Iterator;

public abstract class BitSetGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements BooleanFunction<T> {
    protected final BitSet marks = new BitSet();
    protected long version;

    protected BitSetGraphMarker(Graph graph) {
        super(graph);
    }

    public boolean mark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        boolean out = this.isMarked(graphElement);
        this.marks.set(graphElement.getId());
        ++this.version;
        return !out;
    }

    @Override
    public boolean removeMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        boolean out = this.isMarked(graphElement);
        this.marks.clear(graphElement.getId());
        --this.version;
        return out;
    }

    @Override
    public int size() {
        return this.marks.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.marks.isEmpty();
    }

    @Override
    public void clear() {
        this.marks.clear();
    }

    @Override
    public boolean isMarked(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.marks.get(graphElement.getId());
    }

    @Override
    public void maxEdgeCountIncreased(int newValue) {
    }

    @Override
    public void maxVertexCountIncreased(int newValue) {
    }

    @Override
    public boolean get(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return true;
    }

    @Override
    public void set(T parameter, boolean value) {
        if (value) {
            this.mark(parameter);
        } else {
            this.removeMark(parameter);
        }
    }

    @Override
    public Iterator<BooleanFunctionEntry<T>> iterator() {
        final Iterator domainElements = this.getDomainElements().iterator();
        return new Iterator<BooleanFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return domainElements.hasNext();
            }

            @Override
            public BooleanFunctionEntry<T> next() {
                GraphElement currentElement = (GraphElement)domainElements.next();
                return new BooleanFunctionEntry<GraphElement>(currentElement, BitSetGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                domainElements.remove();
            }
        };
    }
}

