/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca.events;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.ArrayList;
import java.util.List;
import org.pcollections.PCollection;

public abstract class EventDescription<AEC extends AttributedElementClass<AEC, ?>> {
    protected List<ECARule<AEC>> activeRules;
    private final EventTime time;
    private final Context context;
    private String contextExpression;
    private AEC type;

    public EventDescription(EventTime time, AEC type) {
        this.time = time;
        this.activeRules = new ArrayList<ECARule<AEC>>();
        this.type = type;
        this.context = Context.TYPE;
    }

    public EventDescription(EventTime time, String contExpr) {
        this.time = time;
        this.activeRules = new ArrayList<ECARule<AEC>>();
        this.contextExpression = contExpr;
        this.context = Context.EXPRESSION;
    }

    protected boolean checkContext(AEC elementClass) {
        return this.getType().equals(elementClass);
    }

    protected boolean checkContext(AttributedElement<AEC, ?> element) {
        if (this.context.equals((Object)Context.TYPE)) {
            return element.getAttributedElementClass().equals(this.type);
        }
        Graph graph = this.activeRules.get(0).getECARuleManager().getGraph();
        Object resultingContext = GreqlQuery.createQuery(this.contextExpression).evaluate(graph);
        if (resultingContext instanceof PCollection) {
            PCollection col = (PCollection)resultingContext;
            for (Object val : col) {
                if (!(val instanceof AttributedElement) || !val.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public EventTime getTime() {
        return this.time;
    }

    public List<ECARule<AEC>> getActiveECARules() {
        return this.activeRules;
    }

    public String getContextExpression() {
        return this.contextExpression;
    }

    public AEC getType() {
        return this.type;
    }

    public Context getContext() {
        return this.context;
    }

    public void addActiveRule(ECARule<?> rule) {
        this.activeRules.add(rule);
    }

    public static enum Context {
        TYPE,
        EXPRESSION;

    }

    public static enum EventTime {
        BEFORE,
        AFTER;

    }
}

