/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.strong_components;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.GraphAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.strong_components.visitors.ReducedGraphVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.strong_components.visitors.ReducedGraphVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.problems.StrongComponentsSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class StrongComponentsWithDFS
extends StructureOrientedAlgorithm
implements StrongComponentsSolver {
    private DepthFirstSearch dfs;
    private Stack<Vertex> vertexStack;
    private DFSVisitor lowlinkVisitor;
    private IntFunction<Vertex> lowlink;
    private Function<Vertex, Vertex> strongComponents;
    private Function<Vertex, Set<Vertex>> inverseResult;
    private ReducedGraphVisitorList visitors;

    public StrongComponentsWithDFS(Graph graph, DepthFirstSearch dfs) {
        this(graph, dfs, null);
    }

    public StrongComponentsWithDFS(Graph graph, DepthFirstSearch dfs, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
        this.dfs = dfs;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof ReducedGraphVisitor) {
            visitor.setAlgorithm(this);
            this.visitors.addVisitor(visitor);
        } else {
            this.dfs.addVisitor(visitor);
        }
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
    }

    @Override
    protected void done() {
        this.state = this.dfs.getState();
    }

    @Override
    public StrongComponentsWithDFS normal() {
        super.normal();
        return this;
    }

    @Override
    public StructureOrientedAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    public StrongComponentsWithDFS withInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = new ArrayVertexMarker<Set<Vertex>>(this.graph);
        return this;
    }

    public StrongComponentsWithDFS withoutInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
        return this;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof ReducedGraphVisitor) {
            this.visitors.removeVisitor(visitor);
        } else {
            this.dfs.removeVisitor(visitor);
        }
    }

    @Override
    public Function<Vertex, Vertex> getStrongComponents() {
        this.checkStateForResult();
        return this.strongComponents;
    }

    public Function<Vertex, Set<Vertex>> getInverseResult() {
        this.checkStateForResult();
        return this.inverseResult;
    }

    public IntFunction<Vertex> getLowlink() {
        this.checkStateForResult();
        return this.lowlink;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.vertexStack = new Stack();
        this.visitors = new ReducedGraphVisitorList();
        this.inverseResult = null;
        this.lowlinkVisitor = new DFSVisitorAdapter(){
            private IntFunction<Vertex> number;

            @Override
            public void setAlgorithm(GraphAlgorithm algorithm) {
                super.setAlgorithm(algorithm);
                this.number = this.algorithm.getInternalNumber();
            }

            @Override
            public void visitVertex(Vertex v) {
                StrongComponentsWithDFS.this.vertexStack.push(v);
                StrongComponentsWithDFS.this.lowlink.set(v, this.number.get(v));
            }

            public void maybeVisitReducedEdge(Edge e) {
                if (StrongComponentsWithDFS.this.strongComponents.isDefined(e.getThat())) {
                    StrongComponentsWithDFS.this.visitors.visitReducedEdge(e);
                }
            }

            @Override
            public void leaveTreeEdge(Edge e) {
                Vertex v = e.getThis();
                Vertex w = e.getThat();
                StrongComponentsWithDFS.this.lowlink.set(v, Math.min(StrongComponentsWithDFS.this.lowlink.get(v), StrongComponentsWithDFS.this.lowlink.get(w)));
                this.maybeVisitReducedEdge(e);
            }

            @Override
            public void visitForwardArc(Edge e) {
                this.maybeVisitReducedEdge(e);
            }

            @Override
            public void visitBackwardArc(Edge e) {
                Vertex v = e.getThis();
                Vertex w = e.getThat();
                StrongComponentsWithDFS.this.lowlink.set(v, Math.min(StrongComponentsWithDFS.this.lowlink.get(v), this.number.get(w)));
            }

            @Override
            public void visitCrosslink(Edge e) {
                Vertex v = e.getThis();
                Vertex w = e.getThat();
                if (StrongComponentsWithDFS.this.vertexStack.contains(w)) {
                    StrongComponentsWithDFS.this.lowlink.set(v, Math.min(StrongComponentsWithDFS.this.lowlink.get(v), this.number.get(w)));
                }
                this.maybeVisitReducedEdge(e);
            }

            @Override
            public void leaveVertex(Vertex v) {
                if (StrongComponentsWithDFS.this.lowlink.get(v) == this.number.get(v)) {
                    Vertex x;
                    HashSet<Vertex> currentSubSet = null;
                    if (StrongComponentsWithDFS.this.inverseResult != null) {
                        assert (StrongComponentsWithDFS.this.inverseResult.get(v) == null);
                        currentSubSet = new HashSet<Vertex>();
                        StrongComponentsWithDFS.this.inverseResult.set(v, currentSubSet);
                    }
                    do {
                        x = (Vertex)StrongComponentsWithDFS.this.vertexStack.pop();
                        StrongComponentsWithDFS.this.strongComponents.set(x, v);
                        if (currentSubSet == null) continue;
                        currentSubSet.add(x);
                    } while (x != v);
                    StrongComponentsWithDFS.this.visitors.visitRepresentativeVertex(v);
                }
            }
        };
    }

    @Override
    public void reset() {
        super.reset();
        this.lowlink = new IntegerVertexMarker(this.graph);
        this.strongComponents = new ArrayVertexMarker<Vertex>(this.graph);
        this.inverseResult = this.inverseResult == null ? null : new ArrayVertexMarker(this.graph);
        this.vertexStack.clear();
    }

    @Override
    public StrongComponentsSolver execute() throws AlgorithmTerminatedException {
        this.dfs.reset();
        this.dfs.setGraph(this.graph);
        this.dfs.setNavigable(this.navigable);
        this.dfs.setTraversalDirection(this.traversalDirection);
        this.dfs.addVisitor(this.lowlinkVisitor);
        try {
            this.startRunning();
            this.dfs.execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        this.done();
        this.dfs.removeVisitor(this.lowlinkVisitor);
        return this;
    }

    public IntFunction<Vertex> getInternalLowlink() {
        return this.lowlink;
    }

    public Function<Vertex, Vertex> getInternalStrongComponents() {
        return this.strongComponents;
    }

    public Function<Vertex, Set<Vertex>> getInternalInverseResult() {
        return this.inverseResult;
    }

    public Stack<Vertex> getVertexStack() {
        return this.vertexStack;
    }
}

