/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.adapters.MethodCallToDoubleFunctionAdapter;
import de.uni_koblenz.jgralab.algolib.problems.DistancesFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathsFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class ShortestPathsWithBFS
extends StructureOrientedAlgorithm
implements DistancesFromVertexSolver,
ShortestPathsFromVertexSolver {
    private BreadthFirstSearch bfs;

    public ShortestPathsWithBFS(Graph graph, BreadthFirstSearch bfs) {
        this(graph, bfs, null);
    }

    public ShortestPathsWithBFS(Graph graph, BreadthFirstSearch bfs, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
        this.bfs = bfs;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.bfs.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.bfs.removeVisitor(visitor);
    }

    @Override
    public ShortestPathsWithBFS normal() {
        super.normal();
        return this;
    }

    @Override
    public ShortestPathsWithBFS reversed() {
        super.reversed();
        return this;
    }

    @Override
    public ShortestPathsWithBFS undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    public ShortestPathsWithBFS execute(Vertex start) throws AlgorithmTerminatedException {
        this.bfs.reset();
        this.bfs.setGraph(this.graph);
        this.bfs.setNavigable(this.navigable);
        this.bfs.setTraversalDirection(this.traversalDirection);
        this.startRunning();
        this.bfs.withLevel().withParent().execute(start);
        this.done();
        return this;
    }

    @Override
    protected void done() {
        this.state = this.bfs.getState() == AlgorithmStates.STOPPED ? AlgorithmStates.FINISHED : this.bfs.getState();
    }

    @Override
    public DoubleFunction<Vertex> getDistance() {
        this.checkStateForResult();
        return new MethodCallToDoubleFunctionAdapter<Vertex>(){
            private IntFunction<Vertex> level;
            {
                this.level = ShortestPathsWithBFS.this.bfs.getLevel();
            }

            @Override
            public double get(Vertex parameter) {
                return this.level.get(parameter);
            }

            @Override
            public boolean isDefined(Vertex parameter) {
                return this.level.isDefined(parameter);
            }
        };
    }

    @Override
    public Function<Vertex, Edge> getParent() {
        this.checkStateForResult();
        return this.bfs.getParent();
    }
}

