/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search.visitors;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorList;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import java.util.ArrayList;
import java.util.List;

public class DFSVisitorList
extends SearchVisitorList
implements DFSVisitor {
    private List<DFSVisitor> visitors = new ArrayList<DFSVisitor>();

    @Override
    public void addVisitor(Visitor visitor) {
        super.addVisitor(visitor);
        if (visitor instanceof DFSVisitor && !this.visitors.contains(visitor)) {
            this.visitors.add((DFSVisitor)visitor);
        }
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        super.removeVisitor(visitor);
        if (visitor instanceof DFSVisitor) {
            this.visitors.remove(visitor);
        }
    }

    @Override
    public void clearVisitors() {
        super.clearVisitors();
        this.visitors.clear();
    }

    @Override
    public void leaveTreeEdge(Edge e) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).leaveTreeEdge(e);
        }
    }

    @Override
    public void leaveVertex(Vertex v) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).leaveVertex(v);
        }
    }

    @Override
    public void visitBackwardArc(Edge e) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitBackwardArc(e);
        }
    }

    @Override
    public void visitCrosslink(Edge e) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitCrosslink(e);
        }
    }

    @Override
    public void visitForwardArc(Edge e) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitForwardArc(e);
        }
    }
}

