/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    private int indentationLevel;
    private String indentation;
    private XMLStreamWriter writer;

    public IndentingXMLStreamWriter(XMLStreamWriter writer) {
        this(writer, "\t");
    }

    public IndentingXMLStreamWriter(XMLStreamWriter writer, String indentation) {
        this.writer = writer;
        this.indentation = indentation;
        this.indentationLevel = 0;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCData(data);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeComment(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        while (this.indentationLevel > 0) {
            this.writeEndElement();
        }
        this.writer.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.indentationLevel;
        this.writeIndentation();
        this.writer.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(localName);
        ++this.indentationLevel;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(namespaceURI, localName);
        ++this.indentationLevel;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
        ++this.indentationLevel;
    }

    private void writeIndentation() throws XMLStreamException {
        this.writer.writeCharacters("\n");
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.writer.writeCharacters(this.indentation);
        }
    }
}

