/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pcollections.PVector;

public final class ArrayPVector<E>
implements PVector<E>,
Serializable {
    private static final long serialVersionUID = -3381080251584514162L;
    private static final int INITIAL_SIZE = 10;
    private static final double GROW_FACTOR = 1.5;
    private E[] value;
    private int count;
    private int offset;
    private boolean sublist;
    private transient int hashCode;
    private static ArrayPVector<?> empty = new ArrayPVector();

    private ArrayPVector() {
        this.hashCode = 0;
    }

    private ArrayPVector(E[] value, int offset, int count) {
        this.value = value;
        this.offset = offset;
        this.count = count;
        this.sublist = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof List)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayPVector) {
            ArrayPVector other = (ArrayPVector)obj;
            if (this.count != other.count) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.value[this.offset + i].equals(other.value[other.offset + i])) continue;
                return false;
            }
            return true;
        }
        List other = (List)obj;
        if (other.size() != this.count) {
            return false;
        }
        int i = 0;
        for (Object item : other) {
            if (this.value[this.offset + i++].equals(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            for (int i = 0; i < this.count; ++i) {
                this.hashCode = 31 * this.hashCode + this.value[this.offset + i].hashCode();
            }
        }
        return this.hashCode;
    }

    public static <T> ArrayPVector<T> empty() {
        return empty;
    }

    @Override
    @Deprecated
    public void add(int arg0, E arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E remove(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E set(int arg0, E arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean add(E arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.value[this.offset + i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new PIterator();
    }

    @Override
    public Object[] toArray() {
        if (this.count == 0) {
            return new Object[0];
        }
        return Arrays.copyOfRange(this.value, this.offset, this.offset + this.count);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length >= this.count) {
            if (this.count > 0) {
                System.arraycopy(this.value, this.offset, a, 0, this.count);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            return a;
        }
        return Arrays.copyOfRange(this.value, this.offset, this.offset + this.count, a.getClass());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.value[this.offset + index];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.value[this.offset + i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.count - 1; i >= 0; --i) {
            if (!this.value[this.offset + i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new PListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new PListIterator(index);
    }

    @Override
    public PVector<E> minus(Object o) {
        if (o == null) {
            return this;
        }
        int i = this.indexOf(o);
        return i < 0 ? this : this.minus(i);
    }

    @Override
    public PVector<E> minus(int i) {
        ArrayPVector<Object> result;
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (i == 0) {
            result = new ArrayPVector<E>(this.value, this.offset + 1, this.count - 1);
            result.sublist = true;
        } else if (i == this.count - 1) {
            result = new ArrayPVector<E>(this.value, this.offset, this.count - 1);
            result.sublist = true;
        } else {
            Object[] val = new Object[this.count - 1];
            System.arraycopy(this.value, this.offset, val, 0, i);
            System.arraycopy(this.value, this.offset + i + 1, val, i, this.count - i - 1);
            result = new ArrayPVector<Object>(val, 0, this.count - 1);
        }
        return result;
    }

    @Override
    public PVector<E> minusAll(Collection<?> list) {
        if (list.isEmpty()) {
            return this;
        }
        PVector<E> r = this;
        for (Object e : list) {
            r = r.minus(e);
        }
        return r;
    }

    @Override
    public PVector<E> plus(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Can't add null to an ArrayPVector");
        }
        if (this.sublist || this.count == 0 || this.offset + this.count + 1 > this.value.length) {
            if (this.count == 0) {
                Object[] val = new Object[10];
                val[0] = e;
                return new ArrayPVector<Object>(val, 0, 1);
            }
            Object[] val = new Object[Math.max(this.count + 1, (int)((double)this.count * 1.5))];
            System.arraycopy(this.value, this.offset, val, 0, this.count);
            val[this.count] = e;
            return new ArrayPVector<Object>(val, 0, this.count + 1);
        }
        this.sublist = true;
        this.value[this.offset + this.count] = e;
        return new ArrayPVector<E>(this.value, this.offset, this.count + 1);
    }

    @Override
    public ArrayPVector<E> plus(int i, E e) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public PVector<E> plusAll(Collection<? extends E> l) {
        int n = l.size();
        if (n == 0) {
            return this;
        }
        if (this.count == 0 && l instanceof ArrayPVector) {
            return (ArrayPVector)l;
        }
        if (!this.sublist && this.value != null && this.offset + this.count + n <= this.value.length) {
            int i = this.count;
            for (E e : l) {
                if (e == null) {
                    throw new IllegalArgumentException("Can't add null to an ArrayPVector");
                }
                this.value[i++] = e;
            }
            this.sublist = true;
            return new ArrayPVector<E>(this.value, this.offset, i);
        }
        Object[] val = new Object[this.count + n];
        if (this.value != null) {
            System.arraycopy(this.value, this.offset, val, 0, this.count);
        }
        int i = this.count;
        for (E e : l) {
            if (e == null) {
                throw new IllegalArgumentException("Can't add null to an ArrayPVector");
            }
            val[i++] = e;
        }
        return new ArrayPVector<Object>(val, 0, i);
    }

    @Override
    public ArrayPVector<E> plusAll(int idx, Collection<? extends E> l) {
        if (idx < 0 || idx > this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (l.isEmpty()) {
            return this;
        }
        int n = this.count + l.size();
        Object[] val = new Object[n];
        if (idx > 0) {
            System.arraycopy(this.value, 0, val, 0, idx);
        }
        int i = idx;
        for (E item : l) {
            val[i++] = item;
        }
        if (idx < this.count) {
            System.arraycopy(this.value, idx, val, n - this.count + idx, this.count - idx);
        }
        return new ArrayPVector<Object>(val, 0, n);
    }

    @Override
    public ArrayPVector<E> subList(int start, int end) {
        if (start == 0 && end == this.count) {
            return this;
        }
        if (start < 0 || end > this.count || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return ArrayPVector.empty();
        }
        ArrayPVector<E> result = new ArrayPVector<E>(this.value, this.offset + start, end - start);
        result.sublist = true;
        return result;
    }

    @Override
    public ArrayPVector<E> with(int i, E e) {
        if (e == null) {
            throw new IllegalArgumentException("Can't set an element to null in an ArrayPVector");
        }
        if (this.get(i).equals(e)) {
            return this;
        }
        E[] val = Arrays.copyOfRange(this.value, this.offset, this.offset + this.count);
        val[i] = e;
        return new ArrayPVector<E>(val, 0, this.count);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.value[this.offset + i].toString());
            if (i >= this.count - 1) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    public class PListIterator
    extends PIterator
    implements ListIterator<E> {
        public PListIterator() {
        }

        public PListIterator(int index) {
            if (index < 0 || index > ArrayPVector.this.count) {
                throw new IndexOutOfBoundsException();
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E previous() {
            if (this.cursor == 0) {
                throw new NoSuchElementException();
            }
            return ArrayPVector.this.value[--this.cursor + ArrayPVector.this.offset];
        }

        @Override
        public int nextIndex() {
            return this.cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    public class PIterator
    implements Iterator<E> {
        protected int cursor;

        @Override
        public boolean hasNext() {
            return this.cursor < ArrayPVector.this.count;
        }

        @Override
        public E next() {
            if (this.cursor == ArrayPVector.this.count) {
                throw new NoSuchElementException();
            }
            return ArrayPVector.this.value[ArrayPVector.this.offset + this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

