/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasContent;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasText;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Node;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextImpl
extends VertexImpl
implements Node,
Text,
Vertex {
    protected String _content;

    public TextImpl(int id, Graph g) {
        super(id, g);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Text.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Text.class;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        if (attributeName.equals("content")) {
            return (T)this.get_content();
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + attributeName);
    }

    @Override
    public <T> void setAttribute(String attributeName, T data) {
        if (attributeName.equals("content")) {
            this.set_content((String)data);
            return;
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + attributeName);
    }

    @Override
    public String get_content() {
        return this._content;
    }

    @Override
    public void set_content(String _content) {
        this.ecaAttributeChanging("content", this._content, _content);
        String oldValue = this._content;
        this._content = _content;
        this.graphModified();
        this.ecaAttributeChanged("content", oldValue, _content);
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        this._content = io.matchUtfString();
        this.set_content(this._content);
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {
        if (attributeName.equals("content")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._content = io.matchUtfString();
            this.set_content(this._content);
            return;
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + attributeName);
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {
        io.space();
        io.writeUtfString(this._content);
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {
        if (attributeName.equals("content")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._content);
            return io.getStringWriterResult();
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + attributeName);
    }

    @Override
    public Node getNextNode() {
        return (Node)this.getNextVertex(Node.VC);
    }

    @Override
    public Text getNextText() {
        return (Text)this.getNextVertex(Text.VC);
    }

    @Override
    public HasText getFirstHasTextIncidence() {
        return (HasText)this.getFirstIncidence(HasText.EC);
    }

    @Override
    public HasText getFirstHasTextIncidence(EdgeDirection orientation) {
        return (HasText)this.getFirstIncidence(HasText.EC, orientation);
    }

    @Override
    public HasContent getFirstHasContentIncidence() {
        return (HasContent)this.getFirstIncidence(HasContent.EC);
    }

    @Override
    public HasContent getFirstHasContentIncidence(EdgeDirection orientation) {
        return (HasContent)this.getFirstIncidence(HasContent.EC, orientation);
    }

    @Override
    public HasContent add_parent(Element vertex) {
        return (HasContent)((XMLGraph)this.getGraph()).createEdge(HasContent.EC, vertex, this);
    }

    @Override
    public List<? extends Element> remove_parent() {
        ArrayList<Element> adjacences = new ArrayList<Element>();
        HasContent edge = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        while (edge != null) {
            HasContent next = (HasContent)edge.getNextIncidence(HasContent.EC, EdgeDirection.IN);
            adjacences.add((Element)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_parent(Element vertex) {
        boolean elementRemoved = false;
        HasContent edge = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        while (edge != null) {
            HasContent next = (HasContent)edge.getNextIncidence(HasContent.EC, EdgeDirection.IN);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public Element get_parent() {
        HasContent edge = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        if (edge != null) {
            return (Element)edge.getThat();
        }
        return null;
    }

    @Override
    public Iterable<HasText> getHasTextIncidences() {
        return new IncidenceIterable<HasText>((Vertex)this, HasText.EC);
    }

    @Override
    public Iterable<HasText> getHasTextIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasText>(this, HasText.EC, direction);
    }

    @Override
    public Iterable<HasContent> getHasContentIncidences() {
        return new IncidenceIterable<HasContent>((Vertex)this, HasContent.EC);
    }

    @Override
    public Iterable<HasContent> getHasContentIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasContent>(this, HasContent.EC, direction);
    }
}

