/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema;

import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std.XMLGraphFactoryImpl;
import java.lang.ref.WeakReference;

public class XMLSchema
extends SchemaImpl {
    static WeakReference<XMLSchema> theInstance = new WeakReference<Object>(null);

    public static synchronized XMLSchema instance() {
        XMLSchema s = (XMLSchema)theInstance.get();
        if (s != null) {
            return s;
        }
        s = new XMLSchema();
        theInstance = new WeakReference<XMLSchema>(s);
        return s;
    }

    private XMLSchema() {
        super("XMLSchema", "de.uni_koblenz.jgralab.utilities.xml2tg.schema");
        GraphClass gc = this.createGraphClass("XMLGraph");
        VertexClass vc_Attribute = gc.createVertexClass("Attribute");
        vc_Attribute.setAbstract(false);
        vc_Attribute.createAttribute("name", this.getDomain("String"), null);
        vc_Attribute.createAttribute("value", this.getDomain("String"), null);
        VertexClass vc_Node = gc.createVertexClass("Node");
        vc_Node.setAbstract(true);
        VertexClass vc_Text = gc.createVertexClass("Text");
        vc_Text.setAbstract(false);
        vc_Text.addSuperClass(vc_Node);
        vc_Text.createAttribute("content", this.getDomain("String"), null);
        VertexClass vc_Element = gc.createVertexClass("Element");
        vc_Element.setAbstract(false);
        vc_Element.addSuperClass(vc_Node);
        vc_Element.createAttribute("name", this.getDomain("String"), null);
        vc_Element.addConstraint(new ConstraintImpl("There must be exactly one root element", "exists! e: V{Element} @ inDegree{HasChild}(e) = 0", "from e: V{Element} with inDegree{HasChild}(e) = 0 report e end"));
        vc_Element.addComment("Each element except the root element must have exactly one parent.");
        EdgeClass ec_HasAttribute = gc.createEdgeClass("HasAttribute", vc_Element, 1, 1, "element", AggregationKind.NONE, vc_Attribute, 0, Integer.MAX_VALUE, "attributes", AggregationKind.COMPOSITE);
        ec_HasAttribute.setAbstract(false);
        EdgeClass ec_HasContent = gc.createEdgeClass("HasContent", vc_Element, 0, 1, "parent", AggregationKind.NONE, vc_Node, 0, Integer.MAX_VALUE, "contents", AggregationKind.COMPOSITE);
        ec_HasContent.setAbstract(true);
        EdgeClass ec_References = gc.createEdgeClass("References", vc_Attribute, 0, Integer.MAX_VALUE, "referent", AggregationKind.NONE, vc_Element, 0, Integer.MAX_VALUE, "refs", AggregationKind.NONE);
        ec_References.setAbstract(false);
        EdgeClass ec_HasText = gc.createEdgeClass("HasText", vc_Element, 1, 1, "", AggregationKind.NONE, vc_Text, 0, Integer.MAX_VALUE, "texts", AggregationKind.COMPOSITE);
        ec_HasText.setAbstract(false);
        ec_HasText.addSuperClass(ec_HasContent);
        EdgeClass ec_HasChild = gc.createEdgeClass("HasChild", vc_Element, 0, 1, "", AggregationKind.NONE, vc_Element, 0, Integer.MAX_VALUE, "children", AggregationKind.COMPOSITE);
        ec_HasChild.setAbstract(false);
        ec_HasChild.addSuperClass(ec_HasContent);
        this.finish();
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        switch (implementationType) {
            case GENERIC: {
                return new GenericGraphFactoryImpl(this);
            }
            case STANDARD: {
                return new XMLGraphFactoryImpl();
            }
        }
        throw new UnsupportedOperationException("No " + (Object)((Object)implementationType) + " support compiled.");
    }

    public XMLGraph createXMLGraph(ImplementationType implType) {
        return this.createXMLGraph(implType, null, 100, 100);
    }

    public XMLGraph createXMLGraph(ImplementationType implType, String id, int vMax, int eMax) {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return (XMLGraph)factory.createGraph(this.getGraphClass(), id, vMax, eMax);
    }

    public XMLGraph createXMLGraph(GraphFactory factory) {
        return (XMLGraph)factory.createGraph(this.getGraphClass(), null, 100, 100);
    }

    public XMLGraph createXMLGraph(GraphFactory factory, String id, int vMax, int eMax) {
        return (XMLGraph)factory.createGraph(this.getGraphClass(), id, vMax, eMax);
    }

    public XMLGraph loadXMLGraph(String filename) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadXMLGraph(filename, factory, null);
    }

    public XMLGraph loadXMLGraph(String filename, ProgressFunction pf) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadXMLGraph(filename, factory, pf);
    }

    public XMLGraph loadXMLGraph(String filename, ImplementationType implType) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return this.loadXMLGraph(filename, factory, null);
    }

    public XMLGraph loadXMLGraph(String filename, ImplementationType implType, ProgressFunction pf) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return this.loadXMLGraph(filename, factory, pf);
    }

    public XMLGraph loadXMLGraph(String filename, GraphFactory factory) throws GraphIOException {
        return (XMLGraph)GraphIO.loadGraphFromFile(filename, factory, null);
    }

    public XMLGraph loadXMLGraph(String filename, GraphFactory factory, ProgressFunction pf) throws GraphIOException {
        return (XMLGraph)GraphIO.loadGraphFromFile(filename, factory, pf);
    }

    @Override
    public boolean reopen() {
        throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
    }
}

