/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.util.Iterator;

public class XmlGraphUtilities {
    private XMLGraph xg;

    public XmlGraphUtilities(XMLGraph xg) {
        this.xg = xg;
    }

    public Iterable<Element> elementsWithName(final String name) {
        return this.xg.getElementVertices(new VertexFilter<Element>(){

            @Override
            public boolean accepts(Element vertex) {
                return vertex.get_name().equals(name);
            }
        });
    }

    public Iterable<Element> childrenWithName(Element parent, final String name) {
        return parent.get_children(new VertexFilter<Element>(){

            @Override
            public boolean accepts(Element vertex) {
                return vertex.get_name().equals(name);
            }
        });
    }

    public Element firstChildWithName(Element parent, String name) {
        Iterator<Element> it = this.childrenWithName(parent, name).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public Element getRootElement() {
        for (Element el : this.xg.getElementVertices()) {
            if (el.getFirstHasChildIncidence(EdgeDirection.IN) != null) continue;
            return el;
        }
        return null;
    }

    public String getAttributeValue(Element el, String attrName) {
        for (Attribute attr : el.get_attributes()) {
            if (!attr.get_name().equals(attrName)) continue;
            return attr.get_value();
        }
        throw new NoSuchAttributeException("Element " + el + " has no attribute '" + attrName + "'");
    }

    public String getAttributeValue(Element el, String attrName, boolean upperCaseFirstLetter) {
        String result = this.getAttributeValue(el, attrName);
        if (upperCaseFirstLetter && (result = result.trim()).length() > 0) {
            result = Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        return result;
    }

    public Element getReferencedElement(Element el, String attrName) {
        for (Attribute attr : el.get_attributes()) {
            if (!attr.get_name().equals(attrName)) continue;
            References r = attr.getFirstReferencesIncidence();
            return r == null ? null : (Element)r.getThat();
        }
        throw new NoSuchAttributeException("Element " + el + " has no attribute '" + attrName + "'");
    }

    public Iterable<Element> getReferencedElements(Element el, String attrName) {
        for (Attribute attr : el.get_attributes()) {
            if (!attr.get_name().equals(attrName)) continue;
            return attr.get_refs();
        }
        throw new NoSuchAttributeException("Element " + el + " has no attribute '" + attrName + "'");
    }

    public boolean hasAttribute(Element el, String attrName) {
        for (Attribute attr : el.get_attributes()) {
            if (!attr.get_name().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    public String getText(Element el) {
        StringBuilder sb = new StringBuilder();
        for (Text t : el.get_texts()) {
            sb.append(t.get_content());
        }
        return sb.toString();
    }
}

