/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class GraphElementCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -1698523886275339684L;
    private static final Map<String, ImageIcon> ICON_CACHE = new HashMap<String, ImageIcon>();

    GraphElementCellRenderer() {
    }

    private static ImageIcon getIcon(String name) {
        ImageIcon icon = ICON_CACHE.get(name);
        if (icon == null) {
            icon = new ImageIcon(GraphElementCellRenderer.class.getResource("icons/" + name + ".png"));
            icon.setImage(icon.getImage().getScaledInstance(24, 8, 4));
            ICON_CACHE.put(name, icon);
        }
        return icon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        GraphElementTreeNode getn = (GraphElementTreeNode)value;
        this.setToolTipText(getn.getToolTipText());
        this.setFont(new Font("Monospaced", 0, tree.getFont().getSize()));
        if (getn instanceof EdgeTreeNode) {
            String iconName = null;
            Edge e = (Edge)((EdgeTreeNode)getn).get();
            iconName = e.isNormal() ? (e.getThatAggregationKind() == AggregationKind.SHARED ? "l_aggr_r" : (e.getThatAggregationKind() == AggregationKind.COMPOSITE ? "l_comp_r" : (e.getThisAggregationKind() == AggregationKind.SHARED ? "r_aggr_r" : (e.getThisAggregationKind() == AggregationKind.COMPOSITE ? "r_comp_r" : "edge_r")))) : (e.getThatAggregationKind() == AggregationKind.SHARED ? "l_aggr_l" : (e.getThatAggregationKind() == AggregationKind.COMPOSITE ? "l_comp_l" : (e.getThisAggregationKind() == AggregationKind.SHARED ? "r_aggr_l" : (e.getThisAggregationKind() == AggregationKind.COMPOSITE ? "r_comp_l" : "edge_l"))));
            this.setIcon(GraphElementCellRenderer.getIcon(iconName));
            EdgeTreeNode etn = (EdgeTreeNode)getn;
            if (etn.isBackEdge()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
        } else if (getn instanceof VertexTreeNode) {
            this.setIcon(GraphElementCellRenderer.getIcon("vertex"));
        }
        return this;
    }
}

