/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.types.Types;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.SchemaVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TabularVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TwoDVisualizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PCollection;
import org.pcollections.PSet;

public class StateRepository {
    private static final int NUMBER_OF_ELEMENTS_IN_BREADCRUMBBAR = 10;
    private static final int NUMBER_OF_ELEMENTS_IN_A_SET_IN_BREADCRUMBBAR = 3;
    private static ArrayList<State> sessions = new ArrayList();
    private static int nextSessionId = 0;
    public static String dot;
    public static HashMap<String, Method> definedMethods;
    public static ConcurrentHashMap<String, GraphWrapper> usedGraphs;
    private final File workspace;
    private final RequestThread currentThread;

    public StateRepository(File path, RequestThread requestThread) {
        this.workspace = path;
        this.currentThread = requestThread;
    }

    public StringBuilder computeGReQLQuery(Integer sessionId, Boolean isTableViewShown, Boolean showAttributes, Integer numberPerPage, Integer pathLength, String query) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(sessionId, code, "computeGReQLQuery", isTableViewShown.toString(), showAttributes.toString(), numberPerPage.toString(), pathLength.toString(), query);
        if (state != null) {
            try {
                Object result = StateRepository.evaluateGReQL(query, state.getGraph(), null);
                boolean elementsAreDisplayed = false;
                PSet<Object> elements = JGraLab.set();
                if (result instanceof PCollection) {
                    elements = elements.plusAll((Collection)result);
                    boolean containsOnlyVerticesOrEdges = true;
                    for (Object e : elements) {
                        if (e instanceof GraphElement) {
                            elements = elements.plus((GraphElement)e);
                            continue;
                        }
                        containsOnlyVerticesOrEdges = false;
                        break;
                    }
                    if (containsOnlyVerticesOrEdges) {
                        this.displayJValueSet(sessionId, isTableViewShown, showAttributes, numberPerPage, pathLength, state, elements, code);
                        elementsAreDisplayed = true;
                    } else if (elements.isEmpty()) {
                        code.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                        code.append("h3error.innerHTML = \"The query has an empty set as result.\";\n");
                    } else {
                        code.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                        code.append("h3error.innerHTML = \"Only VERTEX, EDGE or COLLECTION of vertices or edges is supported.\";\n");
                    }
                } else if (result instanceof GraphElement) {
                    elements = elements.plus((GraphElement)result);
                    this.displayJValueSet(sessionId, isTableViewShown, showAttributes, numberPerPage, pathLength, state, elements, code);
                    elementsAreDisplayed = true;
                } else {
                    code.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                    code.append("h3error.innerHTML = \"The result is of type ").append(Types.getGreqlTypeName(result)).append(".<br />Only Vertex, Edge or a Collection of vertices or edges are supported.\";\n");
                }
                if (elementsAreDisplayed) {
                    code.append("cancelGReQL();");
                }
            }
            catch (GreqlException e) {
                code.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                String errorMessage = e.getCause() != null ? e.getMessage() + "\n" + e.getCause().getMessage() : e.getMessage();
                errorMessage = errorMessage.replaceAll("\"", "'");
                errorMessage = errorMessage.replaceAll("<", "&lt;");
                errorMessage = errorMessage.replaceAll(">", "&gt;");
                errorMessage = errorMessage.replaceAll("\n", "<br />");
                errorMessage = errorMessage.replaceAll("\r", "");
                code.append("h3error.innerHTML = \"").append("<br />").append(errorMessage).append("\";\n");
            }
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    static synchronized Object evaluateGReQL(String query, Graph graph, HashMap<String, Object> boundVars) {
        GreqlEnvironmentAdapter environment = new GreqlEnvironmentAdapter(boundVars);
        return GreqlQuery.createQuery(query).evaluate(graph, environment);
    }

    public StringBuilder showTypedElements(Integer sessionId, Boolean isTableViewShown, Boolean showAttributes, Integer numberPerPage, Integer pathLength, String content) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(sessionId, code, "showTypedElements", isTableViewShown.toString(), showAttributes.toString(), numberPerPage.toString(), pathLength.toString(), content);
        if (state != null) {
            PSet<GraphElement<?, ?>> elements = JGraLab.set();
            StringBuilder notExistingElements = new StringBuilder();
            for (String s : content.split(",")) {
                GraphElement<VertexClass, Vertex> element;
                if (s.startsWith("v")) {
                    element = state.getGraph().getVertex(Integer.parseInt(s.substring(1)));
                    if (element != null) {
                        elements = elements.plus(element);
                        continue;
                    }
                    notExistingElements.append((notExistingElements.length() == 0 ? "" : ", ") + s);
                    continue;
                }
                element = state.getGraph().getEdge(Integer.parseInt(s.substring(1)));
                if (element != null) {
                    elements = elements.plus(element);
                    continue;
                }
                notExistingElements.append((notExistingElements.length() == 0 ? "" : ", ") + s);
            }
            if (!elements.isEmpty()) {
                if (elements.size() > 1) {
                    this.displayJValueSet(sessionId, isTableViewShown, showAttributes, numberPerPage, pathLength, state, elements, code);
                } else {
                    GraphElement element = (GraphElement)elements.iterator().next();
                    this.addToBreadcrumbBar(code, state, element, true);
                    if (isTableViewShown.booleanValue()) {
                        code.append("if((areVerticesShown()&&").append(element instanceof Edge).append(")||(!areVerticesShown()&&").append(element instanceof Vertex).append(")){\n");
                        code.append("switchTable();\n");
                        code.append("}\n");
                        new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, (element instanceof Vertex ? "v" : "e") + element.getId(), true, true);
                    } else {
                        new TwoDVisualizer().visualizeElements(code, state, sessionId, this.workspace.toString(), element, showAttributes, pathLength, this.currentThread);
                    }
                }
            }
            if (notExistingElements.length() > 0) {
                code.append("alert(\"");
                code.append("Following elements do not exist:\\n").append((CharSequence)notExistingElements);
                code.append("\");\n");
            }
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    private void displayJValueSet(Integer sessionId, Boolean isTableViewShown, Boolean showAttributes, Integer numberPerPage, Integer pathLength, State state, PSet<GraphElement<?, ?>> elements, StringBuilder code) {
        state.currentExplicitlyDefinedSet = elements;
        this.addToBreadcrumbBar(code, state, elements, true);
        if (isTableViewShown.booleanValue()) {
            TabularVisualizer tv = new TabularVisualizer();
            tv.calculateVertexListAndEdgeList(state, elements);
            tv.visualizeElements(code, state, numberPerPage, showAttributes, "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : ""), false, false);
            tv.visualizeElements(code, state, numberPerPage, showAttributes, "e" + (state.edgesOfTableView != null && state.edgesOfTableView.length > 0 ? Integer.valueOf(state.edgesOfTableView[0].getId()) : ""), false, false);
            if (state.verticesOfTableView != null) {
                this.showCorrectTable(code, state.verticesOfTableView[0]);
            } else if (state.edgesOfTableView != null) {
                this.showCorrectTable(code, state.edgesOfTableView[0]);
            }
        } else {
            new TwoDVisualizer().visualizeElements(code, state, sessionId, this.workspace.toString(), elements, showAttributes, pathLength, this.currentThread);
        }
    }

    public StringBuilder refresh2D(Integer sessionId, Integer pathLength, Boolean showAttributes, Integer currentIndex) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(sessionId, code, "refresh2D", pathLength.toString(), showAttributes.toString(), currentIndex.toString());
        if (state != null) {
            TwoDVisualizer tv = new TwoDVisualizer();
            tv.visualizeElements(code, state, sessionId, this.workspace.toString(), state.navigationHistory.get(currentIndex), showAttributes, pathLength, this.currentThread);
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder showElementsAs2D(Integer sessionId, Integer pathLength, Boolean showAttributes, String elementId) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(sessionId, code, "showElementsAs2D", pathLength.toString(), showAttributes.toString(), elementId);
        if (state != null) {
            int currentElementId = Integer.parseInt(elementId.substring(1));
            GraphElement<VertexClass, Vertex> currentElement = null;
            currentElement = elementId.charAt(0) == 'v' ? state.getGraph().getVertex(currentElementId) : state.getGraph().getEdge(currentElementId);
            new TwoDVisualizer().visualizeElements(code, state, sessionId, this.workspace.toString(), currentElement, showAttributes, pathLength, this.currentThread);
            this.addToBreadcrumbBar(code, state, currentElement, true);
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder changeView(Integer sessionId, Boolean isTableViewShown, Boolean showAttributes, Integer numberPerPage, Integer pathLength, Integer currentIndex) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(sessionId, code, "changeView", isTableViewShown.toString(), showAttributes.toString(), numberPerPage.toString(), pathLength.toString(), currentIndex.toString());
        if (state != null) {
            if (isTableViewShown.booleanValue()) {
                code.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
                TabularVisualizer tv = new TabularVisualizer();
                if (state.navigationHistory.get(currentIndex) instanceof Vertex) {
                    tv.calculateVertexListAndEdgeList(state);
                    Vertex current = (Vertex)state.navigationHistory.get(currentIndex);
                    this.showCorrectTable(code, current);
                    tv.visualizeElements(code, state, numberPerPage, showAttributes, "v" + current.getId(), true, true);
                    Edge latestEdge = null;
                    for (int i = state.navigationHistory.size() - 1; i >= 0; --i) {
                        if (!(state.navigationHistory.get(i) instanceof Edge)) continue;
                        latestEdge = (Edge)state.navigationHistory.get(i);
                        break;
                    }
                    if (latestEdge == null) {
                        latestEdge = state.getGraph().getFirstEdge();
                    }
                    tv.visualizeElements(code, state, 20, false, "e" + (latestEdge != null ? Integer.valueOf(latestEdge.getId()) : ""), false, true);
                    code.append("document.getElementById(\"h3HowManyVertices\").style.display = \"block\";\n");
                    code.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
                } else if (state.navigationHistory.get(currentIndex) instanceof Edge) {
                    tv.calculateVertexListAndEdgeList(state);
                    Edge current = (Edge)state.navigationHistory.get(currentIndex);
                    this.showCorrectTable(code, current);
                    tv.visualizeElements(code, state, numberPerPage, showAttributes, "e" + current.getId(), true, true);
                    Vertex latestVertex = null;
                    for (int i = state.navigationHistory.size() - 1; i >= 0; --i) {
                        if (!(state.navigationHistory.get(i) instanceof Vertex)) continue;
                        latestVertex = (Vertex)state.navigationHistory.get(i);
                        break;
                    }
                    tv.visualizeElements(code, state, 20, false, "v" + (latestVertex != null ? Integer.valueOf(latestVertex.getId()) : ""), false, true);
                    code.append("document.getElementById(\"h3HowManyEdges\").style.display = \"block\";\n");
                    code.append("document.getElementById(\"h3HowManyVertices\").style.display = \"none\";\n");
                } else {
                    PSet elements;
                    state.currentExplicitlyDefinedSet = elements = (PSet)state.navigationHistory.get(currentIndex);
                    tv.calculateVertexListAndEdgeList(state, elements);
                    tv.visualizeElements(code, state, numberPerPage, showAttributes, "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : ""), false, false);
                    tv.visualizeElements(code, state, numberPerPage, showAttributes, "e" + (state.edgesOfTableView != null && state.edgesOfTableView.length > 0 ? Integer.valueOf(state.edgesOfTableView[0].getId()) : ""), false, false);
                    if (state.verticesOfTableView != null) {
                        this.showCorrectTable(code, state.verticesOfTableView[0]);
                    } else if (state.edgesOfTableView != null) {
                        this.showCorrectTable(code, state.edgesOfTableView[0]);
                    }
                }
            } else {
                code.append("document.getElementById(\"h3HowManyElements\").style.display = \"block\";\n");
                code.append("document.getElementById(\"h3HowManyVertices\").style.display = \"none\";\n");
                code.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
                TwoDVisualizer tv = new TwoDVisualizer();
                tv.visualizeElements(code, state, sessionId, this.workspace.toString(), state.navigationHistory.get(currentIndex), showAttributes, pathLength, this.currentThread);
            }
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        code.append("resize();\n");
        code.append("resize();\n");
        return code.append("}");
    }

    private void showCorrectTable(StringBuilder code, GraphElement<?, ?> currentElement) {
        String infix = "";
        if (currentElement instanceof Vertex) {
            infix = "Vertices";
        } else if (currentElement instanceof Edge) {
            infix = "Edges";
        }
        code.append("var aShow = document.getElementById(\"aShow").append(infix).append("\");\n");
        code.append("if(aShow.hasAttribute){\n");
        code.append("if(aShow.getAttribute(\"class\")!=\"geklickt\"){\n");
        code.append("switchTable();\n}\n");
        code.append("}else{\n");
        code.append("if(aShow.getAttribute(\"className\")!=\"geklickt\"){\n");
        code.append("switchTable();\n}\n");
        code.append("}\n");
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilder refreshViewAfterTypeSubmit(Integer id, Boolean isTableViewShown, String deselectedVertexTypes, String deselectedEdgeTypes, Boolean showAttributes, Integer numberPerPage, Integer pathLength, String currentVertex, String currentEdge, Integer currentIndex) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(id, code, "refreshViewAfterTypeSubmit", isTableViewShown.toString(), deselectedVertexTypes, deselectedEdgeTypes, showAttributes.toString(), numberPerPage.toString(), pathLength.toString(), currentVertex, currentEdge, currentIndex.toString());
        if (state != null) {
            for (VertexClass vertexClass : state.selectedVertexClasses.keySet()) {
                state.selectedVertexClasses.put(vertexClass, !deselectedVertexTypes.contains("#" + vertexClass.getQualifiedName() + "#"));
            }
            for (EdgeClass edgeClass : state.selectedEdgeClasses.keySet()) {
                state.selectedEdgeClasses.put(edgeClass, !deselectedEdgeTypes.contains("#" + edgeClass.getQualifiedName() + "#"));
            }
            String curVertex = currentVertex;
            String string = currentEdge;
            if (state.currentExplicitlyDefinedSet != null) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state, state.currentExplicitlyDefinedSet);
                curVertex = "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : "");
                String string2 = "e" + (state.edgesOfTableView != null ? Integer.valueOf(state.edgesOfTableView[0].getId()) : "");
            } else {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
            }
            if (!state.navigationHistory.isEmpty()) {
                if (isTableViewShown.booleanValue()) {
                    void var14_19;
                    new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, curVertex, false, state.currentExplicitlyDefinedSet == null);
                    new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, (String)var14_19, false, state.currentExplicitlyDefinedSet == null);
                } else {
                    new TwoDVisualizer().visualizeElements(code, state, id, this.workspace.toString(), state.navigationHistory.get(currentIndex), showAttributes, pathLength, this.currentThread);
                }
            }
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder goBackToElement(Integer id, Integer indexOfNavigationHistory, Boolean isTableShown, Boolean showAttributes, Integer numberPerPage, Integer pathLength) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(id, code, "goBackToElement", indexOfNavigationHistory.toString(), isTableShown.toString(), showAttributes.toString(), numberPerPage.toString(), pathLength.toString());
        if (state != null) {
            Object currentElement = state.navigationHistory.get(indexOfNavigationHistory);
            boolean createVerticesAndEdges = false;
            if (state.currentExplicitlyDefinedSet != null) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
                state.currentExplicitlyDefinedSet = null;
                createVerticesAndEdges = true;
            }
            if (currentElement instanceof PSet) {
                state.currentExplicitlyDefinedSet = (PSet)currentElement;
                new TabularVisualizer().calculateVertexListAndEdgeList(state, state.currentExplicitlyDefinedSet);
                if (isTableShown.booleanValue()) {
                    currentElement = state.currentExplicitlyDefinedSet.iterator().next();
                }
                createVerticesAndEdges = true;
            }
            state.insertPosition = indexOfNavigationHistory + 1;
            if (isTableShown.booleanValue()) {
                boolean isVertex = currentElement instanceof Vertex;
                code.append("if(").append(isVertex ? "!" : "").append("areVerticesShown()){\n");
                code.append("switchTable();\n");
                code.append("}\n");
                new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, isVertex ? "v" + ((Vertex)currentElement).getId() : "e" + ((Edge)currentElement).getId(), true, state.currentExplicitlyDefinedSet == null);
                if (createVerticesAndEdges) {
                    new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, !isVertex ? "v" + state.getGraph().getFirstVertex().getId() : "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), true, state.currentExplicitlyDefinedSet == null);
                }
                if (!(currentElement instanceof GraphElement)) {
                    code.append("changeBackgroundColor(\"").append(isVertex ? "v" + ((Vertex)currentElement).getId() : "e" + ((Edge)currentElement).getId()).append("\");");
                }
            } else {
                new TwoDVisualizer().visualizeElements(code, state, id, this.workspace.toString(), currentElement, showAttributes, pathLength, this.currentThread);
            }
            this.addToBreadcrumbBar(code, state, null, false);
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder showIncidencesPage(Integer id, Integer displayedPage, String vertexTdId) {
        StringBuilder code = new StringBuilder("function (){\n");
        State state = StateRepository.getSession(id, code, "showIncidencesPage", displayedPage.toString(), vertexTdId);
        if (state != null) {
            new TabularVisualizer().createIncidentEdges(code, state.getGraph().getVertex(Integer.parseInt(vertexTdId.split("v")[1])), state.selectedEdgeClasses, state.selectedVertexClasses, displayedPage, vertexTdId);
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder showPageInTable(Integer id, Integer numberPerPage, Boolean showAttributes, Integer pageNumber, Boolean showVertices) {
        StringBuilder code = new StringBuilder("function (){\n");
        State state = StateRepository.getSession(id, code, "showPageInTable", numberPerPage.toString(), showAttributes.toString(), pageNumber.toString(), showVertices.toString());
        if (state != null) {
            String elementId = (showVertices != false ? "v" : "e") + (showVertices != false ? state.verticesOfTableView : state.edgesOfTableView)[numberPerPage == -1 ? 0 : (pageNumber - 1) * numberPerPage].getId();
            new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, elementId, false, state.currentExplicitlyDefinedSet == null);
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder showElementsAsTable(Integer id, Integer numberPerPage, Boolean showAttributes, String elementId) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(id, code, "showElementsAsTable", numberPerPage.toString(), showAttributes.toString(), elementId);
        if (state != null) {
            boolean isAJValueSetShown;
            boolean createVerticesAndEdges = false;
            boolean bl = isAJValueSetShown = state.currentExplicitlyDefinedSet == null;
            if (!isAJValueSetShown) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
                state.currentExplicitlyDefinedSet = null;
                createVerticesAndEdges = true;
            }
            new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, elementId, true, isAJValueSetShown);
            if (createVerticesAndEdges) {
                new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, elementId.charAt(0) == 'e' ? "v" + state.getGraph().getFirstVertex().getId() : "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), true, isAJValueSetShown);
            }
            if (elementId.startsWith("v")) {
                Vertex current = state.getGraph().getVertex(Integer.parseInt(elementId.substring(1)));
                this.addToBreadcrumbBar(code, state, current, true);
            } else {
                Edge current = state.getGraph().getEdge(Integer.parseInt(elementId.substring(1)));
                this.addToBreadcrumbBar(code, state, current, true);
            }
            code.append("changeBackgroundColor(\"").append(elementId).append("\");");
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return code.append("}");
    }

    public StringBuilder refreshTable(Integer id, Integer numberPerPage, Boolean showAttributes, String currentEdge, String currentVertex) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(id, code, "refreshTable", numberPerPage.toString(), showAttributes.toString(), currentEdge, currentVertex);
        if (state != null) {
            new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, currentEdge, false, state.currentExplicitlyDefinedSet == null);
            new TabularVisualizer().visualizeElements(code, state, numberPerPage, showAttributes, currentVertex, false, state.currentExplicitlyDefinedSet == null);
        }
        return code.append("}");
    }

    public StringBuilder initializeGraphView(Integer id) {
        StringBuilder code = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(id, code, "initializeGraphView", new String[0]);
        if (state != null) {
            code.append("document.getElementById(\"divLoadBar\").style.display = \"none\";\n");
            code.append("document.getElementById(\"checkShowAttributes\").style.visibility = \"visible\";\n");
            code.append("document.getElementById(\"pAttributes\").style.visibility = \"visible\";\n");
            code.append("document.getElementById(\"divTextVis\").style.visibility = \"visible\";\n");
            code.append("document.getElementById(\"aChangeView\").style.visibility = \"visible\";\n");
            code.append("document.getElementById(\"rightOption\").style.visibility = \"visible\";\n");
            if (dot == null || dot.isEmpty() || state.getGraph().getVCount() == 0) {
                code.append("document.getElementById(\"aChangeView\").style.visibility = \"hidden\";\n");
            }
            code.append("document.getElementById(\"divRight\").style.display = \"block\";\n");
            code.append("document.getElementById(\"divFilterWindow\").style.display = \"block\";\n");
            new SchemaVisualizer().createSchemaRepresentation(code, state);
            Vertex firstVertex = state.getGraph().getFirstVertex();
            if (firstVertex != null) {
                this.addToBreadcrumbBar(code, state, firstVertex, true);
            }
            TabularVisualizer tv = new TabularVisualizer();
            tv.calculateVertexListAndEdgeList(state);
            tv.visualizeElements(code, state, 20, false, "v" + (firstVertex != null ? Integer.valueOf(firstVertex.getId()) : ""), false, state.currentExplicitlyDefinedSet == null);
            code.append("changeBackgroundColor(\"v").append(firstVertex != null ? Integer.valueOf(firstVertex.getId()) : "").append("\");\n");
            tv.visualizeElements(code, state, 20, false, "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), false, state.currentExplicitlyDefinedSet == null);
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
            code.append("resize();\n");
            code.append("resize();\n");
        }
        return code.append("}");
    }

    public StringBuilder refreshBreadcrumbBar(Integer id, String elementId, Boolean isTableShown, Boolean isNewElement) {
        State state = sessions.get(id);
        GraphElement<VertexClass, Vertex> element = null;
        StringBuilder code = new StringBuilder("function() {\n");
        if (elementId.startsWith("v")) {
            element = state.getGraph().getVertex(Integer.parseInt(elementId.substring(1)));
            this.addToBreadcrumbBar(code, state, element, isNewElement);
        } else if (elementId.startsWith("e")) {
            element = state.getGraph().getEdge(Integer.parseInt(elementId.substring(1)));
            this.addToBreadcrumbBar(code, state, element, isNewElement);
        } else {
            int currentIndex = Integer.parseInt(elementId);
            Object currentElement = state.navigationHistory.get(currentIndex);
            state.insertPosition = currentIndex + 1;
            boolean isVertex = currentElement instanceof Vertex;
            if (isTableShown.booleanValue()) {
                code.append("if(").append(isVertex ? "!" : "").append("areVerticesShown()){\n");
                code.append("switchTable();\n");
                code.append("}\n");
            }
            this.addToBreadcrumbBar(code, state, null, isNewElement);
            code.append("current").append(isVertex ? "Vertex" : "Edge").append(" = \"").append(isVertex ? "v" + ((Vertex)currentElement).getId() : "e" + Math.abs(((Edge)currentElement).getId())).append("\";\n");
        }
        code.append("timestamp = ").append(state.lastAccess).append(";\n");
        return code.append("}");
    }

    private StringBuilder addToBreadcrumbBar(StringBuilder code, State state, Object element, Boolean wasElementOfBredcrumbBarSelected) {
        if (this.isNewElement(state, element)) {
            int i;
            int currentPage = 0;
            code.append("var divBreadcrumbBar = document.getElementById(\"divBreadcrumbBar\");\n");
            code.append("divBreadcrumbBar.innerHTML = \"\";\n");
            code.append("var breadcrumbBar = document.createElement(\"p\");\n");
            code.append("breadcrumbBar.id = \"pBreadcrumbContent0\";\n");
            code.append("breadcrumbBar.style.display = \"none\";\n");
            code.append("divBreadcrumbBar.appendChild(breadcrumbBar);\n");
            code.append("var newEntry;\n");
            if (element != null) {
                state.navigationHistory.add(state.insertPosition++, element);
                if (state.insertPosition < state.navigationHistory.size() && wasElementOfBredcrumbBarSelected.booleanValue()) {
                    for (i = state.navigationHistory.size() - 1; i >= state.insertPosition; --i) {
                        state.navigationHistory.remove(i);
                    }
                }
            }
            if (state.navigationHistory.size() <= 10) {
                for (i = 0; i < state.navigationHistory.size(); ++i) {
                    if (i > 0) {
                        code.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                        code.append("breadcrumbBar.appendChild(raquo);\n");
                    }
                    this.createBreadcrumbEntry(code, state, i, i < state.insertPosition ? "white" : "gray");
                }
            } else {
                int modul = state.navigationHistory.size() % 10;
                int pNumber = 0;
                for (int i2 = 0; i2 < state.navigationHistory.size(); ++i2) {
                    if (i2 != 0 && i2 % 10 == modul) {
                        code.append("breadcrumbBar = document.createElement(\"p\");\n");
                        code.append("breadcrumbBar.id = \"pBreadcrumbContent").append(++pNumber).append("\";\n");
                        code.append("divBreadcrumbBar.appendChild(breadcrumbBar);\n");
                        code.append("breadcrumbBar.style.display = \"none\";\n");
                        code.append("var aBack = document.createElement(\"a\");\n");
                        code.append("aBack.innerHTML = \"...\";\n");
                        code.append("aBack.href = \"javascript:switchBreadcrumbPage('pBreadcrumbContent").append(pNumber).append("','pBreadcrumbContent").append(pNumber - 1).append("');\";\n");
                        code.append("breadcrumbBar.appendChild(aBack);\n");
                        code.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                        code.append("breadcrumbBar.appendChild(raquo);\n");
                    }
                    if (i2 == state.insertPosition - 1) {
                        currentPage = pNumber;
                    }
                    this.createBreadcrumbEntry(code, state, i2, i2 < state.insertPosition ? "white" : "gray");
                    if (i2 == state.navigationHistory.size() - 1) continue;
                    code.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                    code.append("breadcrumbBar.appendChild(raquo);\n");
                    if (i2 % 10 != (modul - 1 + 10) % 10) continue;
                    code.append("var aBack = document.createElement(\"a\");\n");
                    code.append("aBack.innerHTML = \"...\";\n");
                    code.append("aBack.href = \"javascript:switchBreadcrumbPage('pBreadcrumbContent").append(pNumber).append("','pBreadcrumbContent").append(pNumber + 1).append("');\";\n");
                    code.append("breadcrumbBar.appendChild(aBack);\n");
                }
            }
            code.append("document.getElementById(\"pBreadcrumbContent").append(currentPage).append("\").style.display = \"inline\";\n");
        }
        return code;
    }

    private boolean isNewElement(State state, Object element) {
        return state.navigationHistory.isEmpty() || state.navigationHistory.get(state.insertPosition - 1) != element;
    }

    private void createBreadcrumbEntry(StringBuilder code, State state, int i, String colorOfEntry) {
        StringBuilder elementId = new StringBuilder();
        Object elem = state.navigationHistory.get(i);
        if (elem instanceof Vertex) {
            elementId.append("v").append(((Vertex)elem).getId());
        } else if (elem instanceof Edge) {
            elementId.append("e").append(((Edge)elem).getId());
        } else {
            elementId.append("{");
            boolean first = true;
            int counter = 0;
            PSet elemSet = (PSet)elem;
            for (GraphElement v : elemSet) {
                if (!first) {
                    elementId.append(", ");
                    if (counter >= 3) {
                        elementId.append("...");
                        break;
                    }
                }
                if (v instanceof Vertex) {
                    elementId.append("v").append(((Vertex)v).getId());
                } else {
                    elementId.append("e").append(((Edge)v).getId());
                }
                first = false;
                ++counter;
            }
            elementId.append("}");
        }
        code.append("newEntry = document.createElement(\"a\");\n");
        code.append("newEntry.href = \"javascript:goBackToElement(").append(i).append(",'").append((CharSequence)elementId).append("');\";\n");
        code.append("newEntry.innerHTML = \"").append((CharSequence)elementId).append("\";\n");
        code.append("newEntry.style.color = \"").append(colorOfEntry).append("\";\n");
        code.append("breadcrumbBar.appendChild(newEntry);\n");
    }

    public StringBuilder initializeBrowser(Integer id) {
        State state = sessions.get(id);
        StringBuilder code = new StringBuilder("function(){\n");
        code.append("var optgroup = document.getElementById(\"OptgroupServersideGraph\");\n");
        code.append("var oldOpt = optgroup.getElementsByTagName(\"option\");\n");
        code.append("for(var i=0; i<oldOpt.length; i++ ){\n");
        code.append("optgroup.removeChild(oldOpt[i]);\n");
        code.append("}\n");
        code.append("var childOpt;\n");
        code.append("var optValue;\n");
        code.append("var optText;\n");
        this.createOptionForGraphs(code, this.workspace);
        try {
            code.append("findPositionOf(\"").append(this.getEncodedFileName(new File(state.getGraphWrapper().graphPath), false)).append("\");\n");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        code.append("document.getElementById(\"selectGraph\").selectedIndex = selectedGraphIndex;\n");
        code.append("document.getElementById(\"checkShowAttributes\").style.visibility = \"hidden\";\n");
        code.append("document.getElementById(\"pAttributes\").style.visibility = \"hidden\";\n");
        code.append("document.getElementById(\"divTextVis\").style.visibility = \"hidden\";\n");
        code.append("document.getElementById(\"aChangeView\").style.visibility = \"hidden\";\n");
        code.append("document.getElementById(\"rightOption\").style.visibility = \"hidden\";\n");
        code.append("document.getElementById(\"checkShowAttributes\").checked = \"\";\n");
        code.append("document.getElementById(\"checkShowAttributes\").style.visible = \"hidden\";\n");
        code.append("document.getElementById(\"divTextVis\").style.display = \"inline\";\n");
        code.append("document.getElementById(\"div2DVis\").style.display = \"none\";\n");
        code.append("document.getElementById(\"divTextGraph\").style.display = \"block\";\n");
        code.append("document.getElementById(\"div2DGraph\").style.display = \"none\";\n");
        code.append("document.getElementById(\"selectElementsPerPage\").selectedIndex = 1;\n");
        code.append("document.getElementById(\"textPathLength\").value = \"1\";\n");
        code.append("document.getElementById(\"h3HowManyVertices\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"h3HowManyVertices\").style.display = \"block\";\n");
        code.append("document.getElementById(\"h3HowManyEdges\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
        code.append("document.getElementById(\"h3HowManyElements\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
        code.append("changeFilterView('divVertexClass','aVertex');\n");
        code.append("document.getElementById(\"divVertexClass\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"divEdgeClass\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"checkSelectAll\").checked = \"checked\";\n");
        code.append("document.getElementById(\"inputRegEx\").value = \"<a case insensitive regular expression>\";\n");
        code.append("cancelGReQL('aGReQL');\n");
        code.append("document.getElementById(\"textElem\").value = \"\";\n");
        code.append("document.getElementById(\"pBreadcrumbContent0\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"divTextVertex\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"divTextEdge\").innerHTML = \"\";\n");
        code.append("var divTextVertex = document.getElementById(\"divTextVertex\");\n");
        code.append("var divTextEdge = document.getElementById(\"divTextEdge\");\n");
        code.append("var aShowVertices = document.getElementById(\"aShowVertices\");\n");
        code.append("var aShowEdges = document.getElementById(\"aShowEdges\");\n");
        code.append("if(divTextVertex.hasAttribute){\n");
        code.append("divTextEdge.style.display = \"none\";\n");
        code.append("divTextVertex.style.display = \"block\";\n");
        code.append("aShowVertices.setAttribute(\"class\",\"geklickt\");\n");
        code.append("aShowEdges.setAttribute(\"class\",\"\");\n");
        code.append("}else{\n");
        code.append("divTextEdge.style.display = \"none\";\n");
        code.append("divTextVertex.style.display = \"block\";\n");
        code.append("aShowVertices.setAttribute(\"className\",\"geklickt\");\n");
        code.append("aShowEdges.setAttribute(\"className\",\"\");\n");
        code.append("}\n");
        code.append("document.getElementById(\"div2DGraph\").innerHTML = \"\";\n");
        code.append("document.getElementById(\"divLoadBar\").style.display = \"block\";\n");
        code.append("document.getElementById(\"loadBarForeground\").style.width = \"0px\";\n");
        code.append("document.getElementById(\"loadBarNumber\").innerHTML = \"0 %\";\n");
        state.lastAccess = System.currentTimeMillis();
        code.append("timestamp = ").append(state.lastAccess).append(";\n");
        code.append("loadId = window.setTimeout(\"checkLoad()\", 100);\n");
        return code.append("}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuilder checkLoading(Integer id) {
        State state = sessions.get(id);
        GraphWrapper currentGraphWrapper = state.getGraphWrapper();
        StringBuilder code = new StringBuilder("function(){\n");
        if (currentGraphWrapper.workingCallable == null) {
            return this.initializeGraphView(id);
        }
        try {
            if (currentGraphWrapper.workingCallable.isDone()) {
                currentGraphWrapper.workingCallable.get();
                if (currentGraphWrapper.excOfWorkingCallable != null) {
                    Exception e = currentGraphWrapper.excOfWorkingCallable;
                    code.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />").append(e.toString()).append("\";\n");
                    e.printStackTrace();
                    return code.append("}");
                }
                if (currentGraphWrapper.graph == null) {
                    code.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />The graph couldn't be loaded!<br />Probably an OutOfMemoryError occured.\";\n");
                    return code.append("}");
                }
                currentGraphWrapper.workingCallable = null;
                return this.initializeGraphView(id);
            }
            if (currentGraphWrapper.workingCallable.isCancelled()) {
                code.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />The loading of the graph was canceled!\";\n");
                return code.append("}");
            }
            code.append("document.getElementById(\"loadBarForeground\").style.width = \"").append(currentGraphWrapper.progress).append("px\";\n");
            code.append("document.getElementById(\"loadBarNumber\").innerHTML = \"").append(currentGraphWrapper.progress / 4).append(" %\";\n");
            code.append("loadId = window.setTimeout(\"checkLoad()\", 1000);\n");
            state.lastAccess = System.currentTimeMillis();
            code.append("timestamp = ").append(state.lastAccess).append(";\n");
            return code.append("}");
        }
        catch (Exception e) {
            code.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />").append(e.toString()).append("\";\n");
            e.printStackTrace();
        }
        return code.append("}");
    }

    private void createOptionForGraphs(StringBuilder code, File directory) {
        for (File f : directory.listFiles()) {
            if (f.exists() && f.isFile() && (f.toString().endsWith(".tg") || f.toString().endsWith(".gz"))) {
                code.append("childOpt = document.createElement(\"option\");\n");
                code.append("childOpt.setAttribute(\"value\",\"");
                try {
                    code.append(this.getEncodedFileName(f, false));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                code.append("\");\n");
                code.append("optText = document.createTextNode(\"").append(f.toString().replace(this.workspace.toString(), "").replace("\\", "/").substring(1)).append("\");\n");
                code.append("childOpt.appendChild(optText);\n");
                code.append("insertSortedIntoOption(childOpt,1,optgroup.childNodes.length-1);\n");
                continue;
            }
            if (!f.exists() || !f.isDirectory()) continue;
            this.createOptionForGraphs(code, f);
        }
    }

    public StringBuilder closeSession(Integer id) {
        State s = StateRepository.getSession(id);
        if (s != null) {
            s.delete();
        }
        return new StringBuilder("function(){}");
    }

    public StringBuilder deleteGraph(String path) {
        String graph = "";
        try {
            graph = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.returnError(e.toString());
        }
        if (!graph.startsWith(this.workspace.toString().replace("\\", "/"))) {
            return this.returnError(graph + " is not in the workspace!" + this.workspace.toString().replace("\\", "/"));
        }
        if (!graph.endsWith(".tg") && !graph.endsWith(".gz")) {
            return this.returnError(graph + " is not a graph!");
        }
        File toDelete = new File(graph);
        if (toDelete.delete()) {
            return this.showGraphsOfServer();
        }
        return this.returnError(graph + " could not be deleted.");
    }

    public StringBuilder showGraphsOfServer() {
        if (this.workspace != null) {
            StringBuilder code = new StringBuilder("function() {\n");
            code.append("var div=document.getElementById(\"divserver\");\n");
            code.append("div.innerHTML = \"\";\n");
            code.append("div.appendChild(document.createElement(\"br\"));\n");
            StringBuilder list = new StringBuilder();
            if (!this.createListOfGraphs(list, this.workspace)) {
                code.append("var h2 = document.createElement(\"h2\");\n");
                code.append("h2.innerHTML = \"There are no graphs on the server.\";\n");
                code.append("div.appendChild(h2);\n");
            } else {
                code.append("var h3 = document.createElement(\"h3\");\n");
                code.append("h3.innerHTML = \"Choose a graph from the server:\";\n");
                code.append("div.appendChild(h3);\n");
                code.append("div.appendChild(document.createElement(\"br\"));\n");
                code.append("var parentUl = document.createElement(\"ul\");\n");
                code.append("div.appendChild(parentUl);\n");
                code.append("parentUl.id = \"parentUl\";");
                code.append((CharSequence)list);
            }
            return code.append("}");
        }
        return this.returnError("This server doesn't allow to load graphs of it.");
    }

    public StringBuilder loadGraphFromServer(String path) {
        return new StringBuilder(Integer.toString(StateRepository.createNewSession(path)));
    }

    public StringBuilder loadGraphFromURI(Boolean overwrite, String uri) {
        if (!uri.toLowerCase().endsWith(".tg") && !uri.toLowerCase().endsWith(".gz")) {
            return this.returnError(uri + "isn't a graph.");
        }
        boolean isCompressed = uri.toLowerCase().endsWith(".gz");
        String[] partsOfURI = uri.split("/");
        String filename = partsOfURI[partsOfURI.length - 1];
        filename = this.workspace.toString() + "/" + filename.substring(0, filename.length() - 3);
        File graphFile = new File(filename + (isCompressed ? ".gz" : ".tg"));
        if (!overwrite.booleanValue()) {
            int endNumber = 0;
            while (graphFile.exists()) {
                graphFile = new File(filename + endNumber++ + (isCompressed ? ".gz" : ".tg"));
            }
        }
        boolean isSizeOk = true;
        try {
            URL url = new URL(uri);
            URLConnection conn = url.openConnection();
            conn.connect();
            long lengthOfFile = conn.getContentLength();
            isSizeOk = RequestThread.isSizeOk(lengthOfFile);
            if (isSizeOk) {
                int bytesRead;
                Object o = conn.getContent();
                if (!(o instanceof InputStream)) {
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).disconnect();
                    }
                    return this.returnError("This file isn't plain text.");
                }
                InputStream in = (InputStream)o;
                byte[] readData = new byte[4096];
                if (!graphFile.createNewFile()) {
                    TGraphBrowserServer.logger.info(graphFile.toString() + " overwrites an existing file or could not be created.");
                }
                FileOutputStream fos = new FileOutputStream(graphFile);
                while ((bytesRead = in.read(readData)) != -1) {
                    fos.write(readData, 0, bytesRead);
                    fos.flush();
                }
                fos.close();
                in.close();
            }
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return this.returnError(e.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnError(e.toString());
        }
        return new StringBuilder(!isSizeOk ? "-1" : Integer.toString(StateRepository.createNewSession(graphFile.getAbsolutePath())));
    }

    private StringBuilder returnError(String message) {
        StringBuilder code = new StringBuilder("function() {\n");
        code.append("document.getElementById('divError').style.display = \"block\";\n");
        code.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append(message).append("\";\n");
        code.append("document.getElementById('divNonError').style.display = \"none\";\n");
        return code.append("}");
    }

    private boolean createListOfGraphs(StringBuilder code, File directory) {
        assert (directory.exists() && directory.isDirectory());
        boolean graphsExist = false;
        for (File f : directory.listFiles()) {
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                graphsExist |= this.createListOfGraphs(code, f);
                continue;
            }
            if (!f.toString().toLowerCase().endsWith(".tg") && !f.toString().toLowerCase().endsWith(".gz")) continue;
            graphsExist = true;
            code.append("var li = document.createElement(\"li\");\n");
            code.append("var a = document.createElement(\"a\");\n");
            code.append("a.innerHTML = \"").append(Pattern.compile(Matcher.quoteReplacement("\\")).matcher(f.toString().substring(this.workspace.toString().length() + 1)).replaceAll("/")).append("\";\n");
            try {
                code.append("a.href = \"javascript:document.location = 'loadGraphFromServer?path='+'").append(this.getEncodedFileName(f, true)).append("';\";\n");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            code.append("li.appendChild(a);\n");
            code.append("li.appendChild(document.createTextNode(String.fromCharCode(160)));\n");
            code.append("var deleteA = document.createElement(\"a\");\n");
            code.append("deleteA.innerHTML = \"X\";\n");
            code.append("deleteA.href = \"javascript:deleteGraph('").append(Pattern.compile(Matcher.quoteReplacement("\\")).matcher(f.toString()).replaceAll("/")).append("');\";\n");
            code.append("deleteA.style.textDecoration = \"none\";\n");
            code.append("deleteA.style.color = \"red\";\n");
            code.append("deleteA.style.fontWeight = \"bold\";\n");
            code.append("li.appendChild(deleteA);\n");
            code.append("insertSorted(li, parentUl, 0, parentUl.childNodes.length-1);\n");
        }
        return graphsExist;
    }

    private String getEncodedFileName(File f, boolean doubleEncoding) throws UnsupportedEncodingException {
        String onceEncoded = URLEncoder.encode(f.toString(), "UTF-8");
        if (doubleEncoding) {
            return URLEncoder.encode(onceEncoded, "UTF-8");
        }
        return onceEncoded;
    }

    public StringBuilder reloadGraph(Integer sessionId) {
        State currentState = StateRepository.getSession(sessionId);
        GraphWrapper currentGraph = currentState.getGraphWrapper();
        String graphFile = currentGraph.graphPath;
        currentGraph.delete();
        currentState.initializeState(graphFile);
        return this.initializeBrowser(sessionId);
    }

    public StringBuilder keepOldGraph(Integer sessionId, String oldMethodCall) {
        State currentState = StateRepository.getSession(sessionId);
        currentState.ignoreNewGraphVersions = true;
        StringBuilder code = new StringBuilder("function() {");
        code.append(oldMethodCall).append("\n}");
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createNewSession(String graph) {
        State ret = new State(graph);
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            while (sessions.size() < nextSessionId) {
                sessions.add(null);
            }
            sessions.add(ret);
            TGraphBrowserServer.logger.info("Session " + nextSessionId + " created");
            assert (sessions.indexOf(ret) == nextSessionId);
        }
        return nextSessionId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllUnusedSessions(long timeoutMilSec) {
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            for (int i = 0; i < sessions.size(); ++i) {
                State s = sessions.get(i);
                if (s == null || s.lastAccess + timeoutMilSec >= System.currentTimeMillis()) continue;
                s.deleteUnsynchronized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State getSession(int sessionId) {
        State s;
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            assert (sessionId < sessions.size());
            s = sessions.get(sessionId);
            s.lastAccess = System.currentTimeMillis();
        }
        return s;
    }

    public static State getSession(int sessionId, StringBuilder code, String calledMethod, String ... currentParameters) {
        State state = StateRepository.getSession(sessionId);
        GraphWrapper gw = state.getGraphWrapper();
        File currentTgFile = new File(gw.graphPath);
        if (!state.ignoreNewGraphVersions && currentTgFile.exists() && currentTgFile.lastModified() > gw.lastModified) {
            code.append("var reload = confirm(\"The tg-file of the currently loaded graph has changed.\\n").append("Do you want to load the modified graph?\");\n");
            code.append("if(reload){\n");
            code.append("sendPostRequest(\"reloadGraph\");\n");
            code.append("}else{\n");
            code.append("sendPostRequest(\"keepOldGraph\",\"sendPostRequest(\\\"").append(calledMethod).append("\\\"");
            for (int i = 0; i < currentParameters.length; ++i) {
                if (i == 0) {
                    code.append(",\\\"");
                } else {
                    code.append("\\\\n");
                }
                code.append(currentParameters[i]);
            }
            code.append("\\\",true);\");\n");
            code.append("}\n");
            return null;
        }
        return state;
    }

    static {
        definedMethods = new HashMap();
        for (Method method : StateRepository.class.getMethods()) {
            definedMethods.put(method.getName(), method);
        }
        usedGraphs = new ConcurrentHashMap();
    }

    public static class LoadGraphCallable
    implements Callable<Void> {
        private GraphWrapper currentGraph;

        public LoadGraphCallable(GraphWrapper graphWrapper) {
            this.currentGraph = graphWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                Class<GraphIO> clazz = GraphIO.class;
                synchronized (GraphIO.class) {
                    this.currentGraph.progress = 0;
                    this.currentGraph.graph = GraphIO.loadGraphFromFile(this.currentGraph.graphPath, ImplementationType.GENERIC, (ProgressFunction)new MyProgressFunction(this.currentGraph));
                    assert (this.currentGraph.graph != null) : "The graph wasn't loaded correctly.";
                    this.currentGraph = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                this.currentGraph.excOfWorkingCallable = e;
                e.printStackTrace();
                this.currentGraph = null;
            }
            {
                return null;
            }
        }

        private static class MyProgressFunction
        implements ProgressFunction {
            private long totalElements;
            private static final long length = 400L;
            private int currentChar;
            private GraphWrapper currentGraph;

            public MyProgressFunction(GraphWrapper currentGraph) {
                this.currentGraph = currentGraph;
            }

            @Override
            public void finished() {
                try {
                    for (long i = (long)this.currentChar; i < 400L; ++i) {
                        ++this.currentGraph.progress;
                    }
                    this.currentGraph = null;
                }
                catch (Exception e) {
                    this.currentGraph.excOfWorkingCallable = e;
                    e.printStackTrace();
                }
            }

            @Override
            public long getUpdateInterval() {
                try {
                    return 400L > this.totalElements ? 1L : this.totalElements / 400L;
                }
                catch (Exception e) {
                    this.currentGraph.excOfWorkingCallable = e;
                    e.printStackTrace();
                    return 0L;
                }
            }

            @Override
            public void init(long elements) {
                this.currentChar = 0;
                this.totalElements = elements;
            }

            @Override
            public void progress(long processedElements) {
                try {
                    if ((long)this.currentChar < 400L) {
                        ++this.currentGraph.progress;
                        ++this.currentChar;
                    }
                }
                catch (Exception e) {
                    this.currentGraph.excOfWorkingCallable = e;
                    e.printStackTrace();
                }
            }
        }
    }

    public static class GraphWrapper {
        public Graph graph;
        public String graphPath;
        public long lastModified;
        public int numberOfUsers = 1;
        public FutureTask<?> workingCallable;
        public Exception excOfWorkingCallable;
        public String graphIdentifier;
        public int progress;

        public GraphWrapper(String graphIdentifier, String graphPath, long lastModified) {
            this.graphIdentifier = graphIdentifier;
            this.graphPath = graphPath;
            this.lastModified = lastModified;
            this.workingCallable = (FutureTask)Executors.newCachedThreadPool().submit(new LoadGraphCallable(this));
        }

        public synchronized void delete() {
            --this.numberOfUsers;
            if (this.numberOfUsers == 0) {
                if (this.workingCallable != null && !this.workingCallable.isDone() && !this.workingCallable.isCancelled()) {
                    this.workingCallable.cancel(true);
                }
                this.graph = null;
                this.workingCallable = null;
                this.excOfWorkingCallable = null;
                usedGraphs.remove(this.graphIdentifier);
            }
        }
    }

    static class State {
        public long lastAccess;
        public boolean ignoreNewGraphVersions;
        public String graphIdentifier;
        public HashMap<VertexClass, Boolean> selectedVertexClasses;
        public HashMap<EdgeClass, Boolean> selectedEdgeClasses;
        public ArrayList<Object> navigationHistory;
        public int insertPosition;
        public Vertex[] verticesOfTableView;
        public Edge[] edgesOfTableView;
        public PSet<GraphElement<?, ?>> currentExplicitlyDefinedSet;

        public State(String graphFile) {
            this.initializeState(graphFile);
        }

        public void initializeState(String graphFile) {
            this.lastAccess = System.currentTimeMillis();
            this.setGraphIdentifier(graphFile, new File(graphFile).lastModified());
            this.navigationHistory = new ArrayList();
            this.selectedVertexClasses = new HashMap();
            this.selectedEdgeClasses = new HashMap();
            this.insertPosition = 0;
            this.setGraph(graphFile, new File(graphFile).lastModified());
        }

        public Graph getGraph() {
            return StateRepository.usedGraphs.get((Object)this.graphIdentifier).graph;
        }

        public GraphWrapper getGraphWrapper() {
            return usedGraphs.get(this.graphIdentifier);
        }

        public void setGraph(String graphFile, long lastModified) {
            this.setGraphIdentifier(graphFile, lastModified);
            if (!usedGraphs.containsKey(this.graphIdentifier)) {
                usedGraphs.put(this.graphIdentifier, new GraphWrapper(this.graphIdentifier, graphFile, lastModified));
            } else {
                ++StateRepository.usedGraphs.get((Object)this.graphIdentifier).numberOfUsers;
            }
        }

        private void setGraphIdentifier(String graphFile, long lastModified) {
            this.graphIdentifier = graphFile + "_" + lastModified;
        }

        public synchronized StringBuilder getVertexTypeSet() {
            return this.convertToSet(this.selectedVertexClasses);
        }

        public synchronized StringBuilder getEdgeTypeSet() {
            return this.convertToSet(this.selectedEdgeClasses);
        }

        private synchronized StringBuilder convertToSet(HashMap<? extends GraphElementClass<?, ?>, Boolean> selectedGEClasses) {
            StringBuilder result = new StringBuilder("{");
            String delim = "";
            for (GraphElementClass<?, ?> type : selectedGEClasses.keySet()) {
                result.append(delim).append(selectedGEClasses.get(type) != false ? "" : "^").append(type.getQualifiedName()).append("!");
                delim = ", ";
            }
            result.append("}");
            return result;
        }

        public synchronized void deleteUnsynchronized() {
            int id = sessions.indexOf(this);
            sessions.set(id, null);
            this.getGraphWrapper().delete();
            this.graphIdentifier = null;
            this.edgesOfTableView = null;
            this.verticesOfTableView = null;
            this.navigationHistory = null;
            this.selectedEdgeClasses = null;
            this.selectedVertexClasses = null;
            TGraphBrowserServer.logger.info("Session " + id + " deleted");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            ArrayList arrayList = sessions;
            synchronized (arrayList) {
                this.deleteUnsynchronized();
            }
        }
    }
}

