/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasBaseDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasKeyDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.HasValueDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.SetDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDefaultPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.DefinesGraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SchemaGraph2Schema {
    private static final EdgeDirection OUTGOING = EdgeDirection.OUT;
    private de.uni_koblenz.jgralab.schema.Schema schema;
    private Schema gSchema;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gGraphElementClasses;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gTempVertexClasses;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gTempEdgeClasses;
    private ArrayList<Domain> gDomains;
    private HashMap<de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass, IncidenceClass> incidenceMap;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> gSuperEdgeClasses;
    private GraphClass graphClass;
    private boolean workInProgress = false;
    private final HashSet<String> rdNames = new HashSet();

    private void setUp() {
        this.incidenceMap = new HashMap();
        this.gGraphElementClasses = new ArrayList();
        this.gTempVertexClasses = new ArrayList();
        this.gTempEdgeClasses = new ArrayList();
        this.gDomains = new ArrayList();
        this.gSuperEdgeClasses = new ArrayList();
    }

    private void tearDown() {
        this.incidenceMap = null;
        this.gSchema = null;
        this.schema = null;
        this.graphClass = null;
        this.gGraphElementClasses = null;
        this.gDomains = null;
        this.gSuperEdgeClasses = null;
    }

    public de.uni_koblenz.jgralab.schema.Schema convert(SchemaGraph schemaGraph) {
        de.uni_koblenz.jgralab.schema.Schema schema = null;
        if (!this.workInProgress) {
            this.workInProgress = true;
            this.setUp();
            this.createSchema(schemaGraph);
            this.createGraphClass();
            this.retrieveAllGraphElementClassesAndDomains();
            this.createAllDomains();
            this.createAllGraphElementClasses();
            this.linkSuperClasses();
            this.addAllPackageComments(schemaGraph);
            schema = this.schema;
            schema.finish();
            this.tearDown();
            this.workInProgress = false;
        }
        return schema;
    }

    private void addAllPackageComments(SchemaGraph schemaGraph) {
        for (de.uni_koblenz.jgralab.grumlschema.structure.Package pkg : schemaGraph.getPackageVertices()) {
            if (pkg.getFirstAnnotatesIncidence() == null) continue;
            Package sp = this.schema.getPackage(pkg.get_qualifiedName());
            for (Comment comment : pkg.get_comments()) {
                sp.addComment(comment.get_text());
            }
        }
    }

    private void createSchema(SchemaGraph schemaGraph) {
        this.gSchema = schemaGraph.getFirstSchema();
        assert (this.gSchema != null) : "FIXME! The Schema of the SchemaGraph should be null.";
        String name = this.gSchema.get_name();
        String packagePrefix = this.gSchema.get_packagePrefix();
        assert (name != null && packagePrefix != null) : "One of attributes \"name\" or \"packagePrefix\" is null";
        this.schema = new SchemaImpl(name, packagePrefix);
        assert (this.schema.getName().equals(name) && this.schema.getPackagePrefix().equals(packagePrefix)) : "The attribute \"name\" or \"packagePrefix\" is not equal.";
    }

    private void createGraphClass() {
        assert (this.gSchema != null) : "FIXME! The Schema of the SchemaGraph shouldn't be null.";
        DefinesGraphClass definesGraphClass = this.gSchema.getFirstDefinesGraphClassIncidence(OUTGOING);
        assert (definesGraphClass != null) : "FIXME! No \"DefinesGraphClass\" edge defined.";
        assert (definesGraphClass.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.GraphClass) : "FIXME! That is not an instance of \"GraphClass\"";
        de.uni_koblenz.jgralab.grumlschema.structure.GraphClass gGraphClass = (de.uni_koblenz.jgralab.grumlschema.structure.GraphClass)definesGraphClass.getThat();
        assert (definesGraphClass.getNextDefinesGraphClassIncidence(OUTGOING) == null) : "FIXME! There is more than one GraphClass defined.";
        this.graphClass = this.schema.createGraphClass(gGraphClass.get_qualifiedName());
        this.createAllAttributes(this.graphClass, gGraphClass);
        this.createAllConstraints(this.graphClass, gGraphClass);
        if (gGraphClass.getFirstAnnotatesIncidence() != null) {
            for (String c : this.createComments(gGraphClass)) {
                this.graphClass.addComment(c);
            }
        }
        assert (this.graphClass.getQualifiedName().equals(gGraphClass.get_qualifiedName())) : "FIXME! The attribute \"qualifiedName\" is different.";
    }

    private void retrieveAllGraphElementClassesAndDomains() {
        assert (this.gSchema != null) : "FIXME! The given Schema of the SchemaGraph shouldn't be null.";
        ContainsDefaultPackage containsDefaultPackage = this.gSchema.getFirstContainsDefaultPackageIncidence(OUTGOING);
        assert (containsDefaultPackage != null) : "No \"ContainsDefaultPackage\" edge defined.";
        assert (containsDefaultPackage.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.Package) : "FIXME! That should be an instance of \"Package\".";
        de.uni_koblenz.jgralab.grumlschema.structure.Package defaultPackage = (de.uni_koblenz.jgralab.grumlschema.structure.Package)containsDefaultPackage.getThat();
        assert (containsDefaultPackage.getNextContainsDefaultPackageIncidence(OUTGOING) == null) : "FIXME! There should be only one \"ContainsDefaultPackage\".";
        this.getAllGraphElementClassesAndDomains(defaultPackage);
        this.gGraphElementClasses.addAll(this.gTempVertexClasses);
        this.gGraphElementClasses.addAll(this.gTempEdgeClasses);
    }

    private void getAllGraphElementClassesAndDomains(de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        this.getAllDomains(gPackage);
        this.getAllGraphElementClasses(gPackage);
        for (ContainsSubPackage containsSubPackage : gPackage.getContainsSubPackageIncidences(OUTGOING)) {
            assert (containsSubPackage != null && containsSubPackage.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.Package) : "FIXME! That should be an instance of Package.";
            this.getAllGraphElementClassesAndDomains(containsSubPackage.getOmega());
        }
    }

    private void getAllGraphElementClasses(de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        for (ContainsGraphElementClass containsGraphElementClass : gPackage.getContainsGraphElementClassIncidences(OUTGOING)) {
            assert (containsGraphElementClass != null && containsGraphElementClass.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass) : "FIXME! That should be an instance of GraphElementClass";
            de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gGraphElementClass = (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass)containsGraphElementClass.getThat();
            if (gGraphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
                this.gTempVertexClasses.add(gGraphElementClass);
            } else {
                this.gTempEdgeClasses.add(gGraphElementClass);
            }
            if (!(gGraphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) || ((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)gGraphElementClass).getDegree(SpecializesEdgeClass.EC, EdgeDirection.OUT) != 0) continue;
            this.gSuperEdgeClasses.add((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)gGraphElementClass);
        }
    }

    private void getAllDomains(de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        for (ContainsDomain containsDomain : gPackage.getContainsDomainIncidences(OUTGOING)) {
            assert (containsDomain.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
            this.gDomains.add(containsDomain.getOmega());
        }
    }

    private void createAllDomains() {
        for (Domain gDomain : this.gDomains) {
            assert (gDomain != null) : "Domain is null.";
            this.createDomain(gDomain);
        }
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(Domain gDomain) {
        String qualifiedName = gDomain.get_qualifiedName();
        de.uni_koblenz.jgralab.schema.Domain domain = this.schema.getDomain(qualifiedName);
        if (domain == null) {
            if (gDomain instanceof EnumDomain) {
                domain = this.createDomain((EnumDomain)gDomain);
            } else if (gDomain instanceof MapDomain) {
                domain = this.createDomain((MapDomain)gDomain);
            } else if (gDomain instanceof CollectionDomain) {
                domain = this.createDomain((CollectionDomain)gDomain);
            } else if (gDomain instanceof RecordDomain) {
                if (this.rdNames.contains(qualifiedName)) {
                    throw new RuntimeException("Cyclic dependency in record domains: " + this.rdNames);
                }
                this.rdNames.add(qualifiedName);
                domain = this.createDomain((RecordDomain)gDomain);
                this.rdNames.remove(qualifiedName);
            }
            if (gDomain.getFirstAnnotatesIncidence() != null) {
                for (String c : this.createComments(gDomain)) {
                    domain.addComment(c);
                }
            }
        }
        if (domain == null) {
            throw new GraphException("FIXME! No \"Domain\" has been created.");
        }
        assert (domain.getQualifiedName().equals(qualifiedName)) : "FIXME! The attribute \"QualifiedName\" is different (expected " + qualifiedName + ", got " + domain.getQualifiedName() + ")";
        return domain;
    }

    private String[] createComments(NamedElement gNamedElement) {
        String[] comments = new String[gNamedElement.getDegree(Annotates.EC)];
        int i = 0;
        for (Annotates a : gNamedElement.getAnnotatesIncidences()) {
            Comment comment = (Comment)a.getThat();
            assert (comment != null) : "FIXME! There are no comments.";
            assert (i < comments.length) : "There are more comments than expected.";
            comments[i++] = comment.get_text();
        }
        return comments;
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(EnumDomain gDomain) {
        return this.schema.createEnumDomain(gDomain.get_qualifiedName(), gDomain.get_enumConstants());
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(RecordDomain gDomain) {
        ArrayList<RecordDomain.RecordComponent> recordComponents = new ArrayList<RecordDomain.RecordComponent>();
        for (HasRecordDomainComponent hasRecordComponent : gDomain.getHasRecordDomainComponentIncidences(OUTGOING)) {
            assert (hasRecordComponent != null && hasRecordComponent.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
            recordComponents.add(new RecordDomain.RecordComponent(hasRecordComponent.get_name(), this.queryDomain((Domain)hasRecordComponent.getThat())));
        }
        return this.schema.createRecordDomain(gDomain.get_qualifiedName(), recordComponents);
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(CollectionDomain gDomain) {
        assert (gDomain != null) : "FIXME! The given Domain shouldn't be null.";
        HasBaseDomain hasBaseDomain = gDomain.getFirstHasBaseDomainIncidence(OUTGOING);
        assert (hasBaseDomain != null) : "FIXME! No \"HasBaseDomain\" has been defined.";
        assert (hasBaseDomain.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
        Domain base = (Domain)hasBaseDomain.getThat();
        assert (hasBaseDomain.getNextHasBaseDomainIncidence(OUTGOING) == null) : "FIXME! There is more than one \"HasBaseDomain\" defined.";
        return gDomain instanceof SetDomain ? this.schema.createSetDomain(this.queryDomain(base)) : this.schema.createListDomain(this.queryDomain(base));
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(MapDomain gDomain) {
        HasKeyDomain hasKeyDomain = gDomain.getFirstHasKeyDomainIncidence(OUTGOING);
        assert (hasKeyDomain != null) : "No \"HasKeyDomain\" has been defined.";
        assert (hasKeyDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
        Domain key = (Domain)hasKeyDomain.getThat();
        assert (hasKeyDomain.getNextHasKeyDomainIncidence(OUTGOING) == null) : "There is more than one \"HasKeyDomain\" defined.";
        HasValueDomain hasValueDomain = gDomain.getFirstHasValueDomainIncidence(OUTGOING);
        assert (hasValueDomain != null) : "No \"HasValueDomain\" has been defined.";
        assert (hasValueDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
        Domain value = (Domain)hasValueDomain.getThat();
        assert (hasValueDomain.getNextHasValueDomainIncidence(OUTGOING) == null) : "There is more than one \"HasValueDomain\" defined.";
        return this.schema.createMapDomain(this.queryDomain(key), this.queryDomain(value));
    }

    private void createAllGraphElementClasses() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gGraphElementClass : this.gGraphElementClasses) {
            if (!(gGraphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)) continue;
            this.createGraphElementClass(gGraphElementClass);
        }
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gGraphElementClass : this.gGraphElementClasses) {
            if (!(gGraphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) continue;
            this.createGraphElementClass(gGraphElementClass);
        }
    }

    private GraphElementClass<?, ?> createGraphElementClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gElement) {
        GraphElementClass<VertexClass, Vertex> element = null;
        if (gElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
            element = this.graphClass.createVertexClass(gElement.get_qualifiedName());
        } else if (gElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gEdgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)gElement;
            GoesTo to = gEdgeClass.getFirstGoesToIncidence(OUTGOING);
            assert (to != null) : "No \"To\" edge has been defined.";
            ComesFrom from = gEdgeClass.getFirstComesFromIncidence(OUTGOING);
            assert (from != null) : "No \"From\" edge has been defined.";
            element = this.createEdgeClass(gElement, (de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass)to.getThat(), (de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass)from.getThat());
            assert (to.getNextGoesToIncidence(OUTGOING) == null && from.getNextComesFromIncidence(OUTGOING) == null) : "There is more than one To or From edge defined.";
        }
        assert (element != null) : "FIXME! No GraphElementClass has been created.";
        element.setAbstract(gElement.is_abstract());
        assert (element.isAbstract() == gElement.is_abstract()) : "FIXME! The attribute \"isAbstract\" is not equal.";
        this.createAllAttributes(element, gElement);
        this.createAllConstraints(element, gElement);
        if (gElement.getFirstAnnotatesIncidence() != null) {
            for (String c : this.createComments(gElement)) {
                element.addComment(c);
            }
        }
        return element;
    }

    private EdgeClass createEdgeClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gElement, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass gTo, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass gFrom) {
        assert (gElement != null) : "The given EdgeClass of the SchemaGraph is null";
        assert (gTo != null) : "No IncidenceClass for the 'to' end";
        assert (gTo.getFirstEndsAtIncidence() != null) : "No target VertexClass at the 'to' end";
        assert (gFrom != null) : "No IncidenceClass for the 'from' end";
        assert (gFrom.getFirstEndsAtIncidence() != null) : "No target VertexClass at the 'from' end";
        VertexClass to = this.queryVertexClass((de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)gTo.getFirstEndsAtIncidence().getThat());
        int toMin = gTo.get_min();
        int toMax = gTo.get_max();
        String toRoleName = gTo.get_roleName();
        AggregationKind aggrTo = AggregationKind.valueOf(gTo.get_aggregation().toString());
        VertexClass from = this.queryVertexClass((de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)gFrom.getFirstEndsAtIncidence().getThat());
        int fromMin = gFrom.get_min();
        int fromMax = gFrom.get_max();
        String fromRoleName = gFrom.get_roleName();
        AggregationKind aggrFrom = AggregationKind.valueOf(gFrom.get_aggregation().toString());
        String qualifiedName = gElement.get_qualifiedName();
        EdgeClass edgeClass = this.graphClass.createEdgeClass(qualifiedName, from, fromMin, fromMax, fromRoleName, aggrFrom, to, toMin, toMax, toRoleName, aggrTo);
        assert (edgeClass != null) : "No EdgeClass was created.";
        assert (edgeClass.getFrom() != null) : "No from IncidenceClass was created.";
        assert (edgeClass.getTo() != null) : "No to IncidenceClass was created.";
        this.incidenceMap.put(gFrom, edgeClass.getFrom());
        this.incidenceMap.put(gTo, edgeClass.getTo());
        return edgeClass;
    }

    private void createAllConstraints(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> element, AttributedElementClass gElement) {
        for (HasConstraint hasConstraint : gElement.getHasConstraintIncidences(OUTGOING)) {
            assert (hasConstraint != null && hasConstraint.getThat() instanceof Constraint) : "FIXME! That should be an instance of Constraint.";
            Constraint constraint = (Constraint)hasConstraint.getThat();
            element.addConstraint(new ConstraintImpl(constraint.get_message(), constraint.get_predicateQuery(), constraint.get_offendingElementsQuery()));
        }
    }

    private void createAllAttributes(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> element, AttributedElementClass gElement) {
        for (HasAttribute hasAttribute : gElement.getHasAttributeIncidences(OUTGOING)) {
            assert (hasAttribute != null && hasAttribute.getThat() instanceof Attribute) : "That should be an instance of Attribute.";
            Attribute attribute = (Attribute)hasAttribute.getThat();
            assert (attribute.get_name() != null) : "The name of the Attribute is null.";
            HasDomain hasDomain = attribute.getFirstHasDomainIncidence(OUTGOING);
            assert (hasDomain != null) : "No \"HasDomain\" edge has been defined.";
            assert (hasDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
            element.createAttribute(attribute.get_name(), this.queryDomain((Domain)hasDomain.getThat()), attribute.get_defaultValue());
            assert (hasDomain.getNextHasDomainIncidence(OUTGOING) == null);
        }
    }

    private void linkSuperClasses() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gGraphElement : this.gGraphElementClasses) {
            Object element = this.schema.getAttributedElementClass(gGraphElement.get_qualifiedName());
            assert (element != null) : "FIXME! No AttributedElementClass object found.";
            if (gGraphElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
                assert (element instanceof VertexClass) : "AttributeElementClass object of Schema is not an instance of an VertexClass.";
                this.linkSuperClasses((VertexClass)element, (de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)gGraphElement);
                continue;
            }
            assert (gGraphElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) : "GraphElementClass object of the SchemaGraph is not an instance of EdgeClass.";
            assert (element instanceof EdgeClass) : "GraphElementClass object of the Schema is not an instance of EdgeClass.";
            this.linkSuperClasses((EdgeClass)element, (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)gGraphElement);
        }
    }

    private void linkSuperClasses(EdgeClass edgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gEdgeClass) {
        ArrayList<EdgeClass> superClasses = new ArrayList<EdgeClass>();
        for (SpecializesEdgeClass specializesEdgeClass : gEdgeClass.getSpecializesEdgeClassIncidences(OUTGOING)) {
            assert (specializesEdgeClass != null && specializesEdgeClass.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) : "That should be an instance of EdgeClass.";
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gSuperClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)specializesEdgeClass.getThat();
            Object superClass = this.schema.getAttributedElementClass(gSuperClass.get_qualifiedName());
            assert (superClass instanceof EdgeClass) : "The retrieved superclass is not an instance of EdgeClass.";
            superClasses.add((EdgeClass)superClass);
        }
        for (EdgeClass superClass : superClasses) {
            edgeClass.addSuperClass(superClass);
            ((IncidenceClassImpl)edgeClass.getFrom()).addSubsettedIncidenceClass(superClass.getFrom());
            ((IncidenceClassImpl)edgeClass.getTo()).addSubsettedIncidenceClass(superClass.getTo());
        }
    }

    private void linkSuperClasses(VertexClass vertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass gVertexClass) {
        ArrayList<VertexClass> superClasses = new ArrayList<VertexClass>();
        for (SpecializesVertexClass specializesVertexClass : gVertexClass.getSpecializesVertexClassIncidences(OUTGOING)) {
            assert (specializesVertexClass.getOmega() instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) : "That should be an instance of VertexClass.";
            de.uni_koblenz.jgralab.grumlschema.structure.VertexClass gSuperClass = specializesVertexClass.getOmega();
            Object superClass = this.schema.getAttributedElementClass(gSuperClass.get_qualifiedName());
            assert (superClass instanceof VertexClass) : "The retrieved superclass is not an instance of VertexClass.";
            superClasses.add((VertexClass)superClass);
        }
        for (VertexClass superClass : superClasses) {
            vertexClass.addSuperClass(superClass);
        }
    }

    private VertexClass queryVertexClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass gElement) {
        Object element = this.schema.getAttributedElementClass(gElement.get_qualifiedName());
        return element instanceof VertexClass ? (VertexClass)element : null;
    }

    private de.uni_koblenz.jgralab.schema.Domain queryDomain(Domain gDomain) {
        de.uni_koblenz.jgralab.schema.Domain domain = this.schema.getDomain(gDomain.get_qualifiedName());
        if (domain == null) {
            domain = this.createDomain(gDomain);
        }
        return domain;
    }
}

