/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.BooleanDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.DoubleDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.IntegerDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.LongDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.StringDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2schemagraph.Schema2SchemaGraph;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;

public class SchemaGraph2XMI {
    private final TreeSet<Domain> typesToBeDeclaredAtTheEnd = new TreeSet();
    private boolean isBidirectional = false;

    public static void main(String[] args) throws GraphIOException {
        System.out.println("SchemaGraph to XMI");
        System.out.println("==================");
        SchemaGraph2XMI s = new SchemaGraph2XMI();
        CommandLine cli = SchemaGraph2XMI.processCommandLineOptions(args);
        assert (cli != null) : "No CommandLine object has been generated!";
        s.isBidirectional = cli.hasOption("b");
        String outputName = cli.getOptionValue("o");
        try {
            if (cli.hasOption("ig")) {
                s.process(GrumlSchema.instance().loadSchemaGraph(cli.getOptionValue("ig")), outputName);
            } else {
                s.process(new Schema2SchemaGraph().convert2SchemaGraph(GraphIO.loadSchemaFromFile(cli.getOptionValue("i"))), outputName);
            }
        }
        catch (Exception e) {
            System.err.println("An Exception occured while processing " + (cli.hasOption("i") ? cli.getOptionValue("i") : cli.getOptionValue("ig")) + ".");
            System.err.println(e.getMessage());
            e.printStackTrace();
            e.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + SchemaGraph2XMI.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option output = new Option("o", "output", true, "(required): the output xmi file name");
        output.setRequired(true);
        output.setArgName("file");
        oh.addOption(output);
        Option schemaGraph = new Option("ig", "inputSchemaGraph", true, "(required or -i):if set, the schemaGraph is converted into a xmi.");
        schemaGraph.setRequired(false);
        schemaGraph.setArgs(0);
        output.setArgName("file");
        oh.addOption(schemaGraph);
        Option schema = new Option("i", "inputSchema", true, "(required or -ig): TG-file of the schema which should be converted into a xmi.");
        schema.setRequired(false);
        schema.setArgName("file");
        oh.addOption(schema);
        OptionGroup input = new OptionGroup();
        input.addOption(schemaGraph);
        input.addOption(schema);
        input.setRequired(true);
        oh.addOptionGroup(input);
        Option bidirectional = new Option("b", "bidirectional", false, "(optional): If set the EdgeClasses are created as bidirectional associations.");
        bidirectional.setRequired(false);
        oh.addOption(bidirectional);
        return oh.parse(args);
    }

    public void process(SchemaGraph schemaGraph, String xmiName) throws XMLStreamException, IOException {
        this.createXMI(xmiName, schemaGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXMI(String xmiName, SchemaGraph schemaGraph) throws XMLStreamException, IOException {
        Writer out = null;
        XMLStreamWriter writer = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmiName), "UTF-8"));
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            writer = factory.createXMLStreamWriter(out);
            writer.writeStartDocument("UTF-8", "1.0");
            this.createRootElement(writer, schemaGraph);
            writer.writeEndDocument();
            writer.flush();
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private void createRootElement(XMLStreamWriter writer, SchemaGraph schemaGraph) throws XMLStreamException {
        writer.writeStartElement("xmi", "XMI", "http://schema.omg.org/spec/XMI/2.1");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "version", "2.1");
        writer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.setPrefix("Ecore", "http://www.eclipse.org/uml2/schemas/Ecore/5");
        writer.setPrefix("ecore", "http://www.eclipse.org/emf/2002/Ecore");
        writer.setPrefix("uml", "http://schema.omg.org/spec/UML/2.1.1");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.eclipse.org/uml2/schemas/Ecore/5 pathmap://UML_PROFILES/Ecore.profile.uml#_z1OFcHjqEdy8S4Cr8Rc_NA http://schema.omg.org/spec/UML/2.1.1 http://www.eclipse.org/uml2/2.1.0/UML");
        this.createModelElement(writer, schemaGraph);
        writer.writeEndElement();
    }

    private void createModelElement(XMLStreamWriter writer, SchemaGraph schemaGraph) throws XMLStreamException {
        Schema schema = schemaGraph.getFirstSchema();
        writer.writeStartElement("http://schema.omg.org/spec/UML/2.1.1", "Model");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", schema.get_packagePrefix() + "." + schema.get_name());
        writer.writeAttribute("name", schema.get_packagePrefix() + "." + schema.get_name());
        this.createAttributedElementClass(writer, schemaGraph.getFirstGraphClass());
        this.createPackage(writer, (Package)schemaGraph.getFirstSchema().getFirstContainsDefaultPackageIncidence().getThat());
        if (!this.typesToBeDeclaredAtTheEnd.isEmpty()) {
            this.createTypes(writer);
        }
        this.createProfileApplication(writer);
        writer.writeEndElement();
    }

    private void createPackage(XMLStreamWriter writer, Package pack) throws XMLStreamException {
        boolean packageTagHasToBeClosed = false;
        if (!this.isPackageEmpty(pack)) {
            if (!pack.get_qualifiedName().equals("")) {
                boolean bl = packageTagHasToBeClosed = pack.getFirstAnnotatesIncidence() != null || pack.getFirstContainsDomainIncidence() != null || pack.getFirstContainsGraphElementClassIncidence() != null || pack.getFirstContainsSubPackageIncidence(EdgeDirection.OUT) != null;
                if (packageTagHasToBeClosed) {
                    writer.writeStartElement("packagedElement");
                } else {
                    writer.writeEmptyElement("packagedElement");
                }
                writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Package");
                writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", pack.get_qualifiedName());
                writer.writeAttribute("name", this.extractSimpleName(pack.get_qualifiedName()));
            }
            this.createComments(writer, pack);
            for (ContainsDomain cd : pack.getContainsDomainIncidences()) {
                Domain domain = (Domain)cd.getThat();
                if (domain.get_qualifiedName().equals("Boolean") || domain.get_qualifiedName().equals("Double") || domain.get_qualifiedName().equals("Integer") || domain.get_qualifiedName().equals("Long") || domain.get_qualifiedName().equals("String")) continue;
                if (domain instanceof EnumDomain) {
                    this.createEnum(writer, (EnumDomain)domain);
                    continue;
                }
                if (!(domain instanceof RecordDomain)) continue;
                this.createRecordDomain(writer, (RecordDomain)domain);
            }
            for (ContainsGraphElementClass cgec : pack.getContainsGraphElementClassIncidences()) {
                GraphElementClass gec = (GraphElementClass)cgec.getThat();
                this.createAttributedElementClass(writer, gec);
            }
            for (ContainsSubPackage csp : pack.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
                this.createPackage(writer, (Package)csp.getThat());
            }
            if (packageTagHasToBeClosed) {
                writer.writeEndElement();
            }
        }
    }

    private boolean isPackageEmpty(Package pack) {
        boolean isPackageEmpty;
        boolean bl = isPackageEmpty = pack.getFirstAnnotatesIncidence() == null && pack.getFirstContainsDomainIncidence() == null && pack.getFirstContainsGraphElementClassIncidence() == null;
        if (!isPackageEmpty) {
            return false;
        }
        for (ContainsSubPackage csp : pack.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
            if (this.isPackageEmpty((Package)csp.getThat())) continue;
            return false;
        }
        return true;
    }

    private void createRecordDomain(XMLStreamWriter writer, RecordDomain recordDomain) throws XMLStreamException {
        writer.writeStartElement("packagedElement");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Class");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", recordDomain.get_qualifiedName());
        writer.writeAttribute("name", this.extractSimpleName(recordDomain.get_qualifiedName()));
        this.createExtension(writer, recordDomain, "record");
        this.createComments(writer, recordDomain);
        for (HasRecordDomainComponent hrdc : recordDomain.getHasRecordDomainComponentIncidences(EdgeDirection.OUT)) {
            this.createAttribute(writer, hrdc.get_name(), null, (Domain)hrdc.getThat(), recordDomain.get_qualifiedName() + "_" + hrdc.get_name());
        }
        writer.writeEndElement();
    }

    private void createEnum(XMLStreamWriter writer, EnumDomain enumDomain) throws XMLStreamException {
        writer.writeStartElement("packagedElement");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Enumeration");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", enumDomain.get_qualifiedName());
        writer.writeAttribute("name", this.extractSimpleName(enumDomain.get_qualifiedName()));
        this.createComments(writer, enumDomain);
        for (String enumConst : enumDomain.get_enumConstants()) {
            writer.writeEmptyElement("ownedLiteral");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:EnumerationLiteral");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", enumDomain.get_qualifiedName() + "_" + enumConst);
            writer.writeAttribute("name", enumConst);
            writer.writeAttribute("classifier", enumDomain.get_qualifiedName());
        }
        writer.writeEndElement();
    }

    private void createProfileApplication(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("profileApplication");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:ProfileApplication");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", "profileApplication" + System.currentTimeMillis());
        this.createExtension(writer, null, null);
        writer.writeEmptyElement("appliedProfile");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Profile");
        writer.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/StandardProfileL2.xmi#_0");
        writer.writeEndElement();
    }

    private void createTypes(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("packagedElement");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Package");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", "PrimitiveTypes");
        writer.writeAttribute("name", "PrimitiveTypes");
        for (Domain domain : this.typesToBeDeclaredAtTheEnd) {
            writer.writeEmptyElement("packagedElement");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
            writer.writeAttribute("name", this.extractSimpleName(domain.get_qualifiedName()));
        }
        writer.writeEndElement();
    }

    private void createAttributedElementClass(XMLStreamWriter writer, AttributedElementClass aeclass) throws XMLStreamException {
        boolean isEmptyGraphElementClass;
        boolean bl = isEmptyGraphElementClass = aeclass.getFirstAnnotatesIncidence() == null && aeclass.getFirstHasAttributeIncidence() == null && aeclass.getFirstHasConstraintIncidence() == null && aeclass instanceof GraphElementClass && !((GraphElementClass)aeclass).is_abstract() && (aeclass instanceof VertexClass && ((VertexClass)aeclass).getFirstSpecializesVertexClassIncidence(EdgeDirection.OUT) == null && !this.hasChildIncidence((VertexClass)aeclass) || aeclass instanceof EdgeClass && ((EdgeClass)aeclass).getFirstSpecializesEdgeClassIncidence(EdgeDirection.OUT) == null && this.isBidirectional);
        if (isEmptyGraphElementClass) {
            writer.writeEmptyElement("packagedElement");
        } else {
            writer.writeStartElement("packagedElement");
        }
        if (aeclass instanceof EdgeClass) {
            if (aeclass.getFirstHasAttributeIncidence() == null) {
                writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Association");
            } else {
                writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:AssociationClass");
            }
        } else {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Class");
        }
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", aeclass.get_qualifiedName());
        writer.writeAttribute("name", this.extractSimpleName(aeclass.get_qualifiedName()));
        if (aeclass instanceof EdgeClass) {
            EdgeClass ec = (EdgeClass)aeclass;
            writer.writeAttribute("memberEnd", ((VertexClass)((IncidenceClass)ec.getFirstComesFromIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName() + "_incidence_" + ec.get_qualifiedName() + "_from " + ((VertexClass)((IncidenceClass)ec.getFirstGoesToIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName() + "_incidence_" + ec.get_qualifiedName() + "_to");
        }
        if (aeclass instanceof GraphElementClass && ((GraphElementClass)aeclass).is_abstract()) {
            writer.writeAttribute("isAbstract", "true");
            this.createExtension(writer, aeclass, "abstract");
        }
        if (aeclass instanceof GraphClass) {
            this.createExtension(writer, aeclass, "graphclass");
        }
        this.createComments(writer, aeclass);
        this.createConstraints(writer, aeclass);
        if (aeclass instanceof VertexClass) {
            for (SpecializesVertexClass svc : ((VertexClass)aeclass).getSpecializesVertexClassIncidences(EdgeDirection.OUT)) {
                this.createGeneralization(writer, "generalization_" + aeclass.get_qualifiedName(), ((VertexClass)svc.getThat()).get_qualifiedName());
            }
        } else if (aeclass instanceof EdgeClass) {
            for (SpecializesEdgeClass svc : ((EdgeClass)aeclass).getSpecializesEdgeClassIncidences(EdgeDirection.OUT)) {
                this.createGeneralization(writer, "generalization_" + aeclass.get_qualifiedName(), ((EdgeClass)svc.getThat()).get_qualifiedName());
            }
        }
        this.createAttributes(writer, aeclass);
        if (aeclass instanceof VertexClass) {
            this.createIncidences(writer, (VertexClass)aeclass);
        } else if (aeclass instanceof EdgeClass) {
            this.createIncidences(writer, (EdgeClass)aeclass);
        }
        if (!isEmptyGraphElementClass) {
            writer.writeEndElement();
        }
    }

    private boolean hasChildIncidence(VertexClass vertexClass) {
        if (vertexClass.getFirstEndsAtIncidence() == null) {
            return false;
        }
        for (EndsAt ea : vertexClass.getEndsAtIncidences()) {
            IncidenceClass ic = (IncidenceClass)ea.getThat();
            if (!this.hasToBeCreatedAtVertex(ic)) continue;
            return true;
        }
        return false;
    }

    private boolean hasToBeCreatedAtVertex(IncidenceClass incidence) {
        boolean isAlphaVertexClass;
        boolean bl = isAlphaVertexClass = incidence.getFirstComesFromIncidence() != null;
        if (this.isBidirectional) {
            return true;
        }
        return isAlphaVertexClass;
    }

    private void createIncidences(XMLStreamWriter writer, EdgeClass edgeClass) throws XMLStreamException {
        IncidenceClass alphaIncidence = (IncidenceClass)edgeClass.getFirstComesFromIncidence().getThat();
        IncidenceClass omegaIncidence = (IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat();
        VertexClass alphaVertex = (VertexClass)alphaIncidence.getFirstEndsAtIncidence().getThat();
        VertexClass omegaVertex = (VertexClass)omegaIncidence.getFirstEndsAtIncidence().getThat();
        if (!this.hasToBeCreatedAtVertex(alphaIncidence)) {
            this.createIncidence(writer, omegaIncidence, edgeClass, alphaIncidence, omegaVertex, alphaVertex.get_qualifiedName(), true);
        }
        if (!this.hasToBeCreatedAtVertex(omegaIncidence)) {
            this.createIncidence(writer, alphaIncidence, edgeClass, omegaIncidence, alphaVertex, omegaVertex.get_qualifiedName(), true);
        }
    }

    private void createIncidences(XMLStreamWriter writer, VertexClass vertexClass) throws XMLStreamException {
        for (EndsAt ea : vertexClass.getEndsAtIncidences()) {
            IncidenceClass incidence = (IncidenceClass)ea.getThat();
            if (!this.hasToBeCreatedAtVertex(incidence)) continue;
            boolean isVertexClassAlphaVertex = incidence.getFirstComesFromIncidence() != null;
            EdgeClass edgeClass = (EdgeClass)(isVertexClassAlphaVertex ? incidence.getFirstComesFromIncidence() : incidence.getFirstGoesToIncidence()).getThat();
            IncidenceClass otherIncidence = (IncidenceClass)(isVertexClassAlphaVertex ? edgeClass.getFirstGoesToIncidence() : edgeClass.getFirstComesFromIncidence()).getThat();
            VertexClass connectedVertexClass = (VertexClass)otherIncidence.getFirstEndsAtIncidence().getThat();
            this.createIncidence(writer, otherIncidence, edgeClass, incidence, connectedVertexClass, vertexClass.get_qualifiedName(), false);
        }
    }

    private void createIncidence(XMLStreamWriter writer, IncidenceClass otherIncidence, EdgeClass edgeClass, IncidenceClass incidence, VertexClass connectedVertexClass, String qualifiedNameOfVertexClass, boolean createOwnedEnd) throws XMLStreamException {
        String incidenceId = qualifiedNameOfVertexClass + "_incidence_" + edgeClass.get_qualifiedName() + (incidence.getFirstComesFromIncidence() != null ? "_from" : "_to");
        writer.writeStartElement(createOwnedEnd ? "ownedEnd" : "ownedAttribute");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Property");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", incidenceId);
        if (otherIncidence.get_roleName() != null && !otherIncidence.get_roleName().isEmpty()) {
            writer.writeAttribute("name", otherIncidence.get_roleName());
        } else if (this.isRoleNameNecessary(edgeClass, connectedVertexClass.get_qualifiedName())) {
            String newRoleName = this.createNewUniqueRoleName(connectedVertexClass);
            writer.writeAttribute("name", newRoleName);
            otherIncidence.set_roleName(newRoleName);
        }
        writer.writeAttribute("visibility", "private");
        writer.writeAttribute("type", connectedVertexClass.get_qualifiedName());
        if (otherIncidence.get_aggregation() == AggregationKind.SHARED) {
            writer.writeAttribute("aggregation", "shared");
        } else if (otherIncidence.get_aggregation() == AggregationKind.COMPOSITE) {
            writer.writeAttribute("aggregation", "composite");
        }
        writer.writeAttribute("association", edgeClass.get_qualifiedName());
        writer.writeEmptyElement("upperValue");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralUnlimitedNatural");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", incidenceId + "_uppervalue");
        writer.writeAttribute("value", otherIncidence.get_max() == Integer.MAX_VALUE ? "*" : Integer.toString(otherIncidence.get_max()));
        writer.writeEmptyElement("lowerValue");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralInteger");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", incidenceId + "_lowervalue");
        writer.writeAttribute("value", incidence.get_min() == Integer.MAX_VALUE ? "*" : Integer.toString(otherIncidence.get_min()));
        writer.writeEndElement();
    }

    private String createNewUniqueRoleName(VertexClass connectedVertexClass) {
        GreqlEnvironmentAdapter environment;
        GreqlQuery query;
        Object result;
        String baseRolename = connectedVertexClass.get_qualifiedName().replaceAll(Pattern.quote("."), "_");
        if (Character.isUpperCase(baseRolename.charAt(0))) {
            baseRolename = Character.toLowerCase(baseRolename.charAt(0)) + baseRolename.substring(1);
        }
        HashMap<String, Object> boundVars = new HashMap<String, Object>();
        boundVars.put("start", connectedVertexClass);
        int counter = 0;
        do {
            query = GreqlQuery.createQuery("using start:exists ic:start<->{structure.SpecializesVertexClass}*<->{structure.EndsAt}<->{structure.ComesFrom,structure.GoesTo}^2@ic.roleName=\"" + baseRolename + (++counter == 1 ? "" : Integer.valueOf(counter)) + "\"");
            environment = new GreqlEnvironmentAdapter(boundVars);
        } while ((result = query.evaluate(connectedVertexClass.getGraph(), environment)) instanceof Boolean && ((Boolean)result).booleanValue());
        return baseRolename + (counter == 1 ? "" : Integer.valueOf(counter));
    }

    private boolean isRoleNameNecessary(EdgeClass edgeClass, String qualifiedName) {
        if (this.isBidirectional) {
            return true;
        }
        return ((VertexClass)((IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName().equals(qualifiedName);
    }

    private void createGeneralization(XMLStreamWriter writer, String id, String idOfSpecializedClass) throws XMLStreamException {
        writer.writeEmptyElement("generalization");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Generalization");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id);
        writer.writeAttribute("general", idOfSpecializedClass);
    }

    private void createExtension(XMLStreamWriter writer, NamedElement nelement, String keyValue) throws XMLStreamException {
        writer.writeStartElement("http://schema.omg.org/spec/XMI/2.1", "Extension");
        writer.writeAttribute("extender", "http://www.eclipse.org/emf/2002/Ecore");
        writer.writeStartElement("eAnnotations");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EAnnotation");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", nelement != null ? nelement.get_qualifiedName() + "_" + "eAnnotations" : "eAnnotations" + System.currentTimeMillis());
        writer.writeAttribute("source", "http://www.eclipse.org/uml2/2.0.0/UML");
        if (nelement != null) {
            writer.writeEmptyElement("details");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EStringToStringMapEntry");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", nelement.get_qualifiedName() + "_" + "details");
            writer.writeAttribute("key", keyValue);
        } else {
            writer.writeEmptyElement("references");
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EPackage");
            writer.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/StandardProfileL2.xmi#_yzU58YinEdqtvbnfB2L_5w");
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void createAttributes(XMLStreamWriter writer, AttributedElementClass aeclass) throws XMLStreamException {
        for (HasAttribute hasAttribute : aeclass.getHasAttributeIncidences()) {
            Attribute attribute = (Attribute)hasAttribute.getThat();
            this.createAttribute(writer, attribute.get_name(), attribute.get_defaultValue(), (Domain)attribute.getFirstHasDomainIncidence().getThat(), aeclass.get_qualifiedName() + "_" + ((Attribute)hasAttribute.getThat()).get_name());
        }
    }

    private void createAttribute(XMLStreamWriter writer, String attributeName, String defaultValue, Domain domain, String id) throws XMLStreamException {
        boolean hasDefaultValue;
        boolean bl = hasDefaultValue = defaultValue != null && !defaultValue.isEmpty();
        if (!(hasDefaultValue || domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain)) {
            writer.writeEmptyElement("ownedAttribute");
        } else {
            writer.writeStartElement("ownedAttribute");
        }
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Property");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id);
        writer.writeAttribute("name", attributeName);
        writer.writeAttribute("visibility", "private");
        if (domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain) {
            this.createType(writer, domain);
        } else {
            writer.writeAttribute("type", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
        }
        if (hasDefaultValue) {
            this.createDefaultValue(writer, defaultValue, id, domain);
        }
        if (hasDefaultValue || domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain) {
            writer.writeEndElement();
        }
        if (domain instanceof LongDomain || domain instanceof DoubleDomain || domain instanceof CollectionDomain || domain instanceof MapDomain) {
            this.typesToBeDeclaredAtTheEnd.add(domain);
        }
    }

    private void createDefaultValue(XMLStreamWriter writer, String defaultValue, String id, Domain domain) throws XMLStreamException {
        if (domain instanceof LongDomain || domain instanceof EnumDomain) {
            writer.writeEmptyElement("defaultValue");
        } else {
            writer.writeStartElement("defaultValue");
        }
        if (domain instanceof BooleanDomain) {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralBoolean");
        } else if (domain instanceof IntegerDomain || domain instanceof LongDomain) {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralInteger");
        } else if (domain instanceof EnumDomain) {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:InstanceValue");
        } else {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:OpaqueExpression");
        }
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id + "_defaultValue");
        if (domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof LongDomain || domain instanceof EnumDomain) {
            if (domain instanceof BooleanDomain) {
                writer.writeAttribute("value", defaultValue.equals("t") ? "true" : "false");
            } else if (domain instanceof EnumDomain) {
                writer.writeAttribute("name", defaultValue);
                writer.writeAttribute("type", domain.get_qualifiedName());
                writer.writeAttribute("instance", domain.get_qualifiedName() + "_" + defaultValue);
            } else {
                writer.writeAttribute("value", defaultValue);
            }
            if (domain instanceof BooleanDomain || domain instanceof IntegerDomain) {
                this.createType(writer, domain);
            }
        } else {
            if (domain instanceof StringDomain) {
                this.createType(writer, domain);
            } else {
                writer.writeAttribute("type", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
            }
            writer.writeStartElement("body");
            writer.writeCharacters(defaultValue);
            writer.writeEndElement();
        }
        if (!(domain instanceof LongDomain) && !(domain instanceof EnumDomain)) {
            writer.writeEndElement();
        }
    }

    private void createType(XMLStreamWriter writer, Domain domain) throws XMLStreamException {
        writer.writeEmptyElement("type");
        if (domain instanceof BooleanDomain) {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            writer.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#Boolean");
        } else if (domain instanceof IntegerDomain) {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            writer.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#Integer");
        } else {
            writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            writer.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#String");
        }
    }

    private void createConstraints(XMLStreamWriter writer, AttributedElementClass aeclass) throws XMLStreamException {
        int uniqueNumber = 0;
        for (HasConstraint hasConstraint : aeclass.getHasConstraintIncidences()) {
            this.createConstraint(writer, (Constraint)hasConstraint.getThat(), aeclass.get_qualifiedName() + "_" + "ownedRule" + uniqueNumber++, aeclass.get_qualifiedName());
        }
    }

    private void createConstraint(XMLStreamWriter writer, Constraint constraint, String id, String constrainedElement) throws XMLStreamException {
        this.createConstraint(writer, "\"" + constraint.get_message() + "\" \"" + constraint.get_predicateQuery() + "\" \"" + constraint.get_offendingElementsQuery() + "\"", id, constrainedElement);
    }

    private void createConstraint(XMLStreamWriter writer, String constraintContent, String id, String constrainedElement) throws XMLStreamException {
        writer.writeStartElement("ownedRule");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Constraint");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id);
        writer.writeAttribute("constrainedElement", constrainedElement);
        writer.writeStartElement("specification");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:OpaqueExpression");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id + "_" + "specification");
        writer.writeStartElement("language");
        writer.writeEndElement();
        writer.writeStartElement("body");
        writer.writeCharacters(constraintContent);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void createComments(XMLStreamWriter writer, NamedElement nelement) throws XMLStreamException {
        int uniqueNumber = 0;
        for (Annotates annotates : nelement.getAnnotatesIncidences()) {
            this.createComment(writer, (Comment)annotates.getThat(), nelement.get_qualifiedName() + "_" + "ownedComment" + uniqueNumber++, nelement.get_qualifiedName());
        }
    }

    private void createComment(XMLStreamWriter writer, Comment comment, String id, String annotatedElement) throws XMLStreamException {
        writer.writeStartElement("ownedComment");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Comment");
        writer.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", id);
        writer.writeAttribute("annotatedElement", annotatedElement);
        writer.writeStartElement("body");
        writer.writeCharacters("<p>\r\n\t" + comment.get_text().replaceAll(Pattern.quote("\n"), "\r\n</p>\r\n<p>\r\n\t") + "\r\n</p>");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private String extractSimpleName(String qualifiedName) {
        int lastIndexOfDot = qualifiedName.lastIndexOf(46);
        if (lastIndexOfDot >= 0) {
            return qualifiedName.substring(lastIndexOfDot + 1);
        }
        return qualifiedName;
    }
}

