/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GraphValidator;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.StringDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.rsa2tg.ProcessingException;
import de.uni_koblenz.jgralab.utilities.rsa2tg.SchemaGraph2Tg;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.pcollections.PVector;

public class Rsa2Tg
extends XmlProcessor {
    private static final String OPTION_FILENAME_VALIDATION = "r";
    private static final String OPTION_FILENAME_SCHEMA_GRAPH = "s";
    private static final String OPTION_FILENAME_DOT = "e";
    private static final String OPTION_FILENAME_SCHEMA = "o";
    private static final String OPTION_USE_NAVIGABILITY = "n";
    private static final String OPTION_REMOVE_UNUSED_DOMAINS = "u";
    private static final String OPTION_KEEP_EMPTY_PACKAGES = "k";
    private static final String OPTION_USE_ROLE_NAME = "f";
    private Stack<String> xmiIdStack;
    private SchemaGraph sg;
    private Schema schema;
    private GraphClass graphClass;
    private Stack<Package> packageStack;
    private Map<String, Vertex> idMap;
    private String currentClassId;
    private AttributedElementClass currentClass;
    private RecordDomain currentRecordDomain;
    private HasRecordDomainComponent currentRecordDomainComponent;
    private de.uni_koblenz.jgralab.grumlschema.structure.Attribute currentAttribute;
    private GraphMarker<Set<String>> generalizations;
    private Map<String, Set<String>> realizations;
    private GraphMarker<String> attributeType;
    private GraphMarker<String> recordComponentType;
    private Map<String, Domain> domainMap;
    private Set<Vertex> preliminaryVertices;
    private IncidenceClass currentAssociationEnd;
    private Set<IncidenceClass> ownedEnds;
    private boolean inConstraint;
    private String constrainedElementId;
    private Map<String, List<String>> constraints;
    private Map<String, List<String>> comments;
    private boolean useFromRole;
    private boolean removeUnusedDomains;
    private boolean keepEmptyPackages;
    private boolean useNavigability;
    private boolean suppressOutput;
    private String filenameSchema;
    private String filenameSchemaGraph;
    private String filenameDot;
    private String filenameValidation;
    private String annotatedElementId;
    private boolean inComment;
    private boolean inOwnedAttribute;
    private GreqlQuery edgeClassAcyclicQuery;
    private GreqlQuery vertexClassAcyclicQuery;
    private boolean inDefaultValue;
    private int modelRootElementNestingDepth;
    private Set<Package> ignoredPackages;
    private boolean inSpecification;
    private Set<GraphElementClass> derivedGraphElementClasses;
    private static final Pattern GENNAME_PATTERN = Pattern.compile("(.*)\\$\\p{Digit}+(:(\\w+))?\\$$");

    public static void main(String[] args) throws IOException {
        boolean noOutputOptionSelected;
        System.out.println("RSA to TG");
        System.out.println("=========");
        JGraLab.setLogLevel(Level.OFF);
        CommandLine cli = Rsa2Tg.processCommandLineOptions(args);
        assert (cli != null) : "No CommandLine object has been generated!";
        File input = new File(cli.getOptionValue('i'));
        Rsa2Tg r = new Rsa2Tg();
        r.setUseFromRole(cli.hasOption(OPTION_USE_ROLE_NAME));
        r.setRemoveUnusedDomains(cli.hasOption(OPTION_REMOVE_UNUSED_DOMAINS));
        r.setKeepEmptyPackages(cli.hasOption(OPTION_KEEP_EMPTY_PACKAGES));
        r.setUseNavigability(cli.hasOption(OPTION_USE_NAVIGABILITY));
        r.setFilenameSchema(cli.getOptionValue(OPTION_FILENAME_SCHEMA));
        r.setFilenameSchemaGraph(cli.getOptionValue(OPTION_FILENAME_SCHEMA_GRAPH));
        r.setFilenameDot(cli.getOptionValue(OPTION_FILENAME_DOT));
        r.setFilenameValidation(cli.getOptionValue(OPTION_FILENAME_VALIDATION));
        boolean bl = noOutputOptionSelected = !cli.hasOption(OPTION_FILENAME_SCHEMA) && !cli.hasOption(OPTION_FILENAME_SCHEMA_GRAPH) && !cli.hasOption(OPTION_FILENAME_DOT) && !cli.hasOption(OPTION_FILENAME_VALIDATION);
        if (noOutputOptionSelected) {
            System.out.println("No output option has been selected. A TG-file for the Schema will be written.");
            r.setFilenameSchema(Rsa2Tg.createFilename(input));
        }
        try {
            System.out.println("processing: " + input.getPath() + "\n");
            r.process(input.getPath());
        }
        catch (Exception e) {
            System.err.println("An Exception occured while processing " + input + ".");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + Rsa2Tg.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option validate = new Option(OPTION_FILENAME_VALIDATION, "report", true, "(optional): writes a validation report to the given filename. Free naming, but should look like this: '<filename>.html'");
        validate.setRequired(false);
        validate.setArgName("filename");
        oh.addOption(validate);
        Option export = new Option(OPTION_FILENAME_DOT, "export", true, "(optional): writes a GraphViz DOT file to the given filename. Free naming, but should look like this: '<filename>.dot'");
        export.setRequired(false);
        export.setArgName("filename");
        oh.addOption(export);
        Option schemaGraph = new Option(OPTION_FILENAME_SCHEMA_GRAPH, "schemaGraph", true, "(optional): writes a TG-file of the Schema as graph instance to the given filename. Free naming, but should look like this:  '<filename>.tg'");
        schemaGraph.setRequired(false);
        schemaGraph.setArgName("filename");
        oh.addOption(schemaGraph);
        Option input = new Option("i", "input", true, "(required): UML 2.1-XMI exchange model file of the Schema.");
        input.setRequired(true);
        input.setArgName("filename");
        oh.addOption(input);
        Option output = new Option(OPTION_FILENAME_SCHEMA, "output", true, "(optional): writes a TG-file of the Schema to the given filename. Free naming, but should look like this: '<filename>.rsa.tg.'");
        output.setRequired(false);
        output.setArgName("filename");
        oh.addOption(output);
        Option fromRole = new Option(OPTION_USE_ROLE_NAME, "useFromRole", false, "(optional): if this flag is set, the name of from roles will be used for creating undefined EdgeClass names.");
        fromRole.setRequired(false);
        oh.addOption(fromRole);
        Option unusedDomains = new Option(OPTION_REMOVE_UNUSED_DOMAINS, "removeUnusedDomains", false, "(optional): if this flag is set, all unused domains be deleted.");
        unusedDomains.setRequired(false);
        oh.addOption(unusedDomains);
        Option emptyPackages = new Option(OPTION_KEEP_EMPTY_PACKAGES, "keepEmptyPackages", false, "(optional): if this flag is set, empty packages will be retained.");
        unusedDomains.setRequired(false);
        oh.addOption(emptyPackages);
        Option navigability = new Option(OPTION_USE_NAVIGABILITY, "useNavigability", false, "(optional): if this flag is set, navigability information will be interpreted as reading direction.");
        navigability.setRequired(false);
        oh.addOption(navigability);
        return oh.parse(args);
    }

    public static String createFilename(File file) {
        StringBuilder filenameBuilder = new StringBuilder();
        filenameBuilder.append(file.getParent());
        filenameBuilder.append(File.separatorChar);
        String filename = file.getName();
        int periodePosition = filename.lastIndexOf(46);
        if (periodePosition != -1) {
            filename = filename.substring(0, periodePosition);
        }
        filenameBuilder.append(filename);
        filenameBuilder.append(".rsa.tg");
        return filenameBuilder.toString();
    }

    public Rsa2Tg() {
        this.addIgnoredElements("profileApplication", "packageImport", "Ecore:EReference");
    }

    @Override
    public void startDocument() {
        this.sg = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD);
        this.xmiIdStack = new Stack();
        this.idMap = new HashMap<String, Vertex>();
        this.packageStack = new Stack();
        this.generalizations = new GraphMarker(this.sg);
        this.realizations = new HashMap<String, Set<String>>();
        this.attributeType = new GraphMarker(this.sg);
        this.recordComponentType = new GraphMarker(this.sg);
        this.domainMap = new HashMap<String, Domain>();
        this.preliminaryVertices = new HashSet<Vertex>();
        this.ownedEnds = new HashSet<IncidenceClass>();
        this.constraints = new HashMap<String, List<String>>();
        this.comments = new HashMap<String, List<String>>();
        this.ignoredPackages = new HashSet<Package>();
        this.modelRootElementNestingDepth = 1;
        this.derivedGraphElementClasses = new HashSet<GraphElementClass>();
    }

    @Override
    protected void startElement(String name) throws XMLStreamException {
        if (this.getNestingDepth() == 1 && name.equals("xmi:XMI")) {
            this.modelRootElementNestingDepth = 2;
            return;
        }
        String xmiId = this.getAttribute("xmi", "id");
        this.xmiIdStack.push(xmiId);
        Vertex vertexId = null;
        vertexId = this.getNestingDepth() == this.modelRootElementNestingDepth ? this.createDefaultElements(name) : this.processXMIElements(name, xmiId);
        if (xmiId != null && vertexId != null) {
            this.idMap.put(xmiId, vertexId);
        }
    }

    private Vertex createDefaultElements(String name) throws XMLStreamException {
        if (!name.equals("uml:Model") && !name.equals("uml:Package")) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Root element must be uml:Model or uml:Package, buf was " + name);
        }
        this.setSchemaQualifiedName();
        this.createGraphClass();
        this.createDefaultPackage();
        return this.schema;
    }

    private void setSchemaQualifiedName() throws XMLStreamException {
        String nm = this.getAttribute("name");
        int p = nm.lastIndexOf(46);
        this.schema = this.sg.createSchema();
        if (p == -1) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "A Schema must have a package prefix!\nProcessed qualified name: " + nm);
        }
        this.schema.set_packagePrefix(nm.substring(0, p));
        this.schema.set_name(nm.substring(p + 1));
    }

    private void createGraphClass() {
        this.graphClass = this.sg.createGraphClass();
        this.sg.createDefinesGraphClass(this.schema, this.graphClass);
    }

    private void createDefaultPackage() {
        Package defaultPackage = this.sg.createPackage();
        defaultPackage.set_qualifiedName("");
        this.sg.createContainsDefaultPackage(this.schema, defaultPackage);
        this.packageStack.push(defaultPackage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vertex processXMIElements(String name, String xmiId) throws XMLStreamException {
        String type = this.getAttribute("xmi", "type");
        Vertex vertexId = null;
        if (name.equals("packagedElement")) {
            if (type.equals("uml:Package")) {
                return this.handlePackage();
            }
            if (type.equals("uml:Class")) {
                return this.handleClass(xmiId);
            }
            if (type.equals("uml:Association")) return this.handleAssociation(xmiId);
            if (type.equals("uml:AssociationClass")) {
                return this.handleAssociation(xmiId);
            }
            if (type.equals("uml:Enumeration")) {
                return this.handleEnumeration();
            }
            if (type.equals("uml:PrimitiveType")) {
                return this.handlePrimitiveType(xmiId);
            }
            if (!type.equals("uml:Realization")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
            this.handleRealization();
            return vertexId;
        } else if (name.equals("ownedRule")) {
            this.inConstraint = true;
            this.constrainedElementId = this.getAttribute("constrainedElement");
            if (this.constrainedElementId == null) return vertexId;
            int p = this.constrainedElementId.indexOf(32);
            if (p < 0) return vertexId;
            this.constrainedElementId = null;
            return vertexId;
        } else {
            if (name.equals("body")) {
                if (this.inConstraint) return vertexId;
                if (this.inComment) return vertexId;
                if (this.inDefaultValue) return vertexId;
                if (this.inSpecification) return vertexId;
                throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, null));
            }
            if (name.equals("specification")) {
                this.inSpecification = true;
                return vertexId;
            } else {
                if (name.equals("language")) {
                    if (this.inConstraint) return vertexId;
                    throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, null));
                }
                if (name.equals("ownedEnd")) {
                    if (!type.equals("uml:Property")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                    if (!(this.currentClass instanceof EdgeClass)) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                    this.handleAssociationEnd(xmiId);
                    return vertexId;
                } else if (name.equals("ownedAttribute")) {
                    this.inOwnedAttribute = true;
                    if (!type.equals("uml:Property")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                    this.handleOwnedAttribute(xmiId);
                    return vertexId;
                } else if (name.equals("type")) {
                    if (this.inDefaultValue) return vertexId;
                    if (!type.equals("uml:PrimitiveType")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                    this.handleNestedTypeElement(xmiId);
                    return vertexId;
                } else if (name.equals("ownedLiteral")) {
                    if (!type.equals("uml:EnumerationLiteral")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                    this.handleEnumerationLiteral();
                    return vertexId;
                } else {
                    if (name.equals("xmi:Extension") || name.equals("eAnnotations")) return vertexId;
                    if (name.equals("generalization")) {
                        this.handleGeneralization();
                        return vertexId;
                    } else if (name.equals("details")) {
                        this.handleStereotype();
                        return vertexId;
                    } else if (name.equals("lowerValue")) {
                        this.handleLowerValue();
                        return vertexId;
                    } else if (name.equals("upperValue")) {
                        this.handleUpperValue();
                        return vertexId;
                    } else if (name.equals("ownedComment")) {
                        this.annotatedElementId = this.getAttribute("annotatedElement");
                        this.inComment = true;
                        return vertexId;
                    } else {
                        if (!name.equals("defaultValue")) throw new ProcessingException(this.getParser(), this.getFileName(), this.createUnexpectedElementMessage(name, type));
                        String xmiType = this.getAttribute("xmi", "type");
                        if (this.isPrimitiveDefaultValue(xmiType)) {
                            this.handlePrimitiveDefaultValue(xmiId, xmiType);
                        } else if (!xmiType.equals("uml:OpaqueExpression")) {
                            System.out.println("Warning: Unexpected default value type '" + xmiType + "' for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFileName() + "' at line " + this.getParser().getLocation().getLineNumber());
                        }
                        this.inDefaultValue = true;
                    }
                }
            }
        }
        return vertexId;
    }

    private boolean isPrimitiveDefaultValue(String xmiType) {
        return xmiType.equals("uml:LiteralString") || xmiType.equals("uml:LiteralInteger") || xmiType.equals("uml:LiteralBoolean") || xmiType.equals("uml:InstanceValue");
    }

    private void handlePrimitiveDefaultValue(String xmiId, String xmiType) throws XMLStreamException {
        if (xmiType.equals("uml:InstanceValue")) {
            String value = this.getAttribute("name");
            this.handleDefaultValue(xmiId, value);
            return;
        }
        String value = this.getAttribute("value");
        if (xmiType.equals("uml:LiteralBoolean")) {
            if (value == null) {
                value = OPTION_USE_ROLE_NAME;
            } else {
                assert (value.equals("true") || value.equals("false"));
                value = value.substring(0, 1);
            }
            this.handleDefaultValue(xmiId, value);
            return;
        }
        if (xmiType.equals("uml:LiteralInteger")) {
            if (value == null) {
                value = "0";
            }
            this.handleDefaultValue(xmiId, value);
            return;
        }
        if (value == null) {
            System.out.println("Warning: Undefined default value for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFileName() + "' at line " + this.getParser().getLocation().getLineNumber());
            return;
        }
        if (xmiType.equals("uml:LiteralString")) {
            value = "\"" + value + "\"";
            this.handleDefaultValue(xmiId, value);
        } else {
            System.out.println("Warning: Undefined default value type '" + xmiType + "' for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFileName() + "' at line " + this.getParser().getLocation().getLineNumber());
        }
    }

    private void handleDefaultValue(String xmiId, String value) {
        if (this.currentAttribute == null) {
            throw new ProcessingException(this.getFileName(), "Found a <defaultValue> tag (XMI id " + xmiId + ") outside an attribute definition (e.g. in a <<record>> class)");
        }
        this.currentAttribute.set_defaultValue(value);
    }

    @Override
    protected void endElement(String name, StringBuilder content) throws XMLStreamException {
        AttributedElement elem;
        if (this.getNestingDepth() < this.modelRootElementNestingDepth) {
            return;
        }
        String xmiId = this.xmiIdStack.pop();
        if (name.equals("body")) {
            if (this.inConstraint) {
                assert (!this.inComment && !this.inDefaultValue);
                this.handleConstraint(content.toString().trim().replace("\\s+", " "));
            } else if (this.inComment) {
                assert (!this.inDefaultValue);
                this.handleComment(content.toString());
            } else if (this.inDefaultValue) {
                this.handleDefaultValue(xmiId, content.toString().trim());
            }
        }
        if ((elem = (AttributedElement)this.idMap.get(xmiId)) != null) {
            if (elem instanceof Package) {
                if (this.packageStack.size() <= 1) {
                    throw new ProcessingException(this.getParser(), this.getFileName(), "XMI file is malformed. There is probably one end element to much.");
                }
                this.packageStack.pop();
            } else if (elem instanceof AttributedElementClass) {
                this.currentClassId = null;
                this.currentClass = null;
                this.currentAttribute = null;
            } else if (elem instanceof RecordDomain) {
                this.currentRecordDomain = null;
                this.currentAttribute = null;
            } else if (elem instanceof de.uni_koblenz.jgralab.grumlschema.structure.Attribute) {
                this.currentAttribute = null;
            }
        }
        if (name.equals("uml:Package")) {
            this.packageStack.pop();
            if (this.packageStack.size() != 0) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "XMI file is malformed. There is probably one end element to much.");
            }
        } else if (name.equals("ownedAttribute")) {
            this.currentRecordDomainComponent = null;
            if (this.currentAssociationEnd != null) {
                this.checkMultiplicities(this.currentAssociationEnd);
                this.currentAssociationEnd = null;
            }
            this.inOwnedAttribute = false;
        } else if (name.equals("ownedEnd")) {
            this.checkMultiplicities(this.currentAssociationEnd);
            this.currentAssociationEnd = null;
        } else if (name.equals("ownedRule")) {
            this.inConstraint = false;
            this.constrainedElementId = null;
        } else if (name.equals("ownedComment")) {
            this.inComment = false;
            this.annotatedElementId = null;
        } else if (name.equals("defaultValue")) {
            this.inDefaultValue = false;
        } else if (name.equals("specification")) {
            this.inSpecification = false;
        }
    }

    private void checkMultiplicities(IncidenceClass inc) {
        int min = inc.get_min();
        int max = inc.get_max();
        assert (min >= 0);
        assert (max > 0);
        if (min == Integer.MAX_VALUE) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound must not be * at association end " + inc);
        }
        if (min > max) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound (" + min + ") must be <= upper bound (" + max + ") at association end " + inc);
        }
    }

    private void handleComment(String body) {
        body = body.replaceAll("\\s+", " ");
        body = body.replace("<p>", " ");
        body = body.replace("</p>", "\n");
        String[] lines = body.split("\n");
        StringBuilder text = new StringBuilder();
        for (String line : lines) {
            if ((line = line.replaceAll("\\s+", " ").trim()).length() <= 0) continue;
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(line);
        }
        if (text.length() == 0) {
            return;
        }
        List<String> commentList = this.comments.get(this.annotatedElementId);
        if (commentList == null) {
            commentList = new LinkedList<String>();
            this.comments.put(this.annotatedElementId, commentList);
        }
        commentList.add(text.toString());
    }

    @Override
    public void endDocument() throws XMLStreamException {
        assert (this.schema != null);
        assert (this.graphClass != null);
        if (this.graphClass.get_qualifiedName() == null) {
            throw new ProcessingException(this.getFileName(), "No <<graphclass>> defined in schema '" + this.schema.get_packagePrefix() + "." + this.schema.get_name() + "'");
        }
        this.checkEnumDomains();
        this.linkGeneralizations();
        this.linkRecordDomainComponents();
        this.linkAttributeDomains();
        this.removeIgnoredPackages();
        if (this.isUseNavigability()) {
            this.correctEdgeDirection();
        }
        this.attachConstraints();
        this.checkSubsettingOfAllIncidenceClasses();
        for (GraphElementClass gec : this.derivedGraphElementClasses) {
            assert (gec.isValid());
            Edge current = gec.getFirstIncidence();
            while (current != null) {
                Vertex comment;
                Edge next = current.getNextIncidence();
                if (current.isInstanceOf(Annotates.EC) && (comment = next.getThat()).getDegree() == 1) {
                    comment.delete();
                }
                current = next;
            }
            gec.delete();
        }
        this.createEdgeClassNames();
        this.checkAttributes();
        if (this.isRemoveUnusedDomains()) {
            this.removeUnusedDomains();
        }
        this.attachComments();
        if (!this.isKeepEmptyPackages()) {
            this.removeEmptyPackages();
        }
        if (!this.preliminaryVertices.isEmpty()) {
            System.err.println("Remaining preliminary vertices (" + this.preliminaryVertices.size() + "):");
            for (Vertex v : this.preliminaryVertices) {
                System.err.println(this.attributedElement2String(v));
            }
            throw new ProcessingException(this.getFileName(), "There are still vertices left over. ");
        }
        if (!this.suppressOutput) {
            try {
                this.writeOutput();
            }
            catch (GraphIOException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    private void checkAttributes() {
        GraphClass graphClass = this.sg.getFirstGraphClass();
        HashMap<String, AttributedElementClass> definedAttributes = new HashMap<String, AttributedElementClass>();
        for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute a : graphClass.get_attributes()) {
            if (definedAttributes.containsKey(a)) {
                throw new RuntimeException("Attribute " + a.get_name() + " at " + graphClass.get_qualifiedName() + " is duplicate.");
            }
            definedAttributes.put(a.get_name(), graphClass);
        }
        for (GraphElementClass gec : this.sg.getGraphElementClassVertices()) {
            boolean isVertexClass = gec.isInstanceOf(VertexClass.VC);
            definedAttributes = new HashMap();
            BooleanGraphMarker alreadyChecked = new BooleanGraphMarker(this.sg);
            LinkedList<GraphElementClass> queue = new LinkedList<GraphElementClass>();
            queue.add(gec);
            while (!queue.isEmpty()) {
                GraphElementClass current = (GraphElementClass)queue.poll();
                if (alreadyChecked.isMarked(current)) continue;
                for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute att : current.get_attributes()) {
                    if (definedAttributes.containsKey(att.get_name())) {
                        AttributedElementClass childClass = (AttributedElementClass)definedAttributes.get(att.get_name());
                        throw new RuntimeException("The name of the " + (childClass == gec && current != gec ? "" : "inherited ") + "attribute " + att.get_name() + " of " + (isVertexClass ? "VertexClass" : "EdgeClass") + " " + childClass.get_qualifiedName() + (current == gec ? " is duplicate" : " is the same name as the inherited attribute of " + (isVertexClass ? "VertexClass" : "EdgeClass") + " " + current.get_qualifiedName()) + ".");
                    }
                    definedAttributes.put(att.get_name(), current);
                }
                alreadyChecked.mark(current);
                for (Edge toSuperClass : current.incidences(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT)) {
                    GraphElementClass superClass = (GraphElementClass)toSuperClass.getThat();
                    if (alreadyChecked.isMarked(superClass)) continue;
                    queue.add(superClass);
                }
            }
        }
    }

    private void removeIgnoredPackages() {
        System.out.println("Removing ignored packages...");
        int n = 0;
        for (Package pkg : this.ignoredPackages) {
            n += this.removePackage(pkg);
        }
        System.out.println("\tRemoved " + n + " package" + (n == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
    }

    private int removePackage(Package pkg) {
        if (!pkg.isValid()) {
            return 0;
        }
        int n = 0;
        ArrayList<Package> subPackages = new ArrayList<Package>();
        for (Package sub : pkg.get_subpackages()) {
            subPackages.add(sub);
        }
        for (Package sub : subPackages) {
            n += this.removePackage(sub);
        }
        ContainsGraphElementClass c = pkg.getFirstContainsGraphElementClassIncidence(EdgeDirection.OUT);
        while (c != null) {
            GraphElementClass gec = (GraphElementClass)c.getThat();
            if (gec instanceof EdgeClass) {
                EdgeClass ec = (EdgeClass)gec;
                ec.get_to().delete();
                ec.get_from().delete();
            } else if (gec instanceof VertexClass) {
                VertexClass vc = (VertexClass)gec;
                EndsAt e = vc.getFirstEndsAtIncidence(EdgeDirection.IN);
                while (e != null) {
                    EdgeClass ec;
                    ComesFrom cf = ((IncidenceClass)e.getThat()).getFirstComesFromIncidence();
                    if (cf == null) {
                        GoesTo gt = ((IncidenceClass)e.getThat()).getFirstGoesToIncidence();
                        ec = (EdgeClass)gt.getThat();
                    } else {
                        ec = (EdgeClass)cf.getThat();
                    }
                    ec.get_to().delete();
                    ec.get_from().delete();
                    this.removeAttributes(ec);
                    ec.delete();
                    e = vc.getFirstEndsAtIncidence(EdgeDirection.IN);
                }
            }
            this.removeAttributes(gec);
            gec.delete();
            c = pkg.getFirstContainsGraphElementClassIncidence(EdgeDirection.OUT);
        }
        if (pkg.getDegree() == 1) {
            ++n;
            System.out.println("\t- removing " + pkg.get_qualifiedName());
            pkg.delete();
        }
        return n;
    }

    private void removeAttributes(AttributedElementClass aec) {
        HasAttribute ha = aec.getFirstHasAttributeIncidence(EdgeDirection.OUT);
        while (ha != null) {
            ha.getThat().delete();
            ha = aec.getFirstHasAttributeIncidence(EdgeDirection.OUT);
        }
    }

    private void checkEnumDomains() {
        System.out.println("Checking enumeration domains...");
        ArrayList<String> faultyDomains = new ArrayList<String>();
        for (EnumDomain ed : this.sg.getEnumDomainVertices()) {
            if (ed.get_enumConstants().size() >= 1) continue;
            faultyDomains.add(ed.get_qualifiedName());
        }
        if (faultyDomains.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("The following enumeration domain").append(faultyDomains.size() == 1 ? " has" : "s have").append(" no literals");
            String delim = ": ";
            for (String name : faultyDomains) {
                sb.append(delim).append(name);
                delim = ", ";
            }
            throw new ProcessingException(this.getFileName(), sb.toString());
        }
    }

    private void attachComments() {
        System.out.println("Attaching comments to annotated elements...");
        for (String id : this.comments.keySet()) {
            NamedElement annotatedElement = null;
            if (this.domainMap.containsKey(id)) {
                annotatedElement = this.domainMap.get(id);
            } else if (this.idMap.containsKey(id)) {
                Vertex v = this.idMap.get(id);
                annotatedElement = (NamedElement)v;
            }
            if (annotatedElement == null) {
                System.out.println("\t- Couldn't find annotated element for XMI id " + id + "\n\t  => attaching to GraphClass (Comment starts with '" + this.comments.get(id).get(0) + "'");
                annotatedElement = this.graphClass;
            }
            assert (annotatedElement != null);
            if (!annotatedElement.isValid()) continue;
            List<String> lines = this.comments.get(id);
            for (String line : lines) {
                Comment c = this.sg.createComment();
                c.set_text(line);
                this.sg.createAnnotates(c, annotatedElement);
            }
        }
    }

    private void checkSubsettingOfAllIncidenceClasses() {
        System.out.println("Checking subsets relationships...");
        for (SpecializesEdgeClass spec = this.sg.getFirstSpecializesEdgeClass(); spec != null; spec = spec.getNextSpecializesEdgeClassInGraph()) {
            EdgeClass subClass = spec.getAlpha();
            EdgeClass superClass = spec.getOmega();
            assert (subClass.getFirstComesFromIncidence() != null);
            assert (superClass.getFirstComesFromIncidence() != null);
            this.checkSubsettingOfIncidences(subClass, superClass, (IncidenceClass)subClass.getFirstComesFromIncidence().getThat(), (IncidenceClass)superClass.getFirstComesFromIncidence().getThat());
            assert (subClass.getFirstGoesToIncidence() != null);
            assert (superClass.getFirstGoesToIncidence() != null);
            this.checkSubsettingOfIncidences(subClass, superClass, (IncidenceClass)subClass.getFirstGoesToIncidence().getThat(), (IncidenceClass)superClass.getFirstGoesToIncidence().getThat());
        }
    }

    private void checkSubsettingOfIncidences(EdgeClass subClass, EdgeClass superClass, IncidenceClass subInc, IncidenceClass superInc) {
        assert (this.getDirection(subInc) != null);
        assert (this.getDirection(superInc) != null);
        if (this.getDirection(subInc) != this.getDirection(superInc)) {
            throw new ProcessingException(this.getFileName(), "Incompatible incidence direction in specialisation " + subClass + " --> " + superClass);
        }
        if (subInc.get_max() > superInc.get_max()) {
            throw new ProcessingException(this.getFileName(), "Subclass has higher upper bound (" + subInc.get_max() + ") than superclass (" + superInc.get_max() + ") in specialisation " + subClass.get_qualifiedName() + " --> " + superClass.get_qualifiedName());
        }
        AggregationKind subAgg = subInc.get_aggregation();
        AggregationKind superAgg = superInc.get_aggregation();
        if (subAgg == AggregationKind.SHARED && superAgg == AggregationKind.COMPOSITE || subAgg == AggregationKind.NONE && superAgg != AggregationKind.NONE) {
            throw new ProcessingException(this.getFileName(), "Incompatible aggregation kinds (" + (Object)((Object)subAgg) + " specialises " + (Object)((Object)superAgg) + ") in generalisation " + subClass.get_qualifiedName() + " --> " + superClass.get_qualifiedName());
        }
    }

    private EdgeDirection getDirection(IncidenceClass inc) {
        assert (inc.getFirstComesFromIncidence() == null || inc.getFirstGoesToIncidence() == null);
        if (inc.getFirstComesFromIncidence() != null) {
            return EdgeDirection.OUT;
        }
        if (inc.getFirstGoesToIncidence() != null) {
            return EdgeDirection.IN;
        }
        return null;
    }

    public void writeOutput() throws XMLStreamException, GraphIOException {
        boolean fileCreated = false;
        if (this.filenameDot != null) {
            try {
                this.printTypeAndFilename("GraphvViz DOT file", this.filenameDot);
                this.writeDotFile(this.filenameDot);
                fileCreated = true;
            }
            catch (IOException e) {
                System.out.println("Could not create DOT file.");
                System.out.println("Exception was " + e);
            }
        }
        if (this.filenameSchemaGraph != null) {
            this.printTypeAndFilename("schemagraph", this.filenameSchemaGraph);
            this.writeSchemaGraph(this.filenameSchemaGraph);
            fileCreated = true;
        }
        System.out.println("Validating schema graph...");
        this.validateGraph(this.filenameValidation);
        if (this.filenameValidation != null) {
            fileCreated = true;
        }
        if (this.filenameSchema != null) {
            this.printTypeAndFilename("schema", this.filenameSchema);
            this.writeSchema(this.filenameSchema);
            fileCreated = true;
        }
        if (!fileCreated) {
            System.out.println("No files have been created.");
        }
    }

    private void printTypeAndFilename(String type, String filename) {
        System.out.println("Writing " + type + " to: " + filename);
    }

    private void validateGraph(String filePath) {
        if (filePath != null) {
            this.printTypeAndFilename("validation report", filePath);
        }
        try {
            GraphValidator validator = new GraphValidator(this.sg);
            SortedSet<ConstraintViolation> s = filePath != null ? validator.createValidationReport(filePath) : validator.validate();
            if (!s.isEmpty()) {
                System.err.println("The schema graph is not valid:");
                for (ConstraintViolation currentViolation : s) {
                    System.err.println(currentViolation);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String createUnexpectedElementMessage(String name, String type) {
        String typeInsertion = type != null ? " of type " + type : "";
        return "Unexpected element <" + name + ">" + typeInsertion + ".";
    }

    private Vertex handlePackage() throws XMLStreamException {
        Package pkg = this.sg.createPackage();
        pkg.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsSubPackage(this.packageStack.peek(), pkg);
        this.packageStack.push(pkg);
        return pkg;
    }

    private Vertex handleClass(String xmiId) throws XMLStreamException {
        boolean derived;
        AttributedElement ae = this.idMap.get(xmiId);
        VertexClass vc = null;
        if (ae != null) {
            if (!(ae instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "The element with ID '" + xmiId + "' is not a class. (VertexClass)");
            }
            assert (this.preliminaryVertices.contains(ae));
            this.preliminaryVertices.remove(ae);
            vc = (VertexClass)ae;
        } else {
            vc = this.sg.createVertexClass();
        }
        this.currentClassId = xmiId;
        this.currentClass = vc;
        String abs = this.getAttribute("isAbstract");
        vc.set_abstract(abs != null && abs.equals("true"));
        vc.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsGraphElementClass(this.packageStack.peek(), vc);
        String isDerived = this.getAttribute("isDerived");
        boolean bl = derived = isDerived != null && isDerived.equals("true");
        if (derived) {
            this.derivedGraphElementClasses.add(vc);
        }
        return vc;
    }

    private Vertex handleAssociation(String xmiId) throws XMLStreamException {
        boolean derived;
        VertexClass vc;
        AttributedElement ae = this.idMap.get(xmiId);
        EdgeClass ec = null;
        if (ae != null) {
            if (!(ae instanceof EdgeClass)) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "The XMI id " + xmiId + " must denonte an EdgeClass, but is " + ae.getAttributedElementClass().getQualifiedName());
            }
            assert (this.preliminaryVertices.contains(ae));
            this.preliminaryVertices.remove(ae);
            ec = (EdgeClass)ae;
        } else {
            ec = this.sg.createEdgeClass();
        }
        this.currentClassId = xmiId;
        this.currentClass = ec;
        String abs = this.getAttribute("isAbstract");
        ec.set_abstract(abs != null && abs.equals("true"));
        String n = this.getAttribute("name");
        String string = n = n == null ? "" : n.trim();
        if (n.length() > 0) {
            n = Character.toUpperCase(n.charAt(0)) + n.substring(1);
        }
        ec.set_qualifiedName(this.getQualifiedName(n));
        this.sg.createContainsGraphElementClass(this.packageStack.peek(), ec);
        String memberEnd = this.getAttribute("memberEnd");
        if (memberEnd == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "The association with ID '" + xmiId + "' has no end member. (EdgeClass)");
        }
        memberEnd = memberEnd.trim().replaceAll("\\s+", " ");
        int p = memberEnd.indexOf(32);
        String targetEnd = memberEnd.substring(0, p);
        String sourceEnd = memberEnd.substring(p + 1);
        IncidenceClass inc = (IncidenceClass)this.idMap.get(sourceEnd);
        if (inc == null) {
            vc = this.sg.createVertexClass();
            this.preliminaryVertices.add(vc);
            vc.set_qualifiedName("preliminary for source end " + sourceEnd);
            inc = this.sg.createIncidenceClass();
            inc.set_aggregation(AggregationKind.NONE);
            inc.set_min(1);
            inc.set_max(1);
            this.sg.createComesFrom(ec, inc);
            this.sg.createEndsAt(inc, vc);
            this.idMap.put(sourceEnd, inc);
        }
        if ((inc = (IncidenceClass)this.idMap.get(targetEnd)) != null) {
            assert (inc.isValid());
            assert (this.getDirection(inc) == EdgeDirection.OUT);
            IncidenceClass to = this.sg.createIncidenceClass();
            IncidenceClass from = inc;
            this.sg.createGoesTo(ec, to);
            this.sg.createEndsAt(to, (VertexClass)from.getFirstEndsAtIncidence().getThat());
            to.set_aggregation(from.get_aggregation());
            to.set_max(from.get_max());
            to.set_min(from.get_min());
            to.set_roleName(from.get_roleName());
            if (this.ownedEnds.contains(from)) {
                this.ownedEnds.remove(from);
                this.ownedEnds.add(to);
            }
            inc.delete();
            this.idMap.put(targetEnd, to);
        } else {
            vc = this.sg.createVertexClass();
            this.preliminaryVertices.add(vc);
            vc.set_qualifiedName("preliminary for target end " + targetEnd);
            inc = this.sg.createIncidenceClass();
            inc.set_aggregation(AggregationKind.NONE);
            inc.set_min(1);
            inc.set_max(1);
            this.sg.createGoesTo(ec, inc);
            this.sg.createEndsAt(inc, vc);
            this.idMap.put(targetEnd, inc);
        }
        String isDerived = this.getAttribute("isDerived");
        boolean bl = derived = isDerived != null && isDerived.equals("true");
        if (derived) {
            this.derivedGraphElementClasses.add(ec);
        }
        return ec;
    }

    private Vertex handleEnumeration() throws XMLStreamException {
        EnumDomain ed = this.sg.createEnumDomain();
        Package p = this.packageStack.peek();
        ed.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsDomain(p, ed);
        PVector<String> empty = JGraLab.vector();
        ed.set_enumConstants(empty);
        Domain dom = this.domainMap.get(ed.get_qualifiedName());
        if (dom != null) {
            assert (this.preliminaryVertices.contains(dom));
            this.reconnectEdges(dom, ed);
            dom.delete();
            this.preliminaryVertices.remove(dom);
        }
        this.domainMap.put(ed.get_qualifiedName(), ed);
        return ed;
    }

    private Vertex handlePrimitiveType(String xmiId) throws XMLStreamException {
        String typeName = this.getAttribute("name");
        if (typeName == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "No type name in primitive type. XMI ID: " + xmiId);
        }
        if ((typeName = typeName.replaceAll("\\s", "")).length() == 0) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Type name in primitive type is empty. XMI ID: " + xmiId);
        }
        Domain dom = this.createDomain(typeName);
        assert (dom != null);
        return dom;
    }

    private void handleRealization() throws XMLStreamException {
        String supplier = this.getAttribute("supplier");
        String client = this.getAttribute("client");
        Set<String> reals = this.realizations.get(client);
        if (reals == null) {
            reals = new TreeSet<String>();
            this.realizations.put(client, reals);
        }
        reals.add(supplier);
    }

    private String attributedElement2String(AttributedElement<?, ?> attributedElement) {
        StringBuilder sb = new StringBuilder();
        Object aec = attributedElement.getAttributedElementClass();
        sb.append(attributedElement);
        sb.append(" { ");
        for (Attribute attr : aec.getAttributeList()) {
            sb.append(attr.getName());
            sb.append(" = ");
            sb.append(attributedElement.getAttribute(attr.getName()));
            sb.append("; ");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private void handleEnumerationLiteral() throws XMLStreamException {
        String s = this.getAttribute("name");
        if (s == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "No Literal declared.");
        }
        if ((s = s.trim()).length() <= 0) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Literal is empty.");
        }
        String classifier = this.getAttribute("classifier");
        if (classifier == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "No Enumeration found for Literal '" + s + "'.");
        }
        EnumDomain ed = (EnumDomain)this.idMap.get(classifier);
        if (!s.equals(s.toUpperCase())) {
            System.out.println("Warning: Enumeration literal '" + s + "' in enumeration + '" + ed.get_qualifiedName() + "' should be all uppercase letters.");
        }
        ed.set_enumConstants(ed.get_enumConstants().plus(s));
    }

    private void writeSchema(String schemaName) {
        try {
            SchemaGraph2Tg sg2tg = new SchemaGraph2Tg(this.sg, schemaName);
            sg2tg.process();
        }
        catch (IOException e) {
            throw new RuntimeException("SchemaGraph2Tg failed with an IOException!", e);
        }
    }

    private void correctEdgeDirection() {
        if (!this.isUseNavigability()) {
            return;
        }
        System.out.println("Correcting edge directions according to navigability...");
        for (EdgeClass e : this.sg.getEdgeClassVertices()) {
            boolean toIsNavigable;
            ComesFrom cf = e.getFirstComesFromIncidence();
            if (cf == null) {
                throw new ProcessingException(this.getFileName(), "EdgeClass " + e.get_qualifiedName() + " has no ComesFrom incidence");
            }
            GoesTo gt = e.getFirstGoesToIncidence();
            if (gt == null) {
                throw new ProcessingException(this.getFileName(), "EdgeClass " + e.get_qualifiedName() + " has no GoesTo incidence");
            }
            IncidenceClass from = (IncidenceClass)cf.getThat();
            IncidenceClass to = (IncidenceClass)gt.getThat();
            boolean fromIsNavigable = !this.ownedEnds.contains(from);
            if (fromIsNavigable == (toIsNavigable = !this.ownedEnds.contains(to)) || toIsNavigable) continue;
            assert (this.getDirection(to) == EdgeDirection.IN);
            assert (this.getDirection(from) == EdgeDirection.OUT);
            IncidenceClass inc = (IncidenceClass)cf.getThat();
            cf.setThat(gt.getThat());
            gt.setThat(inc);
        }
    }

    private void attachConstraints() throws XMLStreamException {
        System.out.println("Attaching constraints...");
        for (String constrainedElementId : this.constraints.keySet()) {
            List<String> l = this.constraints.get(constrainedElementId);
            if (l.size() == 0) continue;
            Vertex ae = this.idMap.get(constrainedElementId);
            if (ae == null) {
                ae = this.graphClass;
            }
            if (!ae.isValid()) continue;
            if (!(ae instanceof AttributedElementClass) && !(ae instanceof IncidenceClass)) {
                throw new ProcessingException(this.getFileName(), "Constraint can only be attached to GraphClass, VertexClass, EdgeClass or association ends. Offending element is " + ae + " (XMI id " + constrainedElementId + ")");
            }
            if (ae instanceof AttributedElementClass) {
                if (!((AttributedElementClass)ae).isValid()) continue;
                for (String text : l) {
                    this.addGreqlConstraint((AttributedElementClass)ae, text);
                }
                continue;
            }
            throw new ProcessingException(this.getFileName(), "Don't know what to do with constraint(s) at element " + ae + " (XMI id " + constrainedElementId + ")");
        }
    }

    private void createEdgeClassNames() {
        System.out.println("Creating missing edge class names...");
        for (EdgeClass ec : this.sg.getEdgeClassVertices()) {
            String name = ec.get_qualifiedName().trim();
            String ecName = null;
            Matcher m = GENNAME_PATTERN.matcher(name);
            if (m.matches()) {
                name = m.group(1);
                ecName = m.group(m.groupCount());
            }
            if (!name.equals("") && !name.endsWith(".")) continue;
            IncidenceClass to = (IncidenceClass)ec.getFirstGoesToIncidence().getThat();
            IncidenceClass from = (IncidenceClass)ec.getFirstComesFromIncidence().getThat();
            String toRole = to.get_roleName();
            if (toRole == null || toRole.equals("")) {
                toRole = ((VertexClass)to.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                int p = toRole.lastIndexOf(46);
                if (p >= 0) {
                    toRole = toRole.substring(p + 1);
                }
            } else {
                toRole = Character.toUpperCase(toRole.charAt(0)) + toRole.substring(1);
            }
            if (toRole == null || toRole.length() <= 0) {
                throw new ProcessingException(this.getFileName(), "There is no role name 'to' for the edge '" + name + "' defined.");
            }
            ecName = ecName == null ? (from.get_aggregation() != AggregationKind.NONE || to.get_aggregation() != AggregationKind.NONE ? (to.get_aggregation() != AggregationKind.NONE ? "Contains" + toRole : "IsPartOf" + toRole) : "LinksTo" + toRole) : ecName + toRole;
            if (this.isUseFromRole()) {
                String fromRole = from.get_roleName();
                if (fromRole == null || fromRole.equals("")) {
                    fromRole = ((VertexClass)from.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                    int p = fromRole.lastIndexOf(46);
                    if (p >= 0) {
                        fromRole = fromRole.substring(p + 1);
                    }
                } else {
                    fromRole = Character.toUpperCase(fromRole.charAt(0)) + fromRole.substring(1);
                }
                if (fromRole == null || fromRole.length() <= 0) {
                    throw new ProcessingException(this.getFileName(), "There is no role name of 'from' for the edge '" + name + "' defined.");
                }
                name = name + fromRole;
            }
            assert (ecName != null && ecName.length() > 0);
            ec.set_qualifiedName(name + ecName);
        }
    }

    private void removeUnusedDomains() {
        System.out.println("Removing unused domains...");
        Domain d = this.sg.getFirstDomain();
        while (d != null) {
            Domain n = d.getNextDomain();
            if (d.getDegree(EdgeDirection.IN) - d.getDegree(Annotates.EC, EdgeDirection.IN) <= 1) {
                List<? extends Comment> comments = d.remove_comments();
                for (Comment comment : comments) {
                    comment.delete();
                }
                d.delete();
                d = this.sg.getFirstDomain();
                continue;
            }
            d = n;
        }
    }

    private void linkRecordDomainComponents() {
        for (HasRecordDomainComponent comp : this.sg.getHasRecordDomainComponentEdges()) {
            String domainId = (String)this.recordComponentType.getMark(comp);
            if (domainId == null) {
                this.recordComponentType.removeMark(comp);
                continue;
            }
            Domain dom = (Domain)this.idMap.get(domainId);
            if (dom != null) {
                Domain d = comp.getOmega();
                assert (d instanceof StringDomain && d.get_qualifiedName().equals(domainId) && this.preliminaryVertices.contains(d));
                comp.setOmega(dom);
                d.delete();
                this.preliminaryVertices.remove(d);
                this.recordComponentType.removeMark(comp);
                continue;
            }
            throw new ProcessingException(this.getFileName(), "Undefined Domain with ID '" + domainId + "' found.");
        }
        if (!this.recordComponentType.isEmpty()) {
            throw new ProcessingException(this.getFileName(), "Some RecordDomains have unresolved component types.");
        }
    }

    private void linkAttributeDomains() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute att : this.sg.getAttributeVertices()) {
            String domainId = (String)this.attributeType.getMark(att);
            if (domainId == null) {
                assert (att.getDegree(HasDomain.EC, EdgeDirection.OUT) == 1) : "Attribute '" + att.get_name() + "' of " + att.getFirstHasAttributeIncidence().getThat().getSchemaClass().getSimpleName() + " '" + ((AttributedElementClass)att.getFirstHasAttributeIncidence().getThat()).get_qualifiedName() + "' has " + att.getDegree(HasDomain.EC, EdgeDirection.OUT) + " domain(s)";
                continue;
            }
            Domain dom = (Domain)this.idMap.get(domainId);
            if (dom == null) {
                throw new ProcessingException(this.getFileName(), "Undefined Domain with ID '" + domainId + "' found.");
            }
            this.sg.createHasDomain(att, dom);
            this.attributeType.removeMark(att);
            assert (att.getDegree(HasDomain.EC, EdgeDirection.OUT) == 1);
        }
        if (!this.attributeType.isEmpty()) {
            throw new ProcessingException(this.getFileName(), "There are some Attribute objects, whos domains are not resolved.");
        }
    }

    private void writeDotFile(String dotName) throws IOException {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(this.sg);
        tg2Dot.setPrintEdgeAttributes(true);
        tg2Dot.setOutputFile(dotName);
        tg2Dot.convert();
    }

    private void writeSchemaGraph(String schemaGraphName) throws GraphIOException {
        this.sg.save(schemaGraphName);
    }

    private void linkGeneralizations() {
        for (String clientId : this.realizations.keySet()) {
            Set<String> suppliers = this.realizations.get(clientId);
            AttributedElementClass client = (AttributedElementClass)this.idMap.get(clientId);
            if (suppliers.size() <= 0) continue;
            TreeSet<String> superClasses = (TreeSet<String>)this.generalizations.getMark(client);
            if (superClasses == null) {
                superClasses = new TreeSet<String>();
                this.generalizations.mark(client, superClasses);
            }
            superClasses.addAll(suppliers);
        }
        for (AttributedElement ae : this.generalizations.getMarkedElements()) {
            AttributedElementClass sub = (AttributedElementClass)ae;
            Set superclasses = (Set)this.generalizations.getMark(sub);
            for (String id : superclasses) {
                AttributedElementClass sup = (AttributedElementClass)this.idMap.get(id);
                if (sup == null) {
                    throw new ProcessingException(this.getFileName(), "The superclass with XMI id '" + id + "' could not be found.");
                }
                if (sup instanceof VertexClass) {
                    if (!(sub instanceof VertexClass)) {
                        throw new ProcessingException(this.getFileName(), "Different types in generalization: " + sub.getSchemaClass().getSimpleName() + " '" + sub.get_qualifiedName() + "' can not be subclass of " + sub.getSchemaClass().getSimpleName() + " '" + sup.get_qualifiedName() + "'");
                    }
                    this.sg.createSpecializesVertexClass((VertexClass)ae, (VertexClass)sup);
                    if (this.vertexClassHierarchyIsAcyclic()) continue;
                    throw new ProcessingException(this.getFileName(), "Cycle in vertex class hierarchy. Involved classes are '" + sub.get_qualifiedName() + "' and '" + sup.get_qualifiedName() + "'");
                }
                if (sup instanceof EdgeClass) {
                    if (!(sub instanceof EdgeClass)) {
                        throw new ProcessingException(this.getFileName(), "Different types in generalization: " + sub.getSchemaClass().getSimpleName() + " '" + sub.get_qualifiedName() + "' can not be subclass of " + sub.getSchemaClass().getSimpleName() + " '" + sup.get_qualifiedName() + "'");
                    }
                    this.sg.createSpecializesEdgeClass((EdgeClass)ae, (EdgeClass)sup);
                    if (this.edgeClassHierarchyIsAcyclic()) continue;
                    throw new ProcessingException(this.getFileName(), "Cycle in edge class hierarchy. Involved classes are '" + sub.get_qualifiedName() + "' and '" + sup.get_qualifiedName() + "'");
                }
                throw new RuntimeException("FIXME: Unexpected super class type. Super class must be VertexClass or EdgeClass!");
            }
        }
        this.generalizations.clear();
    }

    private boolean edgeClassHierarchyIsAcyclic() {
        if (this.edgeClassAcyclicQuery == null) {
            this.edgeClassAcyclicQuery = GreqlQuery.createQuery("on edgeTypeSubgraph{structure.SpecializesEdgeClass}(): isAcyclic()");
        }
        return (Boolean)this.edgeClassAcyclicQuery.evaluate(this.sg);
    }

    private boolean vertexClassHierarchyIsAcyclic() {
        if (this.vertexClassAcyclicQuery == null) {
            this.vertexClassAcyclicQuery = GreqlQuery.createQuery("on edgeTypeSubgraph{structure.SpecializesVertexClass}(): isAcyclic()");
        }
        return (Boolean)this.vertexClassAcyclicQuery.evaluate(this.sg);
    }

    private void removeEmptyPackages() {
        System.out.println("Removing empty packages...");
        Package p = this.sg.getFirstPackage();
        int removed = 0;
        while (p != null) {
            Package n = p.getNextPackage();
            int commentCount = p.getDegree(Annotates.EC);
            if (p.getDegree() - commentCount == 1 && p.get_qualifiedName().length() > 0) {
                System.out.println("\t- empty package '" + p.get_qualifiedName() + "' removed" + (commentCount > 0 ? (commentCount == 1 ? " including 1 comment" : " including " + commentCount + " comments") : ""));
                if (commentCount > 0) {
                    Annotates a = p.getFirstAnnotatesIncidence();
                    while (a != null) {
                        a.getThat().delete();
                        a = p.getFirstAnnotatesIncidence();
                    }
                }
                p.delete();
                ++removed;
                p = this.sg.getFirstPackage();
                continue;
            }
            p = n;
        }
        System.out.println("\tRemoved " + removed + " package" + (removed == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
    }

    private void handleConstraint(String text) throws XMLStreamException {
        if (text.startsWith("\"")) {
            List<String> l = this.constraints.get(this.constrainedElementId);
            if (l == null) {
                l = new LinkedList<String>();
                this.constraints.put(this.constrainedElementId, l);
            }
            l.add(text);
        } else if (text.startsWith("subsets")) {
            System.err.println("warning: {subsets ...} constraint at element " + this.constrainedElementId + " ignored (don't forget to model generalizations between associations)");
        } else if (text.startsWith("union")) {
            System.err.println("warning: {union} constraint at element " + this.constrainedElementId + " ignored (don't forget to add an <<abstract>> stereotype to the association)");
        } else if (text.startsWith("ordered")) {
            System.err.println("warning: {ordered} constraint at element " + this.constrainedElementId + " ignored (TGraphs are ordered by default)");
        } else {
            throw new ProcessingException(this.getFileName(), this.getParser().getLocation().getLineNumber(), "Illegal constraint format: " + text);
        }
    }

    private void addGreqlConstraint(AttributedElementClass constrainedClass, String text) throws XMLStreamException {
        assert (constrainedClass != null);
        Constraint constraint = this.sg.createConstraint();
        this.sg.createHasConstraint(constrainedClass, constraint);
        int stringCount = 0;
        char[] ch = text.toCharArray();
        boolean inString = false;
        boolean escape = false;
        int beginIndex = 0;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (inString) {
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (!escape && c == '\"') {
                    ++stringCount;
                    String constraintText = text.substring(beginIndex + 1, i).trim().replaceAll("\\\\(.)", "$1");
                    if (constraintText.isEmpty()) {
                        constraintText = null;
                    }
                    switch (stringCount) {
                        case 1: {
                            constraint.set_message(constraintText);
                            break;
                        }
                        case 2: {
                            constraint.set_predicateQuery(constraintText);
                            break;
                        }
                        case 3: {
                            constraint.set_offendingElementsQuery(constraintText);
                            break;
                        }
                        default: {
                            throw new ProcessingException(this.getFileName(), "Illegal constraint format. The constraint text was '" + text + "'.");
                        }
                    }
                    inString = false;
                    continue;
                }
                if (!escape || c != '\"') continue;
                escape = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '\"') {
                inString = true;
                beginIndex = i;
                continue;
            }
            throw new ProcessingException(this.getFileName(), "Illegal constraint format. The constraint text was '" + text + "'.  Expected '\"' but got '" + c + "'.  (position = " + i + ").");
        }
        if (inString || escape || stringCount < 2 || stringCount > 3) {
            throw new ProcessingException(this.getFileName(), "Illegal constraint format.  The constraint text was '" + text + "'.");
        }
    }

    private void handleUpperValue() throws XMLStreamException {
        assert (this.currentAssociationEnd != null || this.inOwnedAttribute);
        int n = this.getValue();
        if (this.currentAssociationEnd == null && this.inOwnedAttribute) {
            if (n != 1) {
                throw new ProcessingException(this.getFileName(), "grUML does not support attribute multiplicities other than 1..1");
            }
        } else {
            assert (this.currentAssociationEnd != null);
            assert (n >= 1);
            this.currentAssociationEnd.set_max(n);
        }
    }

    private int getValue() throws XMLStreamException {
        String val = this.getAttribute("value");
        return val == null ? 0 : (val.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(val));
    }

    private void handleLowerValue() throws XMLStreamException {
        assert (this.currentAssociationEnd != null || this.inOwnedAttribute);
        int n = this.getValue();
        if (this.currentAssociationEnd == null && this.inOwnedAttribute) {
            if (n != 1) {
                throw new ProcessingException(this.getFileName(), "grUML does not support attribute multiplicities other than 1..1");
            }
        } else {
            assert (this.currentAssociationEnd != null);
            assert (n >= 0);
            this.currentAssociationEnd.set_min(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStereotype() throws XMLStreamException {
        String key = this.getAttribute("key");
        if (this.currentClass == null && this.currentClassId == null && this.currentAssociationEnd == null && this.currentAttribute == null && this.currentRecordDomain == null && this.currentRecordDomainComponent == null) {
            if (!key.equals("rsa2tg_ignore")) throw new ProcessingException(this.getParser(), this.getFileName(), "Unexpected stereotype <<" + key + ">>");
            this.ignoredPackages.add(this.packageStack.peek());
            return;
        }
        if (this.currentClass == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Unexpected stereotype <<" + key + ">>");
        }
        if (key.equals("graphclass")) {
            if (!(this.currentClass instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "The stereotype '<<graphclass>>' is only valid for a UML class.");
            }
            AttributedElementClass aec = (AttributedElementClass)this.idMap.get(this.currentClassId);
            assert (this.graphClass != null);
            this.graphClass.set_qualifiedName(aec.get_qualifiedName());
            Edge e = aec.getFirstIncidence();
            while (e != null) {
                Edge n = e.getNextIncidence();
                if (e instanceof ContainsGraphElementClass) {
                    e.delete();
                } else {
                    e.setThis(this.graphClass);
                }
                e = n;
            }
            aec.delete();
            this.idMap.put(this.currentClassId, this.graphClass);
            this.currentClass = this.graphClass;
            return;
        } else if (key.equals("record")) {
            if (!(this.currentClass instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "The stereotype '<<record>>' is only allow for UML-classes.");
            }
            RecordDomain rd = this.sg.createRecordDomain();
            rd.set_qualifiedName(this.currentClass.get_qualifiedName());
            Edge e = this.currentClass.getFirstIncidence();
            while (e != null) {
                Edge n = e.getNextIncidence();
                if (e instanceof ContainsGraphElementClass) {
                    this.sg.createContainsDomain((Package)e.getThat(), rd);
                    e.delete();
                } else if (e instanceof HasAttribute) {
                    de.uni_koblenz.jgralab.grumlschema.structure.Attribute att = (de.uni_koblenz.jgralab.grumlschema.structure.Attribute)e.getThat();
                    HasDomain d = att.getFirstHasDomainIncidence();
                    if (d != null) {
                        Domain dom = (Domain)e.getThat();
                        HasRecordDomainComponent comp = this.sg.createHasRecordDomainComponent(rd, dom);
                        comp.set_name(att.get_name());
                    } else {
                        String typeId = (String)this.attributeType.getMark(att);
                        if (typeId == null) {
                            throw new ProcessingException(this.getParser(), this.getFileName(), "No type id has been defined.");
                        }
                        StringDomain dom = this.sg.createStringDomain();
                        dom.set_qualifiedName(typeId);
                        this.preliminaryVertices.add(dom);
                        HasRecordDomainComponent comp = this.sg.createHasRecordDomainComponent(rd, dom);
                        this.recordComponentType.mark(comp, typeId);
                        this.attributeType.removeMark(att);
                    }
                    att.delete();
                }
                e = n;
            }
            if (this.currentClass.getDegree() != 0) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "The <<record>> class '" + this.currentClass.get_qualifiedName() + "' must not have any association.");
            }
            this.domainMap.put(rd.get_qualifiedName(), rd);
            this.idMap.put(this.currentClassId, rd);
            this.currentRecordDomain = rd;
            this.currentClass.delete();
            this.currentClass = null;
            this.currentClassId = null;
            return;
        } else {
            if (!key.equals("abstract")) throw new ProcessingException(this.getParser(), this.getFileName(), "Unexpected stereotype '<<" + key + ">>'.");
            if (!(this.currentClass instanceof GraphElementClass)) throw new ProcessingException(this.getParser(), this.getFileName(), "The stereotype <<abstract>> can only be specified for vertex and edge classes, but not for class '" + this.currentClass.get_qualifiedName() + "'");
            GraphElementClass gec = (GraphElementClass)this.currentClass;
            gec.set_abstract(true);
        }
    }

    private void handleGeneralization() throws XMLStreamException {
        String general = this.getAttribute("general");
        TreeSet<String> gens = (TreeSet<String>)this.generalizations.getMark(this.currentClass);
        if (gens == null) {
            gens = new TreeSet<String>();
            this.generalizations.mark(this.currentClass, gens);
        }
        gens.add(general);
    }

    private void handleNestedTypeElement(String xmiId) throws XMLStreamException {
        if (this.currentAttribute == null && this.currentRecordDomain == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "unexpected primitive type in element (XMI id " + xmiId + ")");
        }
        String href = this.getAttribute("href");
        if (href == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "No type name specified in primitive type href of attribute (XMI id " + xmiId + ")");
        }
        Domain dom = null;
        if (href.endsWith("#String")) {
            dom = this.createDomain("String");
        } else if (href.endsWith("#Integer")) {
            dom = this.createDomain("Integer");
        } else if (href.endsWith("#Boolean")) {
            dom = this.createDomain("Boolean");
        } else if (href.endsWith("#double")) {
            dom = this.createDomain("Double");
        } else {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Unknown primitive type with href '" + href + "' in attribute (XMI id " + xmiId + ")");
        }
        assert (dom != null);
        if (this.currentRecordDomain != null) {
            assert (this.currentRecordDomainComponent != null);
            Domain d = this.currentRecordDomainComponent.getOmega();
            assert (d instanceof StringDomain && d.get_qualifiedName() == null && this.preliminaryVertices.contains(d));
            this.currentRecordDomainComponent.setOmega(dom);
            d.delete();
            this.preliminaryVertices.remove(d);
            this.recordComponentType.removeMark(this.currentRecordDomainComponent);
        } else {
            assert (this.currentAttribute != null);
            this.sg.createHasDomain(this.currentAttribute, dom);
            this.attributeType.removeMark(this.currentAttribute);
        }
    }

    private void handleOwnedAttribute(String xmiId) throws XMLStreamException {
        String association = this.getAttribute("association");
        if (association == null) {
            boolean derived;
            String attrName = this.getAttribute("name");
            if (this.currentClass == null && this.currentRecordDomain == null) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "Found an attribute '" + attrName + "' (XMI id " + xmiId + ") outside a class!");
            }
            if (attrName == null) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "No attribute name in ownedAttribute (XMI id " + xmiId + ")");
            }
            if ((attrName = attrName.trim()).length() == 0) {
                throw new ProcessingException(this.getParser(), this.getFileName(), "Empty attribute name in ownedAttribute (XMI id " + xmiId + ")");
            }
            String isDerived = this.getAttribute("isDerived");
            boolean bl = derived = isDerived != null && isDerived.equals("true");
            if (derived) {
                return;
            }
            String typeId = this.getAttribute("type");
            if (this.currentClass != null) {
                de.uni_koblenz.jgralab.grumlschema.structure.Attribute att;
                this.currentAttribute = att = this.sg.createAttribute();
                att.set_name(attrName);
                this.sg.createHasAttribute(this.currentClass, att);
                if (typeId != null) {
                    this.attributeType.mark(att, typeId);
                }
            } else {
                assert (this.currentRecordDomain != null);
                this.currentAttribute = null;
                this.currentRecordDomainComponent = null;
                if (typeId != null) {
                    Vertex v = this.idMap.get(typeId);
                    if (v != null) {
                        assert (v instanceof Domain) : "typeID says " + typeId + " which is no Domain!";
                        this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, (Domain)v);
                    } else {
                        StringDomain dom = this.sg.createStringDomain();
                        dom.set_qualifiedName(typeId);
                        this.preliminaryVertices.add(dom);
                        this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, dom);
                        this.recordComponentType.mark(this.currentRecordDomainComponent, typeId);
                    }
                } else {
                    StringDomain dom = this.sg.createStringDomain();
                    this.preliminaryVertices.add(dom);
                    this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, dom);
                }
                this.currentRecordDomainComponent.set_name(attrName);
            }
        } else {
            this.handleAssociationEnd(xmiId);
        }
    }

    private void handleAssociationEnd(String xmiId) throws XMLStreamException {
        String endName = this.getAttribute("name");
        if (this.currentClass == null || this.currentRecordDomain != null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "Found an association end '" + endName + "' (XMI id " + xmiId + ") outside a class or in a record domain");
        }
        String agg = this.getAttribute("aggregation");
        boolean aggregation = agg != null && agg.equals("shared");
        boolean composition = agg != null && agg.equals("composite");
        String typeId = this.getAttribute("type");
        if (typeId == null) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "No type attribute in association end (XMI id" + xmiId + ")");
        }
        IncidenceClass inc = (IncidenceClass)this.idMap.get(xmiId);
        if (inc == null) {
            VertexClass vc = null;
            AttributedElement ae = this.idMap.get(typeId);
            if (ae != null) {
                if (!(ae instanceof VertexClass)) {
                    throw new ProcessingException(this.getParser(), this.getFileName(), "Type attribute of association end (XMI id " + xmiId + ") must denote a VertexClass, but is " + ae.getAttributedElementClass().getQualifiedName());
                }
                vc = (VertexClass)ae;
            } else {
                vc = this.sg.createVertexClass();
                vc.set_qualifiedName(typeId);
                this.preliminaryVertices.add(vc);
                this.idMap.put(typeId, vc);
            }
            EdgeClass ec = null;
            if (this.currentClass instanceof EdgeClass) {
                ec = (EdgeClass)this.currentClass;
                this.idMap.put(this.currentClassId, this.currentClass);
            } else {
                String associationId = this.getAttribute("association");
                if (associationId == null) {
                    throw new ProcessingException(this.getParser(), this.getFileName(), "No assiocation attribute in association end (XMI id " + xmiId + ")");
                }
                ae = this.idMap.get(associationId);
                if (ae != null) {
                    if (!(ae instanceof EdgeClass)) {
                        throw new ProcessingException(this.getParser(), this.getFileName(), "Assiocation attribute of association end (XMI id " + xmiId + ") must denote an EdgeClass, but is " + ae.getAttributedElementClass().getQualifiedName());
                    }
                    ec = (EdgeClass)ae;
                } else {
                    ec = this.sg.createEdgeClass();
                }
                this.preliminaryVertices.add(ec);
                this.idMap.put(associationId, ec);
            }
            assert (vc != null && ec != null);
            inc = this.sg.createIncidenceClass();
            inc.set_min(1);
            inc.set_max(1);
            this.sg.createComesFrom(ec, inc);
            this.sg.createEndsAt(inc, vc);
        } else {
            EdgeClass ec = (EdgeClass)(inc.getFirstComesFromIncidence() != null ? inc.getFirstComesFromIncidence() : inc.getFirstGoesToIncidence()).getThat();
            String id = null;
            for (Map.Entry<String, Vertex> idEntry : this.idMap.entrySet()) {
                if (idEntry.getValue() != ec) continue;
                id = idEntry.getKey();
                break;
            }
            assert (id != null);
            this.idMap.put(id, ec);
            VertexClass vc = (VertexClass)inc.getFirstEndsAtIncidence().getThat();
            if (this.preliminaryVertices.contains(vc)) {
                AttributedElement ae = this.idMap.get(typeId);
                if (ae != null && !vc.equals(ae)) {
                    if (!(ae instanceof VertexClass)) {
                        throw new ProcessingException(this.getParser(), this.getFileName(), "Type attribute of association end (XMI id " + xmiId + ") must denote a VertexClass, but is " + ae.getAttributedElementClass().getQualifiedName());
                    }
                    inc.getFirstEndsAtIncidence().setOmega((VertexClass)ae);
                    Set gens = (Set)this.generalizations.getMark(vc);
                    if (gens != null) {
                        this.generalizations.removeMark(vc);
                        this.generalizations.mark(ae, gens);
                    }
                    vc.delete();
                    this.preliminaryVertices.remove(vc);
                } else if (ae == null) {
                    this.idMap.put(typeId, vc);
                } else {
                    throw new RuntimeException("FIXME: Unexpected type. You should not get here!");
                }
            }
        }
        assert (inc != null);
        this.currentAssociationEnd = inc;
        if (this.currentClass instanceof EdgeClass) {
            this.ownedEnds.add(inc);
        }
        inc.set_aggregation(aggregation ? AggregationKind.SHARED : (composition ? AggregationKind.COMPOSITE : AggregationKind.NONE));
        this.idMap.put(xmiId, inc);
        inc.set_roleName(endName);
    }

    private void reconnectEdges(Vertex oldVertex, Vertex newVertex) {
        Edge curr = oldVertex.getFirstIncidence();
        while (curr != null) {
            Edge next = curr.getNextIncidence();
            curr.setThis(newVertex);
            curr = next;
        }
    }

    private Domain createDomain(String typeName) {
        Domain dom = this.domainMap.get(typeName);
        if (dom != null) {
            return dom;
        }
        if (typeName.equals("String")) {
            dom = this.sg.createStringDomain();
        } else if (typeName.equals("Integer")) {
            dom = this.sg.createIntegerDomain();
        } else if (typeName.equals("Double")) {
            dom = this.sg.createDoubleDomain();
        } else if (typeName.equals("Long")) {
            dom = this.sg.createLongDomain();
        } else if (typeName.equals("Boolean")) {
            dom = this.sg.createBooleanDomain();
        } else if (typeName.startsWith("Map<") && typeName.endsWith(">")) {
            dom = this.sg.createMapDomain();
            String keyValueDomains = typeName.substring(4, typeName.length() - 1);
            char[] c = keyValueDomains.toCharArray();
            int p = 0;
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == ',' && p == 0) {
                    p = i;
                    break;
                }
                if (c[i] == '<') {
                    ++p;
                } else if (c[i] == '>') {
                    --p;
                }
                if (p >= 0) continue;
                throw new ProcessingException(this.getFileName(), "Error in primitive type name: '" + typeName + "'");
            }
            if (p <= 0 || p >= c.length - 1) {
                throw new ProcessingException(this.getFileName(), "Error in primitive type name: '" + typeName + "'");
            }
            String keyDomainName = keyValueDomains.substring(0, p);
            Domain keyDomain = this.createDomain(keyDomainName);
            assert (keyDomain != null);
            String valueDomainName = keyValueDomains.substring(p + 1);
            Domain valueDomain = this.createDomain(valueDomainName);
            assert (valueDomain != null);
            this.sg.createHasKeyDomain((MapDomain)dom, keyDomain);
            this.sg.createHasValueDomain((MapDomain)dom, valueDomain);
            typeName = "Map<" + keyDomainName + ", " + valueDomainName + '>';
        } else if (typeName.startsWith("List<") && typeName.endsWith(">")) {
            dom = this.sg.createListDomain();
            String compTypeName = typeName.substring(5, typeName.length() - 1);
            Domain compDomain = this.createDomain(compTypeName);
            assert (compDomain != null);
            this.sg.createHasBaseDomain((CollectionDomain)dom, compDomain);
        } else if (typeName.startsWith("Set<") && typeName.endsWith(">")) {
            dom = this.sg.createSetDomain();
            String compTypeName = typeName.substring(4, typeName.length() - 1);
            Domain compDomain = this.createDomain(compTypeName);
            assert (compDomain != null);
            this.sg.createHasBaseDomain((CollectionDomain)dom, compDomain);
        }
        if (dom != null) {
            this.sg.createContainsDomain((Package)this.packageStack.get(0), dom);
        } else {
            dom = this.sg.createStringDomain();
            this.preliminaryVertices.add(dom);
        }
        assert (dom != null);
        dom.set_qualifiedName(typeName);
        this.domainMap.put(typeName, dom);
        return dom;
    }

    private String getQualifiedName(String simpleName) {
        assert (simpleName != null);
        simpleName = simpleName.trim();
        Package p = this.packageStack.peek();
        assert (p != null);
        if (p.get_qualifiedName().equals("")) {
            return simpleName;
        }
        return p.get_qualifiedName() + "." + simpleName;
    }

    public void setUseFromRole(boolean useFromRole) {
        this.useFromRole = useFromRole;
    }

    public boolean isUseFromRole() {
        return this.useFromRole;
    }

    public void setRemoveUnusedDomains(boolean removeUnusedDomains) {
        this.removeUnusedDomains = removeUnusedDomains;
    }

    public boolean isRemoveUnusedDomains() {
        return this.removeUnusedDomains;
    }

    public void setUseNavigability(boolean useNavigability) {
        this.useNavigability = useNavigability;
    }

    public boolean isUseNavigability() {
        return this.useNavigability;
    }

    public SchemaGraph getSchemaGraph() {
        return this.sg;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public String getFilenameSchema() {
        return this.filenameSchema;
    }

    public void setFilenameSchema(String filenameSchema) {
        this.filenameSchema = filenameSchema;
    }

    public String getFilenameSchemaGraph() {
        return this.filenameSchemaGraph;
    }

    public void setFilenameSchemaGraph(String filenameSchemaGraph) {
        this.filenameSchemaGraph = filenameSchemaGraph;
    }

    public String getFilenameDot() {
        return this.filenameDot;
    }

    public void setFilenameDot(String filenameDot) {
        this.filenameDot = filenameDot;
    }

    public String getFilenameValidation() {
        return this.filenameValidation;
    }

    public void setFilenameValidation(String filenameValidation) {
        this.filenameValidation = filenameValidation;
    }

    public boolean isKeepEmptyPackages() {
        return this.keepEmptyPackages;
    }

    public void setKeepEmptyPackages(boolean removeEmptyPackages) {
        this.keepEmptyPackages = removeEmptyPackages;
    }
}

