/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.tools.ant.Task;

public class RetrieveVersion
extends Task {
    public final String VERSION_FILENAME = "version.properties";
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    private static final String MICRO = "micro";
    private static final String CODENAME = "codename";
    private static final String HEAD = "head";
    private final Properties prop = new Properties();
    protected String major;
    protected String minor;
    protected String micro;
    protected String head;
    protected String codename;

    private void checkExisting(File f) {
        if (!f.exists() || !f.canRead()) {
            throw new RuntimeException(f.getAbsolutePath() + " doesn't exist!");
        }
    }

    protected void setHEAD() {
        File headFile = new File(this.getProject().getBaseDir() + File.separator + ".git" + File.separator + "HEAD");
        this.checkExisting(headFile);
        BufferedReader rb = null;
        try {
            rb = new BufferedReader(new FileReader(headFile));
            String ref = rb.readLine();
            int idx = ref.indexOf(32);
            ref = ref.substring(idx + 1).replace('/', File.separatorChar);
            rb.close();
            File headRefFile = new File(this.getProject().getBaseDir() + File.separator + ".git" + File.separator + ref);
            this.checkExisting(headRefFile);
            rb = new BufferedReader(new FileReader(headRefFile));
            this.head = rb.readLine();
            rb.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute() {
        this.readProperties();
        this.getProject().setNewProperty("version", this.major + "." + this.minor + "." + this.micro);
        this.getProject().setNewProperty("version.major", this.major);
        this.getProject().setNewProperty("version.minor", this.minor);
        this.getProject().setNewProperty("version.micro", this.micro);
        this.getProject().setNewProperty("version.head", this.head);
        this.getProject().setNewProperty("version.codename", this.codename);
    }

    protected void readProperties() {
        File propertyFile = new File(this.getProject().getBaseDir(), "version.properties");
        try {
            this.prop.load(new FileInputStream(propertyFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.major = this.prop.getProperty(MAJOR, "0");
        this.minor = this.prop.getProperty(MINOR, "0");
        this.micro = this.prop.getProperty(MICRO, "0");
        this.head = this.prop.getProperty(HEAD, "<unknown>");
        this.codename = this.prop.getProperty(CODENAME, "?");
    }

    protected void saveProperties() {
        File propertyFile = new File(this.getProject().getBaseDir(), "version.properties");
        this.prop.put(MAJOR, this.major);
        this.prop.put(MINOR, this.minor);
        this.prop.put(MICRO, this.micro);
        this.prop.put(HEAD, this.head);
        this.prop.put(CODENAME, this.codename);
        try {
            this.prop.store(new FileOutputStream(propertyFile), "JGraLab version information");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writePomFile() {
        try {
            PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("pom.xml"), "UTF-8"));
            w.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            w.println("<project>");
            w.println("\t<modelVersion>4.0.0</modelVersion>");
            w.println("\t<groupId>de.uni-koblenz.ist</groupId>");
            w.println("\t<artifactId>jgralab</artifactId>");
            w.println("\t<version>" + this.major + "." + this.minor + "." + this.micro + "</version>");
            w.println("\t<name>JGraLab</name>");
            w.println("\t<description>");
            w.println("\t\tA high-performance TGraph library.");
            w.println("\t\tSee https://github.com/jgralab/jgralab");
            w.println("\t</description>");
            w.println("\t<repositories>");
            w.println("\t\t<repository>");
            w.println("\t\t\t<id>clojars</id>");
            w.println("\t\t\t<url>http://clojars.org/repo/</url>");
            w.println("\t\t</repository>");
            w.println("\t</repositories>");
            w.println("</project>");
            w.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

