/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.EdgeClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.TemporaryEdgeClassImpl;
import de.uni_koblenz.jgralab.schema.impl.TemporaryVertexClassImpl;
import de.uni_koblenz.jgralab.schema.impl.VertexClassImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pcollections.PVector;

public final class GraphClassImpl
extends AttributedElementClassImpl<GraphClass, Graph>
implements GraphClass {
    Map<String, VertexClass> vertexClasses = new HashMap<String, VertexClass>();
    DirectedAcyclicGraph<VertexClass> vertexClassDag = new DirectedAcyclicGraph(true);
    Map<String, EdgeClass> edgeClasses = new HashMap<String, EdgeClass>();
    DirectedAcyclicGraph<EdgeClass> edgeClassDag = new DirectedAcyclicGraph(true);
    PVector<VertexClass> userDefinedVertexClasses;
    PVector<EdgeClass> userDefinedEdgeClasses;
    PVector<GraphElementClass<?, ?>> userDefinedGraphElementClasses;
    private VertexClassImpl defaultVertexClass;
    private EdgeClassImpl defaultEdgeClass;
    private TemporaryVertexClassImpl tempVertexClass;
    private TemporaryEdgeClassImpl tempEdgeClass;

    GraphClassImpl(String gcName, SchemaImpl schema) {
        super(gcName, (PackageImpl)schema.getDefaultPackage(), schema);
        schema.setGraphClass(this);
    }

    @Override
    public final VertexClass getDefaultVertexClass() {
        return this.defaultVertexClass;
    }

    final void initializeDefaultVertexClass() {
        VertexClassImpl vc = new VertexClassImpl("Vertex", (PackageImpl)this.schema.getDefaultPackage(), this);
        vc.setAbstract(true);
        this.defaultVertexClass = vc;
    }

    final void initializeDefaultEdgeClass() {
        assert (this.getDefaultVertexClass() != null) : "Default VertexClass has not yet been created!";
        assert (this.getDefaultEdgeClass() == null) : "Default EdgeClass already created!";
        EdgeClassImpl ec = new EdgeClassImpl("Edge", (PackageImpl)this.schema.getDefaultPackage(), this, this.defaultVertexClass, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, this.defaultVertexClass, 0, Integer.MAX_VALUE, "", AggregationKind.NONE);
        ec.setAbstract(true);
        this.defaultEdgeClass = ec;
    }

    @Override
    public final VertexClass getTemporaryVertexClass() {
        return this.tempVertexClass;
    }

    final void initializeTemporaryVertexClass() {
        assert (this.getTemporaryVertexClass() == null) : "TemporaryVertexClass already created!";
        this.tempVertexClass = new TemporaryVertexClassImpl(this);
    }

    final void initializeTemporaryEdgeClass() {
        assert (this.getDefaultVertexClass() != null) : "Default VertexClass has not yet been created!";
        assert (this.getTemporaryEdgeClass() == null) : "TemporaryEdgeClass already created!";
        this.tempEdgeClass = new TemporaryEdgeClassImpl(this);
    }

    @Override
    public final EdgeClass getTemporaryEdgeClass() {
        return this.tempEdgeClass;
    }

    @Override
    public final EdgeClass getDefaultEdgeClass() {
        return this.defaultEdgeClass;
    }

    void addEdgeClass(EdgeClass ec) {
        if (this.edgeClasses.containsKey(ec.getQualifiedName())) {
            throw new SchemaException("Duplicate edge class name '" + ec.getQualifiedName() + "'");
        }
        if (!ec.getQualifiedName().equals("Edge") && !ec.getQualifiedName().equals("TemporaryEdgeClass")) {
            this.edgeClasses.put(ec.getQualifiedName(), ec);
        }
    }

    void addVertexClass(VertexClass vc) {
        if (this.vertexClasses.containsKey(vc.getQualifiedName())) {
            throw new SchemaException("Duplicate vertex class name '" + vc.getQualifiedName() + "'");
        }
        if (!vc.getQualifiedName().equals("Vertex") && !vc.getQualifiedName().equals("TemporaryVertexClass")) {
            this.vertexClasses.put(vc.getQualifiedName(), vc);
        }
    }

    @Override
    public final EdgeClass createEdgeClass(String qualifiedName, VertexClass from, int fromMin, int fromMax, String fromRoleName, AggregationKind aggrFrom, VertexClass to, int toMin, int toMax, String toRoleName, AggregationKind aggrTo) {
        this.assertNotFinished();
        if (from.isDefaultGraphElementClass() || to.isDefaultGraphElementClass()) {
            throw new SchemaException("EdgeClasses starting or ending at the default VertexClass Vertex are forbidden.");
        }
        if (aggrFrom != AggregationKind.NONE && aggrTo != AggregationKind.NONE) {
            throw new SchemaException("At least one end of each class must be of AggregationKind NONE at EdgeClass " + qualifiedName);
        }
        String[] qn = SchemaImpl.splitQualifiedName(qualifiedName);
        PackageImpl parent = this.schema.createPackageWithParents(qn[0]);
        EdgeClassImpl ec = new EdgeClassImpl(qn[1], parent, this, from, fromMin, fromMax, fromRoleName, aggrFrom, to, toMin, toMax, toRoleName, aggrTo);
        if (this.defaultEdgeClass != null) {
            ec.addSuperClass(this.defaultEdgeClass);
        }
        return ec;
    }

    @Override
    public final VertexClass createVertexClass(String qualifiedName) {
        this.assertNotFinished();
        String[] qn = SchemaImpl.splitQualifiedName(qualifiedName);
        PackageImpl parent = ((SchemaImpl)this.getSchema()).createPackageWithParents(qn[0]);
        VertexClassImpl vc = new VertexClassImpl(qn[1], parent, this);
        if (this.defaultVertexClass != null) {
            vc.addSuperClass(this.defaultVertexClass);
        }
        return vc;
    }

    @Override
    public final GraphElementClass<?, ?> getGraphElementClass(String qn) {
        GraphElementClass gec = this.vertexClasses.get(qn);
        if (gec != null) {
            return gec;
        }
        return this.edgeClasses.get(qn);
    }

    @Override
    public final List<GraphElementClass<?, ?>> getGraphElementClasses() {
        if (this.finished) {
            return this.userDefinedGraphElementClasses;
        }
        PVector vec = JGraLab.vector();
        return vec.plusAll(this.getVertexClasses()).plusAll(this.getEdgeClasses());
    }

    @Override
    public final List<EdgeClass> getEdgeClasses() {
        if (this.finished) {
            return this.userDefinedEdgeClasses;
        }
        PVector<EdgeClass> vec = this.edgeClassDag.getNodesInTopologicalOrder();
        assert (vec.get(0) == this.defaultEdgeClass);
        assert (vec.get(1) == this.tempEdgeClass);
        return vec.subList(2, vec.size());
    }

    @Override
    public final List<VertexClass> getVertexClasses() {
        if (this.finished) {
            return this.userDefinedVertexClasses;
        }
        PVector<VertexClass> vec = this.vertexClassDag.getNodesInTopologicalOrder();
        assert (vec.get(0) == this.defaultVertexClass);
        assert (vec.get(1) == this.tempVertexClass);
        return vec.subList(2, vec.size());
    }

    @Override
    public final VertexClass getVertexClass(String qn) {
        return this.vertexClasses.get(qn);
    }

    @Override
    public final EdgeClass getEdgeClass(String qn) {
        return this.edgeClasses.get(qn);
    }

    @Override
    public final int getEdgeClassCount() {
        return this.edgeClasses.size();
    }

    @Override
    public final int getVertexClassCount() {
        return this.vertexClasses.size();
    }

    @Override
    protected final void finish() {
        this.assertNotFinished();
        this.vertexClassDag.finish();
        this.edgeClassDag.finish();
        for (VertexClass vc : this.vertexClassDag.getNodesInTopologicalOrder()) {
            ((VertexClassImpl)vc).finish();
        }
        for (EdgeClass ec : this.edgeClassDag.getNodesInTopologicalOrder()) {
            ((EdgeClassImpl)ec).finish();
        }
        this.userDefinedVertexClasses = this.vertexClassDag.getNodesInTopologicalOrder();
        assert (this.userDefinedVertexClasses.get(0) == this.defaultVertexClass);
        assert (this.userDefinedVertexClasses.get(1) == this.tempVertexClass);
        this.userDefinedVertexClasses = this.userDefinedVertexClasses.subList(2, this.userDefinedVertexClasses.size());
        this.userDefinedEdgeClasses = this.edgeClassDag.getNodesInTopologicalOrder();
        assert (this.userDefinedEdgeClasses.get(0) == this.defaultEdgeClass);
        assert (this.userDefinedEdgeClasses.get(1) == this.tempEdgeClass);
        this.userDefinedEdgeClasses = this.userDefinedEdgeClasses.subList(2, this.userDefinedEdgeClasses.size());
        this.userDefinedGraphElementClasses = JGraLab.vector();
        this.userDefinedGraphElementClasses = this.userDefinedGraphElementClasses.plusAll(this.userDefinedVertexClasses).plusAll(this.userDefinedEdgeClasses);
        super.finish();
    }

    @Override
    public final boolean hasOwnAttributes() {
        return this.hasAttributes();
    }

    @Override
    public final Attribute getOwnAttribute(String name) {
        return this.getAttribute(name);
    }

    @Override
    public final int getOwnAttributeCount() {
        return this.getAttributeCount();
    }

    @Override
    public final List<Attribute> getOwnAttributeList() {
        return this.getAttributeList();
    }

    @Override
    public void setQualifiedName(String newQName) {
        if (this.qualifiedName.equals(newQName)) {
            return;
        }
        if (this.schema.knows(newQName)) {
            throw new SchemaException(newQName + " is already known to the schema.");
        }
        if (newQName.contains(".")) {
            throw new SchemaException("The GraphClass must be in the default package. You tried to move it to '" + newQName + "'.");
        }
        this.unregister();
        this.qualifiedName = newQName;
        this.simpleName = newQName;
        this.register();
    }

    @Override
    protected final void reopen() {
        for (VertexClass vc : this.vertexClassDag.getNodesInTopologicalOrder()) {
            ((VertexClassImpl)vc).reopen();
        }
        for (EdgeClass ec : this.edgeClassDag.getNodesInTopologicalOrder()) {
            ((EdgeClassImpl)ec).reopen();
        }
        this.vertexClassDag.reopen();
        this.edgeClassDag.reopen();
        super.reopen();
    }

    @Override
    protected void deleteAttribute(AttributeImpl attr) {
        this.allAttributes = this.allAttributes.minus(attr);
    }
}

