/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class AttributedElementClassImpl<SC extends AttributedElementClass<SC, IC>, IC extends AttributedElement<SC, IC>>
extends NamedElementImpl
implements AttributedElementClass<SC, IC> {
    protected PVector<Attribute> allAttributes = ArrayPVector.empty();
    protected PSet<Constraint> constraints = ArrayPSet.empty();
    protected HashMap<String, Integer> attributeIndex;
    protected boolean finished;
    private boolean isAbstract;
    private Class<IC> schemaClass;
    private Class<IC> schemaImplementationClass;

    protected AttributedElementClassImpl(String simpleName, PackageImpl pkg, SchemaImpl schema) {
        super(simpleName, pkg, schema);
    }

    protected Attribute createAttribute(Attribute anAttribute) {
        this.assertNotFinished();
        if (this.containsAttribute(anAttribute.getName())) {
            throw new SchemaException("Duplicate attribute '" + anAttribute.getName() + "' in AttributedElementClass '" + this.getQualifiedName() + "'");
        }
        TreeSet<Attribute> s = new TreeSet<Attribute>(this.allAttributes);
        s.add(anAttribute);
        this.allAttributes = ArrayPVector.empty().plusAll(s);
        return anAttribute;
    }

    @Override
    public Attribute createAttribute(String name, Domain domain, String defaultValueAsString) {
        return this.createAttribute(new AttributeImpl(name, domain, this, defaultValueAsString));
    }

    @Override
    public Attribute createAttribute(String name, Domain domain) {
        return this.createAttribute(new AttributeImpl(name, domain, this, null));
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.assertNotFinished();
        this.constraints = this.constraints.plus(constraint);
    }

    protected String attributesToString() {
        StringBuilder output = new StringBuilder("Attributes:\n");
        for (Attribute a : this.getAttributeList()) {
            output.append("\t" + a.toString() + "\n");
        }
        return output.toString();
    }

    @Override
    public boolean containsAttribute(String name) {
        if (this.finished) {
            return this.attributeIndex.containsKey(name);
        }
        return this.getAttribute(name) != null;
    }

    @Override
    public Attribute getAttribute(String name) {
        for (Attribute a : this.allAttributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.allAttributes.size();
    }

    @Override
    public List<Attribute> getAttributeList() {
        return this.allAttributes;
    }

    public PSet<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public Class<IC> getSchemaClass() {
        if (this.schemaClass == null) {
            String schemaClassName = this.schema.getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(schemaClassName, true, SchemaClassManager.instance(this.schema.getQualifiedName()));
            }
            catch (ClassNotFoundException e) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for AttributedElementClass '" + this.getQualifiedName() + "'", e);
            }
        }
        return this.schemaClass;
    }

    @Override
    public Class<IC> getSchemaImplementationClass() {
        if (this.isAbstract()) {
            throw new SchemaClassAccessException("Can't get (generated) schema implementation class. AttributedElementClass '" + this.getQualifiedName() + "' is abstract!");
        }
        if (this.schemaImplementationClass == null) {
            try {
                Field f = this.getSchemaClass().getField("IMPLEMENTATION_CLASS");
                this.schemaImplementationClass = (Class)f.get(this.schemaClass);
            }
            catch (SecurityException e) {
                throw new SchemaClassAccessException(e);
            }
            catch (NoSuchFieldException e) {
                throw new SchemaClassAccessException(e);
            }
            catch (IllegalArgumentException e) {
                throw new SchemaClassAccessException(e);
            }
            catch (IllegalAccessException e) {
                throw new SchemaClassAccessException(e);
            }
        }
        return this.schemaImplementationClass;
    }

    @Override
    public boolean hasAttributes() {
        return !this.getAttributeList().isEmpty();
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    protected void finish() {
        assert (this.allAttributes != null);
        this.attributeIndex = new HashMap();
        int i = 0;
        for (Attribute a : this.allAttributes) {
            this.attributeIndex.put(a.getName(), i);
            ++i;
        }
        this.finished = true;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    protected void assertNotFinished() {
        if (this.finished) {
            throw new SchemaException("No changes allowed in a finished Schema.");
        }
    }

    @Override
    public int getAttributeIndex(String name) {
        if (this.finished) {
            Integer i = this.attributeIndex.get(name);
            if (i != null) {
                return i;
            }
        } else {
            int i = 0;
            for (Attribute a : this.getAttributeList()) {
                if (a.getName().equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        throw new NoSuchAttributeException(this.getQualifiedName() + " doesn't contain an attribute '" + name + "'");
    }

    protected void reopen() {
        this.attributeIndex = null;
        this.finished = false;
    }

    protected abstract void deleteAttribute(AttributeImpl var1);
}

