/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AttributedElementCodeGenerator<SC extends AttributedElementClass<SC, IC>, IC extends AttributedElement<SC, IC>>
extends CodeGenerator {
    protected SortedSet<String> interfaces;
    protected SC aec;

    protected AttributedElementCodeGenerator(SC attributedElementClass, String schemaRootPackageName, CodeGeneratorConfiguration config) {
        super(schemaRootPackageName, attributedElementClass.getPackageName(), config);
        this.aec = attributedElementClass;
        this.rootBlock.setVariable("schemaTypeName", this.getSchemaTypeName());
        this.rootBlock.setVariable("qualifiedClassName", this.aec.getQualifiedName());
        this.rootBlock.setVariable("schemaName", this.aec.getSchema().getName());
        this.rootBlock.setVariable("javaClassName", schemaRootPackageName + "." + this.aec.getQualifiedName());
        this.rootBlock.setVariable("qualifiedImplClassName", schemaRootPackageName + ".impl.std" + this.aec.getQualifiedName() + "Impl");
        this.rootBlock.setVariable("simpleClassName", this.aec.getSimpleName());
        this.rootBlock.setVariable("simpleImplClassName", this.aec.getSimpleName() + "Impl");
        this.rootBlock.setVariable("uniqueClassName", this.aec.getUniqueName());
        this.rootBlock.setVariable("schemaPackageName", schemaRootPackageName);
        this.rootBlock.setVariable("theGraph", "graph");
        this.interfaces = new TreeSet<String>();
        this.interfaces.add(this.aec.getQualifiedName());
        this.rootBlock.setVariable("isAbstractClass", this.aec.isAbstract() ? "true" : "false");
    }

    protected abstract String getSchemaTypeName();

    protected String absoluteName(AttributedElementClass<?, ?> aec) {
        return this.schemaRootPackageName + "." + aec.getQualifiedName();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            code.add(this.createFields(this.aec.getAttributeList()));
            code.add(this.createConstructor());
            code.add(this.createGetAttributedElementClassMethod());
            code.add(this.createGetSchemaClassMethod());
            code.add(this.createGenericGetter(this.aec.getAttributeList()));
            code.add(this.createGenericSetter(this.aec.getAttributeList()));
            code.add(this.createGettersAndSetters(this.aec.getAttributeList()));
            code.add(this.createReadAttributesMethod(this.aec.getAttributeList()));
            code.add(this.createReadAttributesFromStringMethod(this.aec.getAttributeList()));
            code.add(this.createWriteAttributesMethod(this.aec.getAttributeList()));
            code.add(this.createWriteAttributeToStringMethod(this.aec.getAttributeList()));
        }
        if (this.currentCycle.isAbstract()) {
            code.add(this.createAttributedElementClassConstant());
            code.add(this.createGettersAndSetters(this.aec.getOwnAttributeList()));
        }
        return code;
    }

    protected abstract CodeBlock createAttributedElementClassConstant();

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("classOrInterface", this.currentCycle.isStdImpl() ? " class" : " interface");
        code.setVariable("abstract", this.currentCycle.isStdImpl() && this.aec.isAbstract() ? " abstract" : "");
        code.setVariable("impl", this.currentCycle.isStdImpl() && !this.aec.isAbstract() ? "Impl" : "");
        code.add("public#abstract##classOrInterface# #simpleClassName##impl##extends##implements# {");
        code.setVariable("extends", this.currentCycle.isStdImpl() ? " extends #baseClassName#" : "");
        StringBuilder buf = new StringBuilder();
        if (this.interfaces.size() > 0) {
            String delim = this.currentCycle.isStdImpl() ? " implements " : " extends ";
            for (String interfaceName : this.interfaces) {
                if (!this.currentCycle.isStdImpl() && interfaceName.equals(this.aec.getQualifiedName())) continue;
                if (interfaceName.equals("Vertex") || interfaceName.equals("Edge") || interfaceName.equals("Graph")) {
                    buf.append(delim);
                    buf.append("#jgPackage#." + interfaceName);
                    delim = ", ";
                    continue;
                }
                buf.append(delim);
                buf.append(this.schemaRootPackageName + "." + interfaceName);
                delim = ", ";
            }
        }
        code.setVariable("implements", buf.toString());
        return code;
    }

    protected CodeBlock createStaticImplementationClassField() {
        return new CodeSnippet(true, "/**", " * refers to the default implementation class of this interface", " */", "public static final java.lang.Class<#qualifiedImplClassName#> IMPLEMENTATION_CLASS = #qualifiedImplClassName#.class;");
    }

    protected CodeBlock createSpecialConstructorCode() {
        return null;
    }

    protected CodeBlock createConstructor() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "public #simpleClassName#Impl(int id, #jgPackage#.Graph g) {", "\tsuper(id, g);"));
        if (this.hasDefaultAttributeValues()) {
            code.addNoIndent(new CodeSnippet("\tinitializeAttributesWithDefaultValues();"));
        }
        code.add(this.createSpecialConstructorCode());
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected boolean hasDefaultAttributeValues() {
        for (Attribute attr : this.aec.getAttributeList()) {
            if (attr.getDefaultValueAsString() == null) continue;
            return true;
        }
        return false;
    }

    protected abstract CodeBlock createGetAttributedElementClassMethod();

    protected CodeBlock createGetSchemaClassMethod() {
        return new CodeSnippet(true, "@Override", "public final java.lang.Class<? extends #jgPackage#.#graphElementClass#> getSchemaClass() {", "\treturn #javaClassName#.class;", "}");
    }

    protected CodeBlock createGenericGetter(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        CodeSnippet snip = new CodeSnippet(true, new String[0]);
        code.addNoIndent(snip);
        if (!attributes.isEmpty()) {
            snip.add("@SuppressWarnings(\"unchecked\")");
        }
        snip.add("public <T> T getAttribute(String attributeName) {");
        for (Attribute attr : attributes) {
            CodeSnippet s = new CodeSnippet();
            if (attr.getDomain().isPrimitive()) {
                s.setVariable("attributeClassName", " (" + attr.getDomain().getJavaClassName(this.schemaRootPackageName) + ")");
            } else {
                s.setVariable("attributeClassName", "");
            }
            s.setVariable("name", attr.getName());
            s.setVariable("isOrGet", attr.getDomain().isBoolean() ? "is" : "get");
            s.setVariable("cName", attr.getName());
            s.add("if (attributeName.equals(\"#name#\")) return (T)#attributeClassName# #isOrGet#_#cName#();");
            code.add(s);
        }
        code.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createGenericSetter(List<Attribute> attrSet) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        CodeSnippet snip = new CodeSnippet(true, new String[0]);
        boolean suppressWarningsNeeded = false;
        for (Attribute attr : attrSet) {
            if (!attr.getDomain().isComposite() || attr.getDomain() instanceof RecordDomain) continue;
            suppressWarningsNeeded = true;
            break;
        }
        if (suppressWarningsNeeded) {
            snip.add("@SuppressWarnings(\"unchecked\")");
        }
        snip.add("public <T> void setAttribute(String attributeName, T data) {");
        code.addNoIndent(snip);
        for (Attribute attr : attrSet) {
            CodeSnippet s = new CodeSnippet();
            s.setVariable("name", attr.getName());
            if (attr.getDomain().isComposite()) {
                s.setVariable("attributeClassName", attr.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            } else {
                s.setVariable("attributeClassName", attr.getDomain().getJavaClassName(this.schemaRootPackageName));
            }
            boolean isEnumDomain = false;
            if (attr.getDomain() instanceof EnumDomain) {
                isEnumDomain = true;
            }
            if (isEnumDomain) {
                s.add("if (attributeName.equals(\"#name#\")) {");
                s.add("\tif (data instanceof String) {");
                s.add("\t\tset_#name#(#attributeClassName#.valueOfPermitNull((String) data));");
                s.add("\t} else {");
                s.add("\t\tset_#name#((#attributeClassName#) data);");
                s.add("\t}");
                s.add("\treturn;");
                s.add("}");
            } else {
                s.add("if (attributeName.equals(\"#name#\")) {");
                s.add("\tset_#name#((#attributeClassName#) data);");
                s.add("\treturn;");
                s.add("}");
            }
            code.add(s);
        }
        code.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createFields(List<Attribute> attributes) {
        CodeList code = new CodeList();
        for (Attribute attr : attributes) {
            code.addNoIndent(this.createField(attr));
        }
        return code;
    }

    protected CodeBlock createGettersAndSetters(List<Attribute> attributes) {
        CodeList code = new CodeList();
        for (Attribute attr : attributes) {
            code.addNoIndent(this.createGetter(attr));
            code.addNoIndent(this.createSetter(attr));
        }
        return code;
    }

    protected CodeBlock createGetter(Attribute attr) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("name", attr.getName());
        code.setVariable("type", attr.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        code.setVariable("isOrGet", attr.getDomain().isBoolean() ? "is" : "get");
        switch (this.currentCycle) {
            case ABSTRACT: {
                code.add("public #type# #isOrGet#_#name#();");
                break;
            }
            case STDIMPL: {
                code.add("public #type# #isOrGet#_#name#() {", "\treturn _#name#;", "}");
                break;
            }
        }
        return code;
    }

    protected void addCheckValidityCode(CodeSnippet code) {
        code.add("\tif (!isValid())", "\t\tthrow new #jgPackage#.exception.GraphException(\"Cannot access attribute '#name#', because \" + this + \" isn't valid in current transaction.\");");
    }

    protected CodeBlock createSetter(Attribute attr) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("name", attr.getName());
        code.setVariable("type", attr.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        code.setVariable("dname", attr.getDomain().getSimpleName());
        switch (this.currentCycle) {
            case ABSTRACT: {
                code.add("public void set_#name#(#type# _#name#);");
                break;
            }
            case STDIMPL: {
                code.add("public void set_#name#(#type# _#name#) {", "\tecaAttributeChanging(\"#name#\", this._#name#, _#name#);", "\tObject oldValue = this._#name#;", "\tthis._#name# = _#name#;", "\tgraphModified();", "\tecaAttributeChanged(\"#name#\", oldValue, _#name#);", "}");
                break;
            }
        }
        return code;
    }

    protected CodeBlock createField(Attribute attr) {
        CodeSnippet code = new CodeSnippet(true, "protected #type# _#name#;");
        code.setVariable("name", attr.getName());
        if (this.currentCycle.isStdImpl()) {
            code.setVariable("type", attr.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        }
        return code;
    }

    protected CodeBlock createReadAttributesFromStringMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "#jgPackage#.exception.NoSuchAttributeException");
        code.addNoIndent(new CodeSnippet(true, "public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {"));
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                CodeList a = new CodeList();
                a.setVariable("variableName", attribute.getName());
                a.setVariable("setterName", "set_" + attribute.getName());
                a.addNoIndent(new CodeSnippet("if (attributeName.equals(\"#variableName#\")) {", "\tGraphIO io = GraphIO.createStringReader(value, getSchema());"));
                if (this.currentCycle.isStdImpl()) {
                    a.add(attribute.getDomain().getReadMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                    a.addNoIndent(new CodeSnippet("\t#setterName#(_#variableName#);", "\treturn;", "}"));
                }
                code.add(a);
            }
        }
        code.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createWriteAttributeToStringMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "#jgPackage#.exception.NoSuchAttributeException");
        code.addNoIndent(new CodeSnippet(true, "public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {"));
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                CodeList a = new CodeList();
                a.setVariable("variableName", attribute.getName());
                a.setVariable("setterName", "set_" + attribute.getName());
                a.addNoIndent(new CodeSnippet("if (attributeName.equals(\"#variableName#\")) {", "\tGraphIO io = GraphIO.createStringWriter(getSchema());"));
                if (this.currentCycle.isStdImpl()) {
                    a.add(attribute.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                }
                a.addNoIndent(new CodeSnippet("\treturn io.getStringWriterResult();", "}"));
                code.add(a);
            }
        }
        code.add(new CodeSnippet("throw new NoSuchAttributeException(\"#qualifiedClassName# doesn't contain an attribute \" + attributeName);"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createReadAttributesMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        code.addNoIndent(new CodeSnippet(true, "public void readAttributeValues(GraphIO io) throws GraphIOException {"));
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                CodeSnippet snippet = new CodeSnippet();
                snippet.setVariable("setterName", "set_" + attribute.getName());
                snippet.setVariable("variableName", attribute.getName());
                if (this.currentCycle.isStdImpl()) {
                    code.add(attribute.getDomain().getReadMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
                }
                snippet.add("#setterName#(_#variableName#);");
                code.add(snippet);
            }
        }
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createWriteAttributesMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        code.addNoIndent(new CodeSnippet(true, "public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {"));
        if (attributes != null && !attributes.isEmpty()) {
            code.add(new CodeSnippet("io.space();"));
            for (Attribute attribute : attributes) {
                if (!this.currentCycle.isStdImpl()) continue;
                code.add(attribute.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + attribute.getName(), "io"));
            }
        }
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }
}

