/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphImpl;
import de.uni_koblenz.jgralab.impl.generic.InternalAttributesArrayAccess;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;

public class GenericVertexImpl
extends VertexImpl
implements InternalAttributesArrayAccess {
    private final VertexClass type;
    private Object[] attributes;

    protected GenericVertexImpl(VertexClass type, int id, Graph graph) {
        super(id, graph);
        if (type.isAbstract()) {
            graph.deleteVertex(this);
            throw new GraphException("Cannot create instances of abstract type " + type);
        }
        this.type = type;
        if (type.hasAttributes()) {
            this.attributes = new Object[type.getAttributeCount()];
            if (!((InternalGraph)graph).isLoading()) {
                GenericGraphImpl.initializeGenericAttributeValues(this);
            }
        }
    }

    @Override
    public VertexClass getAttributedElementClass() {
        return this.type;
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException, NoSuchAttributeException {
        int i = this.type.getAttributeIndex(attributeName);
        this.attributes[i] = this.type.getAttribute(attributeName).getDomain().parseGenericAttribute(GraphIO.createStringReader(value, this.getSchema()));
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        for (Attribute a : this.type.getAttributeList()) {
            this.attributes[this.type.getAttributeIndex((String)a.getName())] = a.getDomain().parseGenericAttribute(io);
        }
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException, NoSuchAttributeException {
        GraphIO io = GraphIO.createStringWriter(this.getSchema());
        this.type.getAttribute(attributeName).getDomain().serializeGenericAttribute(io, this.getAttribute(attributeName));
        return io.getStringWriterResult();
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws IOException, GraphIOException {
        for (Attribute a : this.type.getAttributeList()) {
            a.getDomain().serializeGenericAttribute(io, this.getAttribute(a.getName()));
        }
    }

    @Override
    public <T> T getAttribute(String name) {
        int i = this.type.getAttributeIndex(name);
        return (T)this.attributes[i];
    }

    @Override
    public <T> void setAttribute(String name, T data) {
        int i = this.type.getAttributeIndex(name);
        if (this.getAttributedElementClass().getAttribute(name).getDomain().isConformValue(data)) {
            if (this.graph.hasECARuleManager()) {
                T oldValue = this.getAttribute(name);
                this.graph.getECARuleManager().fireBeforeChangeAttributeEvents(this, name, oldValue, data);
                this.attributes[i] = data;
                this.graph.getECARuleManager().fireAfterChangeAttributeEvents(this, name, oldValue, data);
            } else {
                this.attributes[i] = data;
            }
        } else {
            Domain d = this.type.getAttribute(name).getDomain();
            throw new ClassCastException("Expected " + (d instanceof RecordDomain ? RecordImpl.class.getName() : d.getJavaAttributeImplementationTypeName(d.getPackageName())) + " object, but received " + data == null ? data.getClass().getName() + " object instead" : data + " instead");
        }
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        GenericGraphImpl.initializeGenericAttributeValues(this);
    }

    @Override
    public boolean isInstanceOf(VertexClass cls) {
        return this.type == cls || this.type.isSubClassOf(cls);
    }

    @Override
    public void invokeOnAttributesArray(InternalAttributesArrayAccess.OnAttributesFunction fn) {
        this.attributes = fn.invoke(this, this.attributes);
    }

    @Override
    public Class<? extends Vertex> getSchemaClass() {
        throw new UnsupportedOperationException("This method is not supported by the generic implementation");
    }
}

