/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.GraphFactoryImpl;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.generic.GenericEdgeImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericVertexImpl;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class GenericGraphFactoryImpl
extends GraphFactoryImpl {
    public GenericGraphFactoryImpl(Schema s) {
        super(s, ImplementationType.GENERIC);
    }

    @Override
    public void setGraphImplementationClass(GraphClass gc, Class<? extends Graph> implementationClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVertexImplementationClass(VertexClass vc, Class<? extends Vertex> implementationClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEdgeImplementationClass(EdgeClass ec, Class<? extends Edge> implementationClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <G extends Graph> G createGraph(GraphClass gc, String id, int vMax, int eMax) {
        if (this.schema != gc.getSchema()) {
            throw new GraphException(gc + " is not in schema " + this.schema);
        }
        GenericGraphImpl graph = new GenericGraphImpl(gc, id, vMax, eMax);
        graph.setGraphFactory(this);
        return (G)graph;
    }

    @Override
    public <V extends Vertex> V createVertex(VertexClass vc, int id, Graph g) {
        if (this.schema != vc.getSchema()) {
            throw new GraphException(vc + " is not in schema " + this.schema);
        }
        if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
            g.getECARuleManager().fireBeforeCreateVertexEvents(vc);
        }
        GenericVertexImpl vertex = new GenericVertexImpl(vc, id, g);
        if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
            g.getECARuleManager().fireAfterCreateVertexEvents(vertex);
        }
        return (V)vertex;
    }

    @Override
    public <E extends Edge> E createEdge(EdgeClass ec, int id, Graph g, Vertex alpha, Vertex omega) {
        if (this.schema != ec.getSchema()) {
            throw new GraphException(ec + " is not in schema " + this.schema);
        }
        if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
            g.getECARuleManager().fireBeforeCreateEdgeEvents(ec);
        }
        GenericEdgeImpl edge = new GenericEdgeImpl(ec, id, g, alpha, omega);
        if (!((InternalGraph)g).isLoading() && g.hasECARuleManager()) {
            g.getECARuleManager().fireAfterCreateEdgeEvents(edge);
        }
        return (E)edge;
    }
}

