/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.pcollections.ArrayPSet;
import org.pcollections.PMap;

public class RecordImpl
implements Record {
    private PMap<String, Object> entries;
    private static RecordImpl empty = new RecordImpl();

    private RecordImpl() {
        this.entries = JGraLab.map();
    }

    private RecordImpl(PMap<String, Object> m) {
        this.entries = m;
    }

    public static RecordImpl empty() {
        return empty;
    }

    public RecordImpl plus(String name, Object value) {
        return new RecordImpl(this.entries.plus(name, value != null ? value : NullValue.NULL));
    }

    @Override
    public Object getComponent(String name) {
        if (this.entries.containsKey(name)) {
            return this.entries.get(name).equals((Object)NullValue.NULL) ? null : this.entries.get(name);
        }
        throw new NoSuchAttributeException("Record doesn't contain a component '" + name + "'");
    }

    @Override
    public void writeComponentValues(GraphIO io) throws IOException, GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasComponent(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public List<String> getComponentNames() {
        return ((ArrayPSet)this.entries.keySet()).toPVector();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public int hashCode() {
        int h = 0;
        for (Object v : this.entries.values()) {
            h += v.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof RecordImpl) {
            return this.entries.equals(((RecordImpl)obj).entries);
        }
        if (obj instanceof Record) {
            Record r = (Record)obj;
            if (this.size() != r.size()) {
                return false;
            }
            try {
                Iterator v = this.entries.values().iterator();
                for (String k : this.entries.keySet()) {
                    if (r.getComponent(k).equals(v.next())) continue;
                    return false;
                }
                return true;
            }
            catch (NoSuchAttributeException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public PMap<String, Object> toPMap() {
        return this.entries;
    }

    private static enum NullValue {
        NULL;

    }
}

