/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IncidenceIterable<E extends Edge>
implements Iterable<E> {
    Vertex v;
    EdgeClass ec;
    EdgeDirection orientation;

    public IncidenceIterable(Vertex v) {
        this(v, null, EdgeDirection.INOUT);
    }

    public IncidenceIterable(Vertex v, EdgeDirection orientation) {
        this(v, null, orientation);
    }

    public IncidenceIterable(Vertex v, EdgeClass ec) {
        this(v, ec, EdgeDirection.INOUT);
    }

    public IncidenceIterable(Vertex v, EdgeClass ec, EdgeDirection orientation) {
        assert (v != null && v.isValid());
        this.v = v;
        this.ec = ec;
        this.orientation = orientation;
    }

    @Override
    public Iterator<E> iterator() {
        return new IncidenceIterator((InternalVertex)this.v, this.ec, this.orientation);
    }

    class IncidenceIterator
    implements Iterator<E> {
        protected E current = null;
        protected InternalVertex vertex = null;
        protected EdgeClass schemaEc;
        protected EdgeDirection dir;
        protected long incidenceListVersion;

        public IncidenceIterator(InternalVertex vertex, EdgeClass ec, EdgeDirection dir) {
            this.vertex = vertex;
            this.schemaEc = ec;
            this.dir = dir;
            this.incidenceListVersion = vertex.getIncidenceListVersion();
            this.current = ec == null ? vertex.getFirstIncidence(dir) : vertex.getFirstIncidence(ec, dir);
        }

        @Override
        public E next() {
            if (this.vertex.isIncidenceListModified(this.incidenceListVersion)) {
                throw new ConcurrentModificationException("The incidence list of the vertex has been modified - the iterator is not longer valid");
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object result = this.current;
            this.current = this.schemaEc == null ? this.current.getNextIncidence(this.dir) : this.current.getNextIncidence(this.schemaEc, this.dir);
            return result;
        }

        @Override
        public boolean hasNext() {
            if (this.vertex.isIncidenceListModified(this.incidenceListVersion)) {
                throw new ConcurrentModificationException("The incidence list of the vertex has been modified - the iterator is not longer valid");
            }
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove Edges using Iterator");
        }
    }
}

