/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.IncidenceImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class EdgeBaseImpl
extends IncidenceImpl
implements Edge,
InternalEdge {
    protected final ReversedEdgeBaseImpl reversedEdge;

    protected EdgeBaseImpl(int anId, Graph graph, Vertex alpha, Vertex omega) {
        super(graph);
        this.setId(anId);
        this.reversedEdge = this.createReversedEdge();
    }

    @Override
    public final int compareTo(AttributedElement<EdgeClass, Edge> a) {
        assert (a != null);
        assert (a instanceof Edge);
        if (this == a) {
            return 0;
        }
        Edge e = (Edge)a;
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        if (e == this.getReversedEdge()) {
            return -1;
        }
        int x = Math.abs(this.getId()) - Math.abs(e.getId());
        if (x != 0) {
            return x;
        }
        return this.getGraph().compareTo(e.getGraph());
    }

    @Override
    public final void delete() {
        assert (this.isValid());
        this.graph.deleteEdge(this);
    }

    @Override
    public Vertex getAlpha() {
        assert (this.isValid());
        return this.getIncidentVertex();
    }

    @Override
    public final Edge getNextEdge() {
        InternalEdge nextEdge;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && nextEdge != null && !tc.containsEdge(nextEdge)) {
            for (nextEdge = this.getNextEdgeInESeq(); nextEdge != null && !tc.containsEdge(nextEdge); nextEdge = nextEdge.getNextEdgeInESeq()) {
            }
        }
        return nextEdge;
    }

    @Override
    public final Edge getPrevEdge() {
        InternalEdge prevEdge;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && prevEdge != null && !tc.containsEdge(prevEdge)) {
            for (prevEdge = this.getPrevEdgeInESeq(); prevEdge != null && !tc.containsEdge(prevEdge); prevEdge = prevEdge.getPrevEdgeInESeq()) {
            }
        }
        return prevEdge;
    }

    @Override
    public final Edge getNextEdge(EdgeClass anEdgeClass) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        for (Edge currentEdge = this.getNextEdge(); currentEdge != null; currentEdge = currentEdge.getNextEdge()) {
            if (!currentEdge.isInstanceOf(anEdgeClass)) continue;
            return currentEdge;
        }
        return null;
    }

    @Override
    public final Edge getNormalEdge() {
        return this;
    }

    @Override
    public Vertex getOmega() {
        assert (this.isValid());
        return this.reversedEdge.getIncidentVertex();
    }

    @Override
    public final Edge getReversedEdge() {
        return this.reversedEdge;
    }

    @Override
    public final Vertex getThat() {
        assert (this.isValid());
        return this.getOmega();
    }

    @Override
    public final String getThatRole() {
        assert (this.isValid());
        return this.getAttributedElementClass().getTo().getRolename();
    }

    @Override
    public final Vertex getThis() {
        assert (this.isValid());
        return this.getAlpha();
    }

    @Override
    public final String getThisRole() {
        assert (this.isValid());
        return this.getAttributedElementClass().getFrom().getRolename();
    }

    @Override
    public final boolean isAfterEdge(Edge e) {
        InternalEdge p;
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        if ((e = e.getNormalEdge()) == this) {
            return false;
        }
        for (p = this.getPrevEdgeInESeq(); p != null && p != e; p = p.getPrevEdgeInESeq()) {
        }
        return p != null;
    }

    @Override
    public final boolean isBeforeEdge(Edge e) {
        InternalEdge n;
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        if ((e = e.getNormalEdge()) == this) {
            return false;
        }
        for (n = this.getNextEdgeInESeq(); n != null && n != e; n = n.getNextEdgeInESeq()) {
        }
        return n != null;
    }

    @Override
    public final boolean isNormal() {
        return true;
    }

    @Override
    public final void putAfterEdge(Edge e) {
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (e != this);
        assert (e != this.reversedEdge);
        this.graph.putEdgeAfterInGraph((InternalEdge)e.getNormalEdge(), this);
    }

    @Override
    public final void putBeforeEdge(Edge e) {
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (e != this);
        assert (e != this.reversedEdge);
        this.graph.putEdgeBeforeInGraph((InternalEdge)e.getNormalEdge(), this);
    }

    @Override
    public final void setAlpha(Vertex alpha) {
        InternalVertex alphaBase = (InternalVertex)alpha;
        assert (this.isValid());
        assert (alphaBase != null);
        assert (alphaBase.isValid());
        assert (this.getGraph() == alphaBase.getGraph());
        InternalVertex oldAlpha = this.getIncidentVertex();
        if (!this.graph.isLoading() && this.graph.hasECARuleManager()) {
            this.graph.getECARuleManager().fireBeforeChangeAlphaOfEdgeEvents(this, oldAlpha, alphaBase);
        }
        if (alphaBase == oldAlpha) {
            return;
        }
        if (!alphaBase.getAttributedElementClass().isValidFromFor((EdgeClass)this.getAttributedElementClass())) {
            throw new GraphException("Edges of class " + this.getAttributedElementClass().getUniqueName() + " may not start at vertices of class " + alphaBase.getAttributedElementClass().getUniqueName());
        }
        oldAlpha.removeIncidenceFromISeq(this);
        oldAlpha.incidenceListModified();
        InternalVertex newAlpha = alphaBase;
        newAlpha.appendIncidenceToISeq(this);
        newAlpha.incidenceListModified();
        this.setIncidentVertex(newAlpha);
        if (!this.graph.isLoading() && this.graph.hasECARuleManager()) {
            this.graph.getECARuleManager().fireAfterChangeAlphaOfEdgeEvents(this, oldAlpha, alphaBase);
        }
    }

    @Override
    public final void setOmega(Vertex omega) {
        InternalVertex omegaBase = (InternalVertex)omega;
        assert (this.isValid());
        assert (omegaBase != null);
        assert (omegaBase.isValid());
        assert (this.getGraph() == omegaBase.getGraph());
        InternalVertex oldOmgea = this.reversedEdge.getIncidentVertex();
        if (!this.graph.isLoading() && this.graph.hasECARuleManager()) {
            this.graph.getECARuleManager().fireBeforeChangeOmegaOfEdgeEvents(this, oldOmgea, omegaBase);
        }
        if (omegaBase == oldOmgea) {
            return;
        }
        if (!omegaBase.getAttributedElementClass().isValidToFor((EdgeClass)this.getAttributedElementClass())) {
            throw new GraphException("Edges of class " + this.getAttributedElementClass().getUniqueName() + " may not end at at vertices of class " + omegaBase.getAttributedElementClass().getUniqueName());
        }
        oldOmgea.removeIncidenceFromISeq(this.reversedEdge);
        oldOmgea.incidenceListModified();
        InternalVertex newOmega = omegaBase;
        newOmega.appendIncidenceToISeq(this.reversedEdge);
        newOmega.incidenceListModified();
        this.reversedEdge.setIncidentVertex(newOmega);
        if (!this.graph.isLoading()) {
            this.graph.getECARuleManager().fireAfterChangeOmegaOfEdgeEvents(this, oldOmgea, omegaBase);
        }
    }

    @Override
    public final void setThat(Vertex v) {
        assert (this.isValid());
        assert (v != null);
        assert (v.isValid());
        assert (this.getGraph() == v.getGraph());
        this.setOmega(v);
    }

    @Override
    public final void setThis(Vertex v) {
        assert (this.isValid());
        assert (v != null);
        assert (v.isValid());
        assert (this.getGraph() == v.getGraph());
        this.setAlpha(v);
    }

    public String toString() {
        return "+e" + this.id + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public final boolean isValid() {
        return this.graph.eSeqContainsEdge(this);
    }

    @Override
    public final AggregationKind getThisAggregationKind() {
        assert (this.isValid());
        return this.getAlphaAggregationKind();
    }

    @Override
    public final AggregationKind getThatAggregationKind() {
        assert (this.isValid());
        return this.getOmegaAggregationKind();
    }

    protected abstract ReversedEdgeBaseImpl createReversedEdge();
}

