/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.grumlschema.impl.std.structure;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConstraintImpl
extends VertexImpl
implements Vertex,
Constraint {
    protected String _message;
    protected String _offendingElementsQuery;
    protected String _predicateQuery;

    public ConstraintImpl(int id, Graph g) {
        super(id, g);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Constraint.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Constraint.class;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        if (attributeName.equals("message")) {
            return (T)this.get_message();
        }
        if (attributeName.equals("offendingElementsQuery")) {
            return (T)this.get_offendingElementsQuery();
        }
        if (attributeName.equals("predicateQuery")) {
            return (T)this.get_predicateQuery();
        }
        throw new NoSuchAttributeException("structure.Constraint doesn't contain an attribute " + attributeName);
    }

    @Override
    public <T> void setAttribute(String attributeName, T data) {
        if (attributeName.equals("message")) {
            this.set_message((String)data);
            return;
        }
        if (attributeName.equals("offendingElementsQuery")) {
            this.set_offendingElementsQuery((String)data);
            return;
        }
        if (attributeName.equals("predicateQuery")) {
            this.set_predicateQuery((String)data);
            return;
        }
        throw new NoSuchAttributeException("structure.Constraint doesn't contain an attribute " + attributeName);
    }

    @Override
    public String get_message() {
        return this._message;
    }

    @Override
    public void set_message(String _message) {
        this.ecaAttributeChanging("message", this._message, _message);
        String oldValue = this._message;
        this._message = _message;
        this.graphModified();
        this.ecaAttributeChanged("message", oldValue, _message);
    }

    @Override
    public String get_offendingElementsQuery() {
        return this._offendingElementsQuery;
    }

    @Override
    public void set_offendingElementsQuery(String _offendingElementsQuery) {
        this.ecaAttributeChanging("offendingElementsQuery", this._offendingElementsQuery, _offendingElementsQuery);
        String oldValue = this._offendingElementsQuery;
        this._offendingElementsQuery = _offendingElementsQuery;
        this.graphModified();
        this.ecaAttributeChanged("offendingElementsQuery", oldValue, _offendingElementsQuery);
    }

    @Override
    public String get_predicateQuery() {
        return this._predicateQuery;
    }

    @Override
    public void set_predicateQuery(String _predicateQuery) {
        this.ecaAttributeChanging("predicateQuery", this._predicateQuery, _predicateQuery);
        String oldValue = this._predicateQuery;
        this._predicateQuery = _predicateQuery;
        this.graphModified();
        this.ecaAttributeChanged("predicateQuery", oldValue, _predicateQuery);
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        this._message = io.matchUtfString();
        this.set_message(this._message);
        this._offendingElementsQuery = io.matchUtfString();
        this.set_offendingElementsQuery(this._offendingElementsQuery);
        this._predicateQuery = io.matchUtfString();
        this.set_predicateQuery(this._predicateQuery);
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {
        if (attributeName.equals("message")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._message = io.matchUtfString();
            this.set_message(this._message);
            return;
        }
        if (attributeName.equals("offendingElementsQuery")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._offendingElementsQuery = io.matchUtfString();
            this.set_offendingElementsQuery(this._offendingElementsQuery);
            return;
        }
        if (attributeName.equals("predicateQuery")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._predicateQuery = io.matchUtfString();
            this.set_predicateQuery(this._predicateQuery);
            return;
        }
        throw new NoSuchAttributeException("structure.Constraint doesn't contain an attribute " + attributeName);
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {
        io.space();
        io.writeUtfString(this._message);
        io.writeUtfString(this._offendingElementsQuery);
        io.writeUtfString(this._predicateQuery);
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {
        if (attributeName.equals("message")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._message);
            return io.getStringWriterResult();
        }
        if (attributeName.equals("offendingElementsQuery")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._offendingElementsQuery);
            return io.getStringWriterResult();
        }
        if (attributeName.equals("predicateQuery")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._predicateQuery);
            return io.getStringWriterResult();
        }
        throw new NoSuchAttributeException("structure.Constraint doesn't contain an attribute " + attributeName);
    }

    @Override
    public Constraint getNextConstraint() {
        return (Constraint)this.getNextVertex(Constraint.VC);
    }

    @Override
    public HasConstraint getFirstHasConstraintIncidence() {
        return (HasConstraint)this.getFirstIncidence(HasConstraint.EC);
    }

    @Override
    public HasConstraint getFirstHasConstraintIncidence(EdgeDirection orientation) {
        return (HasConstraint)this.getFirstIncidence(HasConstraint.EC, orientation);
    }

    @Override
    public HasConstraint add_constrainedelement(AttributedElementClass vertex) {
        return (HasConstraint)((SchemaGraph)this.getGraph()).createEdge(HasConstraint.EC, vertex, this);
    }

    @Override
    public List<? extends AttributedElementClass> remove_constrainedelement() {
        ArrayList<AttributedElementClass> adjacences = new ArrayList<AttributedElementClass>();
        HasConstraint edge = (HasConstraint)this.getFirstIncidence(HasConstraint.EC, EdgeDirection.IN);
        while (edge != null) {
            HasConstraint next = (HasConstraint)edge.getNextIncidence(HasConstraint.EC, EdgeDirection.IN);
            adjacences.add((AttributedElementClass)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_constrainedelement(AttributedElementClass vertex) {
        boolean elementRemoved = false;
        HasConstraint edge = (HasConstraint)this.getFirstIncidence(HasConstraint.EC, EdgeDirection.IN);
        while (edge != null) {
            HasConstraint next = (HasConstraint)edge.getNextIncidence(HasConstraint.EC, EdgeDirection.IN);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public AttributedElementClass get_constrainedelement() {
        HasConstraint edge = (HasConstraint)this.getFirstIncidence(HasConstraint.EC, EdgeDirection.IN);
        if (edge != null) {
            return (AttributedElementClass)edge.getThat();
        }
        return null;
    }

    @Override
    public Iterable<HasConstraint> getHasConstraintIncidences() {
        return new IncidenceIterable<HasConstraint>((Vertex)this, HasConstraint.EC);
    }

    @Override
    public Iterable<HasConstraint> getHasConstraintIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasConstraint>(this, HasConstraint.EC, direction);
    }
}

