/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.template.TemplateSchema;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class GReTLRunner {
    static final int MAX_VISUALIZATION_SIZE = Integer.parseInt(System.getProperty("GretlMaxVizSize", "400"));
    private OptionHandler oh = null;

    public GReTLRunner() {
        String toolString = "java " + GReTLRunner.class.getName();
        String versionString = JGraLab.getInfo(false);
        this.oh = new OptionHandler(toolString, versionString);
        Option transform = new Option("t", "transformation", true, "(required) The GReTL transformation that should be executed.");
        transform.setArgName("gretl-file");
        transform.setRequired(true);
        this.oh.addOption(transform);
        Option schema = new Option("s", "schema", true, "(optional) The name of the target schema. Defaults to foo.bar.BazSchema.");
        schema.setArgName("schema-name");
        schema.setRequired(false);
        this.oh.addOption(schema);
        Option graphclass = new Option("g", "graphclass", true, "(optional) The name of the target graph class. Defaults to BazGraph.");
        graphclass.setArgName("graphclass");
        graphclass.setRequired(false);
        this.oh.addOption(graphclass);
        Option viz = new Option("z", "visualize", false, "(optional) Additionally create a PDF viz of the output graph.");
        viz.setRequired(false);
        this.oh.addOption(viz);
        Option reverseViz = new Option("r", "reverse-edges", false, "(optional) When -z is given, print edges pointing bottom-up.");
        reverseViz.setRequired(false);
        this.oh.addOption(reverseViz);
        Option debugExecution = new Option("d", "debug", false, "(optional) Print the target graph after each transformation op.");
        debugExecution.setRequired(false);
        this.oh.addOption(debugExecution);
        Option output = new Option("o", "output", true, "(optional) The file to store the target graph to.  If many input models are to be transformed, this has no effect.");
        output.setRequired(false);
        debugExecution.setArgName("target-graph-file");
        this.oh.addOption(output);
        Option useSourceSchema = new Option("u", "use-source-schema", false, "(optional) Use the source schema as target schema. In that case, no schema modifications may be performed by the transformation.");
        useSourceSchema.setRequired(false);
        this.oh.addOption(useSourceSchema);
        Option inPlace = new Option("i", "in-place", false, "(optional) Use the source graph as target graph. In that case, no schema modifications may be performed by the transformation.");
        inPlace.setRequired(false);
        this.oh.addOption(inPlace);
        this.oh.setArgumentCount(-2);
        this.oh.setArgumentName("input-graph");
        this.oh.setOptionalArgument(false);
    }

    public void exec(String[] args) throws GraphIOException, IOException {
        CommandLine cli = this.oh.parse(args);
        if (cli.hasOption('d')) {
            Transformation.DEBUG_EXECUTION = true;
            Transformation.DEBUG_REVERSE_EDGES = cli.hasOption('r');
        }
        String schema = cli.hasOption('s') ? cli.getOptionValue('s') : "foo.bar.BazSchema";
        String graphclass = cli.hasOption('g') ? cli.getOptionValue('g') : "BazGraph";
        Schema targetSchema = this.getExistingSchema(schema);
        Context c = targetSchema != null ? new Context(targetSchema) : new Context(schema, graphclass);
        if (cli.getArgs().length == 0) {
            if (cli.hasOption('u') || cli.hasOption('i')) {
                System.err.println("Options -u and -i cannot be used if no source graph is given.");
                this.oh.printHelpAndExit(1);
            }
            Graph outGraph = this.executeTransformation(c, new File(cli.getOptionValue('t')));
            String outFileName = null;
            outFileName = cli.hasOption('o') ? cli.getOptionValue('o') : "target_graph.tg";
            this.saveTargetGraph(outGraph, outFileName, cli);
        } else {
            for (String in : cli.getArgs()) {
                Graph inGraph = GraphIO.loadGraphFromFile(in, ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction("Loading"));
                if (cli.hasOption('u')) {
                    c = new Context(inGraph.getSchema());
                } else if (cli.hasOption('i')) {
                    c = new Context(inGraph.getSchema());
                    c.setTargetGraph(inGraph);
                }
                c.setSourceGraph(inGraph);
                Graph outGraph = this.executeTransformation(c, new File(cli.getOptionValue('t')));
                String outFileName = null;
                if (cli.hasOption('o') && cli.getArgs().length == 1) {
                    outFileName = cli.getOptionValue('o');
                } else {
                    File inFile = new File(in);
                    outFileName = inFile.getParent() + File.separator + "target_" + inFile.getName();
                }
                this.saveTargetGraph(outGraph, outFileName, cli);
            }
        }
        System.out.println("Fini.");
    }

    private Graph executeTransformation(Context c, File transFormFile) {
        ExecuteTransformation t = new ExecuteTransformation(c, transFormFile);
        boolean outermost = c.outermost;
        if (outermost) {
            System.out.print("Executing transformation " + t.getName() + "... ");
        }
        long startTime = System.currentTimeMillis();
        Graph outGraph = (Graph)t.execute();
        if (outermost) {
            System.out.println("Finished (" + (System.currentTimeMillis() - startTime) + "ms)");
        }
        return outGraph;
    }

    private Schema getExistingSchema(String qname) {
        try {
            Class<?> schemaClass = Class.forName(qname);
            Method m = schemaClass.getMethod("instance", new Class[0]);
            return (Schema)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveTargetGraph(Graph outGraph, String outFileName, CommandLine cli) throws GraphIOException, IOException {
        GraphIO.saveGraphToFile(outGraph, outFileName, (ProgressFunction)new ConsoleProgressFunction("Saving"));
        if (cli.hasOption('z')) {
            if (outGraph.getVCount() + outGraph.getECount() > MAX_VISUALIZATION_SIZE) {
                System.err.println("Sorry, graph is too big to be dotted.");
            } else {
                String pdf = outFileName.replaceFirst("\\.tg(\\.gz)?$", ".pdf");
                Tg2Dot.convertGraph(outGraph, pdf, cli.hasOption('r'), GraphVizOutputFormat.PDF);
            }
        }
    }

    public static void main(String[] args) throws GraphIOException, IOException {
        GReTLRunner runner = new GReTLRunner();
        runner.exec(args);
    }

    static {
        JGraLab.setLogLevel(Level.OFF);
        GreqlSchema.instance().createGraph(ImplementationType.STANDARD);
        GreqlQuery.createQuery("from x: list(1..10) with x = 5 reportSet x end").evaluate();
        TemplateSchema.instance().createGraph(ImplementationType.STANDARD);
    }
}

