/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.AddSubClass;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class AddSubClasses
extends Transformation<GraphElementClass<?, ?>> {
    private GraphElementClass<?, ?> superClass;
    private GraphElementClass<?, ?>[] subClasses;

    public AddSubClasses(Context c, VertexClass superClass, VertexClass ... subClasses) {
        super(c);
        this.superClass = superClass;
        this.subClasses = subClasses;
        if (subClasses.length < 1) {
            throw new GReTLException(c, "No subclasses given!");
        }
    }

    public AddSubClasses(Context c, EdgeClass superClass, EdgeClass ... subClasses) {
        super(c);
        this.superClass = superClass;
        this.subClasses = subClasses;
        if (subClasses.length < 1) {
            throw new GReTLException(c, "No subclasses given!");
        }
    }

    public static AddSubClasses parseAndCreate(ExecuteTransformation et) {
        GraphElementClass<?, ?> superGec = et.matchGraphElementClass();
        if (superGec instanceof VertexClass) {
            VertexClass[] subVCs = et.matchVertexClassArray();
            return new AddSubClasses(et.context, (VertexClass)superGec, subVCs);
        }
        EdgeClass[] subECs = et.matchEdgeClassArray();
        return new AddSubClasses(et.context, (EdgeClass)superGec, subECs);
    }

    @Override
    protected GraphElementClass<?, ?> transform() {
        for (GraphElementClass<?, ?> sub : this.subClasses) {
            if (this.superClass instanceof VertexClass) {
                new AddSubClass(this.context, (VertexClass)this.superClass, (VertexClass)sub).execute();
                continue;
            }
            new AddSubClass(this.context, (EdgeClass)this.superClass, (EdgeClass)sub).execute();
        }
        return this.superClass;
    }
}

