/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class Types {
    private static final Class<?>[] GREQL_TYPES = new Class[]{Integer.class, Long.class, Boolean.class, Double.class, Number.class, String.class, Vertex.class, Edge.class, Graph.class, AttributedElement.class, GraphElement.class, Path.class, PathSystem.class, TypeCollection.class, Enum.class, Record.class, Table.class, Tuple.class, PVector.class, PSet.class, POrderedSet.class, PCollection.class, PMap.class, AttributedElementClass.class, FiniteAutomaton.class, TraversalContext.class, Undefined.class, InternalGreqlEvaluator.class};
    private static final HashMap<Class<?>, String> typeNames = new HashMap();
    private static final HashSet<Class<?>> types = new HashSet();

    private Types() {
    }

    public static final boolean isValidGreqlValue(Object value) {
        if (value == null) {
            return true;
        }
        for (Class<?> cls : GREQL_TYPES) {
            if (!cls.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public static String[] getGreqlTypeNames() {
        String[] names = new String[typeNames.size()];
        int i = 0;
        Iterator<String> i$ = typeNames.values().iterator();
        while (i$.hasNext()) {
            String n;
            names[i] = n = i$.next();
            ++i;
        }
        return names;
    }

    public static final String getGreqlTypeName(Object value) {
        if (value == null) {
            value = Undefined.UNDEFINED;
        }
        for (Class<?> cls : GREQL_TYPES) {
            if (!cls.isInstance(value)) continue;
            return typeNames.get(cls);
        }
        return value.getClass().getSimpleName() + " [unknown to GReQL]";
    }

    public static final String getGreqlTypeName(Class<?> cls) {
        String tn = typeNames.get(cls);
        if (tn != null) {
            return tn;
        }
        return cls.getSimpleName();
    }

    public static final PVector<?> toPVector(Object o) {
        if (o instanceof ArrayPVector) {
            return (PVector)o;
        }
        if (o instanceof ArrayPSet) {
            return ((ArrayPSet)o).toPVector();
        }
        if (o instanceof Tuple) {
            return ((Tuple)o).toPVector();
        }
        if (o instanceof Collection) {
            return JGraLab.vector().plusAll((Collection)o);
        }
        throw new GreqlException("Can't convert object of type " + o.getClass().getName() + " to org.pcollections.PVector<?>");
    }

    static {
        for (Class<?> cls : GREQL_TYPES) {
            typeNames.put(cls, cls.getSimpleName());
            types.add(cls);
        }
        typeNames.put(PVector.class, "List");
        typeNames.put(PSet.class, "Set");
        typeNames.put(POrderedSet.class, "Set");
        typeNames.put(PMap.class, "Map");
        typeNames.put(PCollection.class, "Collection");
        typeNames.put(FiniteAutomaton.class, "PathDescription");
    }
}

