/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.ist.utilities.xml.IndentingXMLStreamWriter;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.serialising.XMLConstants;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class XMLOutputWriter
extends DefaultWriter
implements XMLConstants {
    private IndentingXMLStreamWriter writer = null;

    public XMLOutputWriter() {
        this(null);
    }

    public XMLOutputWriter(Graph g) {
        super(g);
    }

    public void writeValue(Object value, File file) throws XMLStreamException {
        try {
            this.writer = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"), "\t");
            this.writeValue(value);
        }
        catch (FactoryConfigurationError e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new XMLStreamException(e);
        }
        catch (SerialisingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialisingException("Unhandled Exception", this.rootValue, e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException("An exception occured while closing the stream", ex);
            }
        }
    }

    @Override
    protected void write(Object o) throws XMLStreamException {
        try {
            super.write(o);
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (SerialisingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
    }

    @Override
    protected void head() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("object");
        if (this.getGraph() != null) {
            this.writer.writeAttribute("graphId", this.getGraph().getId());
        }
    }

    @Override
    protected void foot() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.writeCharacters("\n");
        this.writer.flush();
    }

    @Override
    protected void writeAttributedElementClass(AttributedElementClass<?, ?> aec) throws XMLStreamException {
        this.writer.writeEmptyElement("attributedElementClass");
        this.writer.writeAttribute("name", aec.getQualifiedName());
        this.writer.writeAttribute("schema", aec.getSchema().getQualifiedName());
    }

    @Override
    protected void writeBoolean(Boolean b) throws XMLStreamException {
        this.writer.writeEmptyElement("boolean");
        this.writer.writeAttribute("value", b.toString());
    }

    @Override
    protected void writeDouble(Double n) throws XMLStreamException {
        this.writer.writeEmptyElement("double");
        this.writer.writeAttribute("value", n.toString());
    }

    @Override
    protected void writeEdge(Edge edge) throws XMLStreamException {
        this.writer.writeEmptyElement("edge");
        this.writer.writeAttribute("id", Integer.toString(edge.getId()));
        if (edge.getGraph() != this.getGraph()) {
            this.writer.writeAttribute("graphId", String.valueOf(edge.getGraph().getId()));
        }
    }

    @Override
    protected void writeEnum(Enum<?> val) throws XMLStreamException {
        this.writer.writeEmptyElement("enum");
        this.writer.writeAttribute("value", val.name());
        this.writer.writeAttribute("type", val.getDeclaringClass().getCanonicalName());
    }

    @Override
    protected void writeGraph(Graph graph) throws XMLStreamException {
        this.writer.writeEmptyElement("graph");
        this.writer.writeAttribute("graphId", graph.getId());
    }

    @Override
    protected void writeInteger(Integer n) throws XMLStreamException {
        this.writer.writeEmptyElement("integer");
        this.writer.writeAttribute("value", n.toString());
    }

    @Override
    protected void writePVector(PVector<?> l) throws XMLStreamException {
        this.writer.writeStartElement("list");
        for (Object o : l) {
            this.write(o);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeLong(Long l) throws XMLStreamException {
        this.writer.writeEmptyElement("long");
        this.writer.writeAttribute("value", l.toString());
    }

    @Override
    protected void writePMap(PMap<?, ?> m) throws XMLStreamException {
        this.writer.writeStartElement("map");
        for (Map.Entry e : m.entrySet()) {
            this.writer.writeStartElement("entry");
            this.write(e.getKey());
            this.write(e.getValue());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeRecord(Record r) throws XMLStreamException {
        this.writer.writeStartElement("record");
        for (String component : r.getComponentNames()) {
            this.writer.writeStartElement("comp");
            this.writer.writeAttribute("name", component);
            this.write(r.getComponent(component));
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writePSet(PSet<?> s) throws XMLStreamException {
        this.writer.writeStartElement("set");
        try {
            super.writePSet(s);
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeString(String s) throws XMLStreamException {
        this.writer.writeEmptyElement("string");
        this.writer.writeAttribute("value", s.toString());
    }

    @Override
    protected void writeTuple(Tuple t) throws XMLStreamException {
        this.writer.writeStartElement("tup");
        try {
            super.writeTuple(t);
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeVertex(Vertex vertex) throws XMLStreamException {
        this.writer.writeEmptyElement("vertex");
        this.writer.writeAttribute("id", String.valueOf(vertex.getId()));
        if (vertex.getGraph() != this.getGraph()) {
            this.writer.writeAttribute("graphId", String.valueOf(vertex.getGraph().getId()));
        }
    }

    @Override
    protected void writeTable(Table<?> t) throws XMLStreamException {
        this.writer.writeStartElement("table");
        try {
            super.writeTable(t);
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writePath(Path p) throws XMLStreamException {
        this.writer.writeStartElement("path");
        this.write(p.getVertexTrace());
        this.write(p.getEdgeTrace());
        this.writer.writeEndElement();
    }

    @Override
    protected void writePathSystem(PathSystem p) throws XMLStreamException {
        this.writer.writeStartElement("pathSystem");
        this.writeNode(p, p.getRoot());
        this.writer.writeEndElement();
    }

    private void writeNode(PathSystem p, PathSystem.PathSystemNode currentNode) throws XMLStreamException {
        this.writer.writeStartElement("node");
        this.writer.writeAttribute("state", new Integer(currentNode.state).toString());
        this.writer.writeAttribute("isLeaf", new Boolean(p.isLeaf(currentNode)).toString());
        this.writeVertex(currentNode.currentVertex);
        if (currentNode.edge2parent != null) {
            this.writeEdge(currentNode.edge2parent);
        }
        for (PathSystem.PathSystemNode child : p.getChildren(currentNode)) {
            this.writeNode(p, child);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeUndefined() throws Exception {
        this.writer.writeEmptyElement("undefined");
    }
}

