/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.schema;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pcollections.PMap;

public class SourcePosition
implements Record {
    private static List<String> componentNames = new ArrayList<String>(2);
    private final int _length;
    private final int _offset;

    @Override
    public List<String> getComponentNames() {
        return componentNames;
    }

    @Override
    public boolean hasComponent(String name) {
        return componentNames.contains(name);
    }

    @Override
    public int size() {
        return 2;
    }

    public SourcePosition(int _length, int _offset) {
        this._length = _length;
        this._offset = _offset;
    }

    public SourcePosition(Map<String, Object> componentValues) {
        assert (componentValues.size() == 2);
        assert (componentValues.containsKey("length"));
        this._length = (Integer)componentValues.get("length");
        assert (componentValues.containsKey("offset"));
        this._offset = (Integer)componentValues.get("offset");
    }

    public SourcePosition(GraphIO io) throws GraphIOException {
        io.match("(");
        this._length = io.matchInteger();
        this._offset = io.matchInteger();
        io.match(")");
    }

    public int get_length() {
        return this._length;
    }

    public int get_offset() {
        return this._offset;
    }

    @Override
    public Object getComponent(String name) {
        if (name.equals("length")) {
            return this._length;
        }
        if (name.equals("offset")) {
            return this._offset;
        }
        throw new NoSuchAttributeException("SourcePosition doesn't contain an attribute " + name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lengthString = String.valueOf(this._length);
        sb.append("[").append("length").append("=").append(lengthString);
        String offsetString = String.valueOf(this._offset);
        sb.append(", ").append("offset").append("=").append(offsetString);
        return sb.append("]").toString();
    }

    @Override
    public void writeComponentValues(GraphIO io) throws IOException, GraphIOException {
        io.writeSpace();
        io.write("(");
        io.noSpace();
        io.writeInteger(this._length);
        io.writeInteger(this._offset);
        io.write(")");
    }

    @Override
    public PMap<String, Object> toPMap() {
        PMap<Object, Object> m = JGraLab.map();
        m = m.plus("length", this._length);
        m = m.plus("offset", this._offset);
        return m;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SourcePosition) {
            SourcePosition rec = (SourcePosition)o;
            if (this._length != rec._length) {
                return false;
            }
            return this._offset == rec._offset;
        }
        if (o instanceof Record) {
            Record rec = (Record)o;
            if (rec.size() != 2) {
                return false;
            }
            try {
                if (!rec.getComponent("length").equals(this._length)) {
                    return false;
                }
                return rec.getComponent("offset").equals(this._offset);
            }
            catch (NoSuchAttributeException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        h += Integer.valueOf(this._length).hashCode();
        return h += Integer.valueOf(this._offset).hashCode();
    }

    static {
        componentNames.add("length");
        componentNames.add("offset");
        componentNames = Collections.unmodifiableList(componentNames);
    }
}

