/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parallel;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.parallel.EvaluationEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluatorCallable;
import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;

public class ParallelGreqlEvaluator {
    private static Logger logger = JGraLab.getLogger(ParallelGreqlEvaluator.class);
    private DirectedAcyclicGraph<TaskHandle> dependencyGraph = new DirectedAcyclicGraph();
    private static int taskHandleSequence = 0;

    public EvaluationEnvironment evaluate() {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), false);
    }

    public EvaluationEnvironment evaluate(boolean adjustPriorityValues) {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), adjustPriorityValues);
    }

    public EvaluationEnvironment evaluate(Graph datagraph) {
        return this.evaluate(datagraph, new GreqlEnvironmentAdapter(), false, false);
    }

    public EvaluationEnvironment evaluate(Graph datagraph, boolean adjustPriorityValues) {
        return this.evaluate(datagraph, new GreqlEnvironmentAdapter(), adjustPriorityValues, false);
    }

    public EvaluationEnvironment evaluate(Graph datagraph, GreqlEnvironment greqlEnvironment) {
        return this.evaluate(datagraph, greqlEnvironment, false, false);
    }

    public EvaluationEnvironment evaluate(Graph datagraph, GreqlEnvironment greqlEnvironment, boolean adjustPriorityValues) {
        return this.evaluate(datagraph, greqlEnvironment, adjustPriorityValues, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluationEnvironment evaluate(Graph datagraph, GreqlEnvironment greqlEnvironment, boolean adjustPriorityValues, boolean sequentially) {
        final EvaluationEnvironment evaluationEnvironment = new EvaluationEnvironment(sequentially);
        evaluationEnvironment.startTime = System.nanoTime();
        evaluationEnvironment.datagraph = datagraph;
        evaluationEnvironment.greqlEnvironment = greqlEnvironment;
        SortedSet<TaskHandle> initialTasks = this.createEvaluationTasks(evaluationEnvironment);
        int threads = sequentially ? 1 : Math.max(2, Runtime.getRuntime().availableProcessors() + 1);
        logger.fine("Create executor with " + threads + " threads");
        evaluationEnvironment.executor = Executors.newFixedThreadPool(threads);
        FutureTask<Object> waitForTerminationTask = null;
        if (!sequentially) {
            waitForTerminationTask = new FutureTask<Object>((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    logger.finer("Run waiting for final tasks");
                    try {
                        for (TaskHandle handle : ParallelGreqlEvaluator.this.dependencyGraph.getNodes()) {
                            try {
                                evaluationEnvironment.tasks.get(handle).get();
                            }
                            catch (ExecutionException e) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            }){

                @Override
                protected void done() {
                    super.done();
                    logger.finer("Done waiting for final tasks");
                }
            };
            logger.finer("Execute waiting for final tasks");
            evaluationEnvironment.executor.execute(waitForTerminationTask);
        }
        for (TaskHandle handle : initialTasks) {
            logger.fine("Execute initial " + handle);
            evaluationEnvironment.executor.execute(evaluationEnvironment.tasks.get(handle));
            if (!sequentially) continue;
            try {
                evaluationEnvironment.tasks.get(handle).get();
            }
            catch (Exception e) {
                throw this.unwrapException(e);
            }
        }
        if (!sequentially) {
            try {
                waitForTerminationTask.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        evaluationEnvironment.executor.shutdown();
        EvaluationEnvironment evaluationEnvironment2 = evaluationEnvironment;
        synchronized (evaluationEnvironment2) {
            if (evaluationEnvironment.exception != null) {
                throw this.unwrapException(evaluationEnvironment.exception);
            }
        }
        if (adjustPriorityValues) {
            this.adjustPriorities(evaluationEnvironment);
        }
        evaluationEnvironment.doneTime = System.nanoTime();
        return evaluationEnvironment;
    }

    private RuntimeException unwrapException(Exception ex) {
        Throwable inner;
        for (inner = ex; inner != null && inner instanceof ExecutionException; inner = inner.getCause()) {
        }
        if (inner instanceof RuntimeException) {
            return (RuntimeException)inner;
        }
        return new RuntimeException(inner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustPriorities(EvaluationEnvironment evaluationEnvironment) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            logger.fine("Adjust priority values");
            for (TaskHandle handle : this.dependencyGraph.getNodes()) {
                long p = handle.priority;
                handle.priority = evaluationEnvironment.getEvaluationTime(handle);
                logger.finer(handle.toString() + " - old prio " + p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedSet<TaskHandle> createEvaluationTasks(EvaluationEnvironment evaluationEnvironment) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            this.calculateVariableDependencies();
            TreeSet<TaskHandle> initialTasks = new TreeSet<TaskHandle>();
            for (TaskHandle handle : this.dependencyGraph.getNodes()) {
                EvaluationTask t = handle.createFutureTask(evaluationEnvironment);
                evaluationEnvironment.tasks.put(handle, t);
                int i = this.dependencyGraph.getDirectPredecessors(handle).size();
                evaluationEnvironment.inDegree.put(handle, i);
                if (i != 0) continue;
                initialTasks.add(handle);
            }
            return initialTasks;
        }
    }

    public EvaluationEnvironment evaluateSequentially(Graph datagraph, GreqlEnvironment greqlEnvironment, boolean adjustPriorityValues) {
        return this.evaluate(datagraph, greqlEnvironment, adjustPriorityValues, true);
    }

    public TaskHandle addTask(ParallelGreqlEvaluatorCallable callable) {
        return this.addTask(callable, 0L);
    }

    public TaskHandle addTask(ParallelGreqlEvaluatorCallable callable, long priority) {
        return this.dependencyGraph.createNode(new TaskHandle(callable, priority));
    }

    public TaskHandle addGreqlQuery(String queryText) {
        return this.addGreqlQuery(queryText, 0L);
    }

    public TaskHandle addGreqlQuery(String queryText, long priority) {
        return this.addTask(GreqlQuery.createQuery(queryText), priority);
    }

    public void defineDependency(TaskHandle successor, TaskHandle predecessor) {
        try {
            this.dependencyGraph.createEdge(predecessor, successor);
        }
        catch (CycleException e) {
            throw new RuntimeException("Task dependencies are cyclic. Offending dependency: " + successor + " ---dependsOn--> " + predecessor);
        }
        catch (SchemaException e) {
            throw new RuntimeException("Task " + predecessor + " depends on itself");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateVariableDependencies() {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            if (this.dependencyGraph.isFinished()) {
                return;
            }
            HashMap<String, HashSet<TaskHandle>> definingTasks = new HashMap<String, HashSet<TaskHandle>>();
            for (TaskHandle handle : this.dependencyGraph.getNodes()) {
                Set<String> sv = handle.getStoredVariables();
                if (sv == null) continue;
                for (String var : sv) {
                    HashSet<TaskHandle> vs = (HashSet<TaskHandle>)definingTasks.get(var);
                    if (vs == null) {
                        vs = new HashSet<TaskHandle>();
                        definingTasks.put(var, vs);
                    }
                    vs.add(handle);
                }
            }
            for (TaskHandle usingTask : this.dependencyGraph.getNodes()) {
                Set<String> uv = usingTask.getUsedVariables();
                if (uv == null) continue;
                for (String var : uv) {
                    HashSet defines = (HashSet)definingTasks.get(var);
                    if (defines == null) continue;
                    for (TaskHandle def : defines) {
                        this.defineDependency(usingTask, def);
                    }
                }
            }
            this.dependencyGraph.finish();
            logger.finer(this.dependencyGraph.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext(EvaluationEnvironment environment, TaskHandle finishedTask) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            TreeSet<TaskHandle> nextTasks = new TreeSet<TaskHandle>();
            for (TaskHandle succ : this.dependencyGraph.getDirectSuccessors(finishedTask)) {
                int i = environment.inDegree.get(succ) - 1;
                environment.inDegree.put(succ, i);
                if (i != 0) continue;
                nextTasks.add(succ);
            }
            for (TaskHandle succ : nextTasks) {
                logger.fine("Execute " + succ);
                environment.executor.execute(environment.tasks.get(succ));
                if (!environment.sequentially) continue;
                try {
                    environment.tasks.get(succ).get();
                }
                catch (Exception e) {
                    throw this.unwrapException(e);
                }
            }
        }
    }

    public class TaskHandle
    implements Comparable<TaskHandle> {
        private ParallelGreqlEvaluatorCallable callable;
        private long priority;
        private int seq;

        public String toString() {
            return "TaskHandle " + this.seq + " prio " + this.priority + " (use: " + this.getUsedVariables() + ", store:" + this.getStoredVariables() + ")";
        }

        public Set<String> getStoredVariables() {
            return this.callable.getStoredVariables();
        }

        public Set<String> getUsedVariables() {
            return this.callable.getUsedVariables();
        }

        @Override
        public int compareTo(TaskHandle other) {
            long r = other.priority - this.priority;
            if (r != 0L) {
                return r < 0L ? -1 : 1;
            }
            return this.seq - other.seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TaskHandle(ParallelGreqlEvaluatorCallable callable, long priority) {
            this.callable = callable;
            this.priority = priority;
            Class<TaskHandle> clazz = TaskHandle.class;
            synchronized (TaskHandle.class) {
                this.seq = taskHandleSequence++;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        private EvaluationTask createFutureTask(final EvaluationEnvironment env) {
            return new EvaluationTask(env, this, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return TaskHandle.this.callable.call(env);
                }
            });
        }
    }

    class EvaluationTask
    extends FutureTask<Object> {
        private TaskHandle handle;
        private EvaluationEnvironment environment;
        private long startTime;
        private long doneTime;

        private EvaluationTask(EvaluationEnvironment environment, TaskHandle handle, Callable<Object> callable) {
            super(callable);
            this.environment = environment;
            this.handle = handle;
        }

        @Override
        public void run() {
            logger.finer("Run " + this + " " + this.handle);
            this.startTime = System.nanoTime();
            super.run();
        }

        long getEvaluationTime() {
            if (!this.isDone()) {
                throw new IllegalStateException("EvaluationTask is not yet done.");
            }
            return this.doneTime - this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            this.doneTime = System.nanoTime();
            super.done();
            logger.fine("Done " + this.handle + " (" + this.getEvaluationTime() + " ns)");
            if (this.environment.executor != null) {
                try {
                    this.get();
                    ParallelGreqlEvaluator.this.scheduleNext(this.environment, this.handle);
                }
                catch (InterruptedException e) {
                    this.environment.executor.shutdownNow();
                }
                catch (ExecutionException e) {
                    EvaluationEnvironment evaluationEnvironment = this.environment;
                    synchronized (evaluationEnvironment) {
                        if (this.environment.exception == null) {
                            this.environment.exception = e;
                        }
                    }
                    this.environment.executor.shutdownNow();
                }
            }
        }
    }
}

