/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import java.util.ArrayList;

public class NonConstantTerm
extends Formula {
    protected Expression expression;

    public NonConstantTerm(GreqlQuery query, Expression exp) {
        super(query);
        this.expression = exp;
    }

    @Override
    public String toString() {
        return "v" + this.expression.getId();
    }

    @Override
    public Expression toExpression() {
        return this.expression;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        ArrayList<Expression> exps = new ArrayList<Expression>();
        exps.add(this.expression);
        return exps;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        if (this.expression == exp) {
            return literal;
        }
        return this;
    }

    @Override
    public Formula simplify() {
        return this;
    }

    @Override
    public double getSelectivity() {
        VertexEvaluator<Expression> veval = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.expression);
        double selectivity = veval.calculateEstimatedSelectivity();
        logger.finer("selectivity[" + this + "] = " + selectivity);
        return selectivity;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NonConstantTerm) {
            NonConstantTerm nct = (NonConstantTerm)o;
            return this.expression == nct.expression;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.expression.hashCode();
    }
}

