/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class VariableDeclarationOrderUnit
implements Comparable<VariableDeclarationOrderUnit> {
    private final Variable variable;
    private final Declaration declaringDeclaration;
    private final Set<Vertex> dependentVertices;
    private long variableValueChangeCosts = Long.MIN_VALUE;
    private long typeExpressionCardinality = Long.MIN_VALUE;
    private final GreqlQuery query;
    private final SimpleDeclaration simpleDeclarationOfVariable;
    private final Expression typeExpressionOfVariable;

    VariableDeclarationOrderUnit(Variable var, Declaration declaringDecl, GreqlQuery query) {
        this.variable = var;
        this.declaringDeclaration = declaringDecl;
        this.query = query;
        this.simpleDeclarationOfVariable = this.variable.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega();
        this.typeExpressionOfVariable = this.simpleDeclarationOfVariable.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.dependentVertices = new HashSet<Vertex>();
        this.addDependendVertices(this.variable);
        while (this.extendDependendVertices()) {
        }
    }

    private void addDependendVertices(Vertex vertex) {
        if (vertex == this.simpleDeclarationOfVariable || vertex == this.declaringDeclaration) {
            return;
        }
        if (this.variable != vertex) {
            this.dependentVertices.add(vertex);
        }
        for (Edge e : vertex.incidences(EdgeDirection.OUT)) {
            this.addDependendVertices(e.getOmega());
        }
    }

    private boolean extendDependendVertices() {
        boolean extensionWasNeeded = false;
        ArrayList<Vertex> list = new ArrayList<Vertex>(this.dependentVertices.size());
        for (Vertex v : this.dependentVertices) {
            list.add(v);
        }
        for (Vertex v : list) {
            SimpleDeclaration sd;
            if (!(v instanceof SimpleDeclaration) || (sd = (SimpleDeclaration)v) == this.simpleDeclarationOfVariable) continue;
            for (Variable var : sd.get_declaredVar()) {
                if (this.dependentVertices.contains(var)) continue;
                extensionWasNeeded = true;
                this.addDependendVertices(var);
            }
        }
        return extensionWasNeeded;
    }

    long getVariableValueChangeCosts() {
        if (this.variableValueChangeCosts == Long.MIN_VALUE) {
            this.variableValueChangeCosts = this.calculateVariableValueChangeCosts();
        }
        return this.variableValueChangeCosts;
    }

    private int calculateVariableValueChangeCosts() {
        int costs = 0;
        for (Vertex vertex : this.dependentVertices) {
            VertexEvaluator<GreqlVertex> eval = ((GreqlQueryImpl)this.query).getVertexEvaluator((GreqlVertex)vertex);
            assert (eval != null);
            costs = (int)((long)costs + eval.getOwnEvaluationCosts());
        }
        return costs;
    }

    Expression getTypeExpressionOfVariable() {
        return this.typeExpressionOfVariable;
    }

    public String toString() {
        return this.dependentVertices.size() + " Expressions depend on " + this.variable + " (" + this.variable.get_name() + ") resulting in costs of " + this.getVariableValueChangeCosts() + " on value changes.";
    }

    @Override
    public int compareTo(VariableDeclarationOrderUnit o) {
        long otherCard;
        if (this == o) {
            return 0;
        }
        if (this.dependentVertices.contains(o.variable)) {
            assert (!o.dependentVertices.contains(this.variable)) : "Circular dependency!";
            return -1;
        }
        if (o.dependentVertices.contains(this.variable)) {
            assert (!this.dependentVertices.contains(o.variable)) : "Circular dependency!";
            return 1;
        }
        if (this.getVariableValueChangeCosts() < o.getVariableValueChangeCosts()) {
            return 1;
        }
        if (this.getVariableValueChangeCosts() > o.getVariableValueChangeCosts()) {
            return -1;
        }
        long thisCard = this.getTypeExpressionCardinality();
        if (thisCard > (otherCard = o.getTypeExpressionCardinality())) {
            return 1;
        }
        if (thisCard < otherCard) {
            return -1;
        }
        if (this.variable.getId() < o.getVariable().getId()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableDeclarationOrderUnit)) {
            return false;
        }
        return this.compareTo((VariableDeclarationOrderUnit)o) == 0;
    }

    public int hashCode() {
        int x = 991;
        return x * this.variable.hashCode() + x;
    }

    private long calculateTypeExpressionCardinality() {
        VertexEvaluator<Expression> veval = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.typeExpressionOfVariable);
        return veval.getEstimatedCardinality();
    }

    long getTypeExpressionCardinality() {
        if (this.typeExpressionCardinality == Long.MIN_VALUE) {
            this.typeExpressionCardinality = this.calculateTypeExpressionCardinality();
        }
        return this.typeExpressionCardinality;
    }

    SimpleDeclaration getSimpleDeclarationOfVariable() {
        return this.simpleDeclarationOfVariable;
    }

    Variable getVariable() {
        return this.variable;
    }

    Declaration getDeclaringDeclaration() {
        return this.declaringDeclaration;
    }
}

