/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class PathExistenceOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(PathExistenceOptimizer.class);
    private GreqlGraph syntaxgraph;
    private boolean anOptimizationWasDone = false;

    public PathExistenceOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof PathExistenceOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        if (syntaxgraph.getFirstVertex(PathExistence.VC) == null) {
            return false;
        }
        this.anOptimizationWasDone = false;
        this.syntaxgraph = syntaxgraph;
        this.runOptimization();
        OptimizerUtility.createMissingSourcePositions(syntaxgraph);
        return this.anOptimizationWasDone;
    }

    private void runOptimization() {
        Set<PathExistence> pathExistenceVertices = this.collectPathExistenceVertices();
        for (PathExistence pe : pathExistenceVertices) {
            this.maybeTransformPathExistence(pe);
        }
    }

    private void maybeTransformPathExistence(PathExistence pe) {
        Expression startExp = pe.getFirstIsStartExprOfIncidence(EdgeDirection.IN).getAlpha();
        Expression targetExp = pe.getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getAlpha();
        if (startExp instanceof Variable && targetExp instanceof Variable) {
            Variable s = (Variable)startExp;
            Variable t = (Variable)targetExp;
            if (s.getFirstIsBoundVarOfIncidence() != null && t.getFirstIsBoundVarOfIncidence() != null) {
                logger.finer(this.optimizerHeaderString() + "PathExistence has form var1 --> var2 where both vars are externally bound, skipping...");
            }
        }
        Comparator<Variable> comparator = new Comparator<Variable>(){

            @Override
            public int compare(Variable v1, Variable v2) {
                if (v1 == v2) {
                    return 0;
                }
                if (PathExistenceOptimizer.this.isDeclaredBefore(v1, v2)) {
                    return -1;
                }
                return 1;
            }
        };
        TreeSet<Variable> startExpVars = new TreeSet<Variable>(comparator);
        startExpVars.addAll(OptimizerUtility.collectInternallyDeclaredVariablesBelow(startExp));
        TreeSet<Variable> targetExpVars = new TreeSet<Variable>(comparator);
        targetExpVars.addAll(OptimizerUtility.collectInternallyDeclaredVariablesBelow(targetExp));
        if (startExpVars.isEmpty() && targetExpVars.isEmpty()) {
            return;
        }
        if (startExpVars.isEmpty() || !targetExpVars.isEmpty() && this.isDeclaredBefore(startExpVars.last(), targetExpVars.last())) {
            this.replacePathExistenceWithContainsFunApp(pe, startExp, targetExp, true);
        } else if (targetExpVars.isEmpty() || !startExpVars.isEmpty() && this.isDeclaredBefore(targetExpVars.last(), startExpVars.last())) {
            this.replacePathExistenceWithContainsFunApp(pe, targetExp, startExp, false);
        }
    }

    private void replacePathExistenceWithContainsFunApp(PathExistence pe, Expression startOrTargetExp, Expression otherExp, boolean forward) {
        PathExpression vertexSet;
        logger.finer(this.optimizerHeaderString() + "Replacing " + pe + " with a contains FunctionApplication using a " + (forward ? "Forward" : "Backward") + "VertexSet.");
        this.anOptimizationWasDone = true;
        HashSet<Edge> edgesToRelink = new HashSet<Edge>();
        for (Edge inc = pe.getFirstIncidence(EdgeDirection.OUT); inc != null; inc = inc.getNextIncidence(EdgeDirection.OUT)) {
            edgesToRelink.add(inc);
        }
        FunctionApplication contains = this.syntaxgraph.createFunctionApplication();
        FunctionId containsId = OptimizerUtility.findOrCreateFunctionId("contains", this.syntaxgraph);
        this.syntaxgraph.createIsFunctionIdOf(containsId, contains);
        if (forward) {
            vertexSet = this.syntaxgraph.createForwardVertexSet();
            this.syntaxgraph.createIsStartExprOf(startOrTargetExp, vertexSet);
        } else {
            vertexSet = this.syntaxgraph.createBackwardVertexSet();
            this.syntaxgraph.createIsTargetExprOf(startOrTargetExp, vertexSet);
        }
        this.syntaxgraph.createIsPathOf(pe.getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha(), vertexSet);
        this.syntaxgraph.createIsArgumentOf(vertexSet, contains);
        this.syntaxgraph.createIsArgumentOf(otherExp, contains);
        for (Edge edge : edgesToRelink) {
            edge.setAlpha(contains);
        }
        pe.delete();
    }

    private Set<PathExistence> collectPathExistenceVertices() {
        HashSet<PathExistence> pathExistenceVertices = new HashSet<PathExistence>();
        for (PathExistence pe : this.syntaxgraph.getPathExistenceVertices()) {
            pathExistenceVertices.add(pe);
        }
        return pathExistenceVertices;
    }
}

