/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.ThisLiteral;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.HashSet;
import java.util.Set;
import org.pcollections.PVector;

public class OptimizerUtility {
    public static boolean isAbove(Vertex v1, Vertex v2) {
        if (v1 == v2) {
            return true;
        }
        for (Edge inc : v1.incidences(EdgeDirection.IN)) {
            if (!OptimizerUtility.isAbove(inc.getAlpha(), v2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnd(FunctionApplication funApp) {
        return funApp.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("and");
    }

    public static boolean isOr(FunctionApplication funApp) {
        return funApp.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("or");
    }

    public static boolean isXor(FunctionApplication funApp) {
        return funApp.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("xor");
    }

    public static boolean isNot(FunctionApplication funApp) {
        return funApp.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("not");
    }

    public static void mergeSourcePositions(GreqlAggregation from, GreqlAggregation to) {
        PVector<SourcePosition> toSourcePositions = to.get_sourcePositions();
        if (toSourcePositions == null) {
            toSourcePositions = JGraLab.vector();
        }
        for (SourcePosition sp : from.get_sourcePositions()) {
            if (toSourcePositions.contains(sp)) continue;
            toSourcePositions = toSourcePositions.plus(sp);
        }
        to.set_sourcePositions(toSourcePositions);
    }

    public static FunctionId findOrCreateFunctionId(String name, GreqlGraph graph) {
        for (FunctionId fid : graph.getFunctionIdVertices()) {
            if (!fid.get_name().equals(name)) continue;
            return fid;
        }
        FunctionId fid = graph.createFunctionId();
        fid.set_name(name);
        return fid;
    }

    public static void createMissingSourcePositions(GreqlGraph graph) {
        for (GreqlAggregation aggr : graph.getGreqlAggregationEdges()) {
            if (aggr.get_sourcePositions() != null) continue;
            PVector<SourcePosition> l = JGraLab.vector();
            aggr.set_sourcePositions(l);
        }
    }

    public static Set<Variable> collectVariablesDeclaredBy(SimpleDeclaration sd) {
        HashSet<Variable> vars = new HashSet<Variable>();
        for (IsDeclaredVarOf inc : sd.getIsDeclaredVarOfIncidences(EdgeDirection.IN)) {
            vars.add(inc.getAlpha());
        }
        return vars;
    }

    public static Set<Variable> collectInternallyDeclaredVariablesBelow(Vertex vertex) {
        return OptimizerUtility.collectInternallyDeclaredVariablesBelow(vertex, new HashSet<Variable>());
    }

    private static Set<Variable> collectInternallyDeclaredVariablesBelow(Vertex vertex, Set<Variable> vars) {
        if (vertex instanceof Variable && !(vertex instanceof ThisLiteral)) {
            Variable v = (Variable)vertex;
            if (v.getFirstIsBoundVarOfIncidence(EdgeDirection.OUT) == null) {
                vars.add(v);
            }
            return vars;
        }
        for (Edge inc : vertex.incidences(EdgeDirection.IN)) {
            OptimizerUtility.collectInternallyDeclaredVariablesBelow(inc.getAlpha(), vars);
        }
        return vars;
    }

    public static void deleteOrphanedVerticesBelow(Vertex vertex, HashSet<Vertex> verticesToOmit) {
        OptimizerUtility.deleteOrphanedVerticesBelow(vertex, verticesToOmit, new HashSet<Vertex>());
    }

    private static void deleteOrphanedVerticesBelow(Vertex vertex, HashSet<Vertex> verticesToOmit, HashSet<Vertex> alreadyDeletedVertices) {
        assert (vertex.isValid());
        if (alreadyDeletedVertices.contains(vertex)) {
            return;
        }
        HashSet<Vertex> nextOrphans = new HashSet<Vertex>();
        for (Edge inc : vertex.incidences(EdgeDirection.IN)) {
            nextOrphans.add(inc.getAlpha());
        }
        if (vertex.getFirstIncidence(EdgeDirection.OUT) == null && !verticesToOmit.contains(vertex)) {
            alreadyDeletedVertices.add(vertex);
            vertex.delete();
            for (Vertex v : nextOrphans) {
                OptimizerUtility.deleteOrphanedVerticesBelow(v, verticesToOmit, alreadyDeletedVertices);
            }
        }
    }
}

