/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

@NeedsGraphArgument
public class VertexTypeSubgraph
extends Function {
    @Description(params={"graph", "typeCollection"}, description="Returns the subgraph induced by the vertex types in typeCollection, i.e. all vertices specified by typeCollection together with all edges between those vertices.", categories={Function.Category.GRAPH})
    public VertexTypeSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, TypeCollection typeCollection) {
        SubGraphMarker subgraphMarker = new SubGraphMarker(graph);
        for (Vertex currentVertex = graph.getFirstVertex(); currentVertex != null; currentVertex = currentVertex.getNextVertex()) {
            if (!typeCollection.acceptsType(currentVertex.getAttributedElementClass())) continue;
            subgraphMarker.mark(currentVertex);
        }
        for (Edge currentEdge = graph.getFirstEdge(); currentEdge != null; currentEdge = currentEdge.getNextEdge()) {
            if (!subgraphMarker.isMarked(currentEdge.getAlpha()) || !subgraphMarker.isMarked(currentEdge.getOmega())) continue;
            subgraphMarker.mark(currentEdge);
        }
        return subgraphMarker;
    }
}

