/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import org.pcollections.ArrayPMap;
import org.pcollections.ArrayPSet;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class Union
extends Function {
    @Description(params={"a", "b"}, description="Computes the union of the given two sets.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> a, PSet<T> b) {
        if (b.isEmpty()) {
            if (a instanceof ArrayPSet) {
                return a;
            }
            return JGraLab.set();
        }
        if (a instanceof ArrayPSet) {
            return ((ArrayPSet)a).plusAll(b);
        }
        return JGraLab.set().plusAll(a).plusAll(b);
    }

    @Description(params={"a", "b"}, description="Computes the union of the given maps.\nIn case of common keys in maps, the entries of the second one override the first one's entries.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> PMap<K, V> evaluate(PMap<K, V> a, PMap<K, V> b) {
        if (b.isEmpty()) {
            if (a instanceof ArrayPMap) {
                return a;
            }
            return JGraLab.map();
        }
        if (a instanceof ArrayPMap) {
            return ((ArrayPMap)a).plusAll(b);
        }
        return JGraLab.map().plusAll(a).plusAll(b);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0) + inElements.get(1);
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return inElements;
    }
}

